/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.encoding;

import com.intellij.largeFilesEditor.encoding.ChangeFileEncodingAction;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccess;
import com.intellij.largeFilesEditor.encoding.LargeFileEditorAccessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EncodingWidget
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    public static final String WIDGET_ID = "lfeEncoding";
    private static final Logger logger = Logger.getInstance(EncodingWidget.class);
    private final TextPanel myComponent;
    private Alarm myUpdateAlarm;
    private final LargeFileEditorAccessor myLargeFileEditorAccessor;
    private boolean myActionEnabled;

    public EncodingWidget(@NotNull Project project, LargeFileEditorAccessor largeFileEditorAccessor) {
        super(project);
        this.myLargeFileEditorAccessor = largeFileEditorAccessor;
        this.myComponent = new TextPanel.WithIconAndArrows();
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        this.requestUpdate();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        this.requestUpdate();
    }

    public StatusBarWidget copy() {
        return new EncodingWidget(this.getProject(), this.myLargeFileEditorAccessor);
    }

    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return null;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        super.install(statusBar);
        this.myUpdateAlarm = new Alarm((Disposable)this);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                EncodingWidget.this.requestUpdate();
                EncodingWidget.this.tryShowPopup();
                return true;
            }
        }.installOn((Component)((Object)this.myComponent), true);
    }

    private void tryShowPopup() {
        if (!this.myActionEnabled) {
            return;
        }
        LargeFileEditorAccess largeFileEditorAccess = this.myLargeFileEditorAccessor.getAccess(this.getProject(), this.myStatusBar);
        if (largeFileEditorAccess != null) {
            this.showPopup(largeFileEditorAccess);
        } else {
            logger.warn("[LargeFileEditorSubsystem] EncodingWidget.tryShowPopup(): this method was called while LargeFileEditor is not available as active text editor");
            this.requestUpdate();
        }
    }

    private void showPopup(@NotNull LargeFileEditorAccess largeFileEditorAccess) {
        ChangeFileEncodingAction action2 = new ChangeFileEncodingAction(this.myLargeFileEditorAccessor, this.getProject(), this.myStatusBar);
        JComponent where = this.getComponent();
        ListPopup popup2 = action2.createPopup(largeFileEditorAccess.getVirtualFile(), largeFileEditorAccess.getEditor(), where);
        RelativePoint pos = JBPopupFactory.getInstance().guessBestPopupLocation(where);
        popup2.showInScreenCoordinates((Component)where, pos.getScreenPoint());
    }

    public Project _getProject() {
        return this.getProject();
    }

    public void requestUpdate() {
        if (this.myUpdateAlarm.isDisposed()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> this.update(), 200, ModalityState.any());
    }

    private void update() {
        String charsetName;
        String toolTipText;
        if (this.isDisposed()) {
            return;
        }
        LargeFileEditorAccess largeFileEditorAccess = this.myLargeFileEditorAccessor.getAccess(this.getProject(), this.myStatusBar);
        this.myActionEnabled = false;
        if (largeFileEditorAccess == null) {
            toolTipText = "";
            charsetName = "";
            this.myComponent.setVisible(false);
        } else {
            this.myActionEnabled = true;
            charsetName = largeFileEditorAccess.getCharsetName();
            toolTipText = EditorBundle.message((String)"large.file.editor.tooltip.file.encoding.is.some", (Object[])new Object[]{charsetName});
            this.myComponent.setVisible(true);
        }
        this.myComponent.setToolTipText(toolTipText);
        this.myComponent.setText(charsetName);
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        } else {
            logger.warn("[LargeFileEditorSubsystem] EncodingWidget.requestUpdate(): myStatusBar is null!!!)");
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }
}

