/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LargeFileRegexSearchNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"large.file.editor.regex.search.notification");
    private static final Key<String> HIDDEN_KEY = Key.create((String)"large.file.editor.regex.search.notification.hidden");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (!(fileEditor instanceof LargeFileEditor)) {
            return null;
        }
        LargeFileEditor largeFileEditor = (LargeFileEditor)fileEditor;
        Editor editor = largeFileEditor.getEditor();
        if (editor.getUserData(HIDDEN_KEY) != null) {
            return null;
        }
        if (!largeFileEditor.getSearchManager().canShowRegexSearchWarning()) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.createActionLabel(EditorBundle.message((String)"notification.hide.message", (Object[])new Object[0]), () -> {
            editor.putUserData(HIDDEN_KEY, (Object)"true");
            LargeFileRegexSearchNotificationProvider.update(file2, project);
        });
        return panel2.text(EditorBundle.message((String)"message.warning.about.regex.search.limitations", (Object[])new Object[]{String.valueOf(largeFileEditor.getPageSize() / 500)}));
    }

    private static void update(@NotNull VirtualFile file2, @NotNull Project project) {
        EditorNotifications.getInstance((Project)project).updateNotifications(file2);
    }
}

