/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LargeFileNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"large.file.editor.notification");
    private static final Key<String> HIDDEN_KEY = Key.create((String)"large.file.editor.notification.hidden");
    private static final String DISABLE_KEY = "large.file.editor.notification.disabled";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (!(fileEditor instanceof LargeFileEditor)) {
            return null;
        }
        Editor editor = ((LargeFileEditor)fileEditor).getEditor();
        if (editor.getUserData(HIDDEN_KEY) != null || PropertiesComponent.getInstance().isTrueValue(DISABLE_KEY)) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.createActionLabel(EditorBundle.message((String)"notification.hide.message", (Object[])new Object[0]), () -> {
            editor.putUserData(HIDDEN_KEY, (Object)"true");
            LargeFileNotificationProvider.update(file2, project);
        });
        panel2.createActionLabel(EditorBundle.message((String)"notification.dont.show.again.message", (Object[])new Object[0]), () -> {
            PropertiesComponent.getInstance().setValue(DISABLE_KEY, "true");
            LargeFileNotificationProvider.update(file2, project);
        });
        return panel2.text(EditorBundle.message((String)"large.file.editor.notification.text.the.file.is.too.large.so.showing.in.read.only.mode", (Object[])new Object[]{StringUtil.formatFileSize((long)file2.getLength())}));
    }

    private static void update(@NotNull VirtualFile file2, @NotNull Project project) {
        EditorNotifications.getInstance((Project)project).updateNotifications(file2);
    }
}

