/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.editor;

import com.intellij.largeFilesEditor.editor.LargeFileEditorImpl;
import com.intellij.largeFilesEditor.editor.LargeFileEditorState;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.impl.DefaultPlatformFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class LargeFileEditorProvider
implements DefaultPlatformFileEditorProvider,
DumbAware {
    public static final String PROVIDER_ID = "LargeFileEditorProvider";
    private static final String CARET_PAGE_NUMBER_ATTR = "caret-page-number";
    private static final String CARET_PAGE_SYMBOL_OFFSET_ATTR = "caret-page-symbol-offset";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        return TextEditorProvider.isTextFile(file2) && SingleRootFileViewProvider.isTooLargeForContentLoading(file2) && Experiments.getInstance().isFeatureEnabled("new.large.text.file.viewer") && !file2.getFileType().isBinary() && file2.isInLocalFileSystem();
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        return new LargeFileEditorImpl(project, file2);
    }

    @NotNull
    public String getEditorTypeId() {
        return PROVIDER_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.NONE;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state instanceof LargeFileEditorState) {
            targetElement.setAttribute(CARET_PAGE_NUMBER_ATTR, Long.toString(((LargeFileEditorState)state).caretPageNumber));
            targetElement.setAttribute(CARET_PAGE_SYMBOL_OFFSET_ATTR, Integer.toString(((LargeFileEditorState)state).caretSymbolOffsetInPage));
        }
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file2) {
        LargeFileEditorState state = new LargeFileEditorState();
        if (JDOMUtil.isEmpty((Element)sourceElement)) {
            return state;
        }
        state.caretPageNumber = StringUtilRt.parseLong((String)sourceElement.getAttributeValue(CARET_PAGE_NUMBER_ATTR), (long)0L);
        state.caretSymbolOffsetInPage = StringUtilRt.parseInt((String)sourceElement.getAttributeValue(CARET_PAGE_SYMBOL_OFFSET_ATTR), (int)0);
        return state;
    }
}

