/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.lang.LangBundle;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.javascript.boilerplate.GithubProjectGeneratorPeer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.GeneratorException;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.NullableFunction;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGithubTagDownloadedProjectGenerator
extends WebProjectTemplate<GithubTagInfo> {
    private static final Logger LOG = Logger.getInstance(AbstractGithubTagDownloadedProjectGenerator.class);

    @Override
    @NotNull
    @Nls
    public final String getName() {
        return this.getDisplayName();
    }

    @NotNull
    protected abstract String getDisplayName();

    @NotNull
    public abstract String getGithubUserName();

    @NotNull
    public abstract String getGithubRepositoryName();

    @Override
    @Nullable
    public abstract String getDescription();

    private String getTitle() {
        return this.getDisplayName();
    }

    @Override
    @Nullable
    public String getHelpId() {
        return "create.from.template." + this.getGithubUserName() + "." + this.getGithubRepositoryName();
    }

    @Override
    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull GithubTagInfo tag2, @NotNull Module module) {
        try {
            this.unpackToDir(project, VfsUtilCore.virtualToIoFile((VirtualFile)baseDir), tag2);
        }
        catch (GeneratorException e) {
            this.reportError(project, e);
        }
        ApplicationManager.getApplication().runWriteAction(() -> baseDir.refresh(true, true));
    }

    @NotNull
    public GithubProjectGeneratorPeer createPeer() {
        return new GithubProjectGeneratorPeer(this);
    }

    @Override
    public boolean isPrimaryGenerator() {
        return PlatformUtils.isWebStorm();
    }

    private void unpackToDir(@Nullable Project project, @NotNull File extractToDir, @NotNull GithubTagInfo tag2) throws GeneratorException {
        File zipArchiveFile = this.getCacheFile(tag2);
        String primaryUrl = this.getPrimaryZipArchiveUrlForDownload(tag2);
        boolean downloaded = false;
        if (primaryUrl != null) {
            try {
                this.downloadAndUnzip(project, primaryUrl, zipArchiveFile, extractToDir, false);
                downloaded = true;
            }
            catch (GeneratorException e) {
                LOG.info("Can't download " + primaryUrl, (Throwable)e);
                FileUtil.delete((File)zipArchiveFile);
            }
        }
        if (!downloaded) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new GeneratorException(LangBundle.message((String)"dialog.message.download.skipped.in.unit.test.mode", (Object[])new Object[]{tag2.getZipballUrl()}));
            }
            this.downloadAndUnzip(project, tag2.getZipballUrl(), zipArchiveFile, extractToDir, true);
        }
    }

    private void downloadAndUnzip(@Nullable Project project, @NotNull String url, @NotNull File zipArchiveFile, @NotNull File extractToDir, boolean retryOnError) throws GeneratorException {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                File file2 = URLUtil.urlToFile((URL)new URL(url));
                ZipUtil.unzip(null, extractToDir, file2, null, null, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        GithubDownloadUtil.downloadContentToFileWithProgressSynchronously(project, url, this.getTitle(), zipArchiveFile, this.getGithubUserName(), this.getGithubRepositoryName(), retryOnError);
        LOG.info("Content of " + url + " has been successfully downloaded to " + zipArchiveFile.getAbsolutePath() + ", size " + zipArchiveFile.length() + " bytes");
        ZipUtil.unzipWithProgressSynchronously(project, this.getTitle(), zipArchiveFile, extractToDir, this.getPathConvertor(), true);
    }

    @Nullable
    protected NullableFunction<String, String> getPathConvertor() {
        return null;
    }

    @Nullable
    public abstract String getPrimaryZipArchiveUrlForDownload(@NotNull GithubTagInfo var1);

    @NotNull
    private File getCacheFile(@NotNull GithubTagInfo tag2) {
        String fileName = URLUtil.encodeURIComponent((String)(tag2.getName() + ".zip"));
        return GithubDownloadUtil.findCacheFile(this.getGithubUserName(), this.getGithubRepositoryName(), fileName);
    }

    private void reportError(@NotNull Project project, @NotNull GeneratorException e) {
        String message = LangBundle.message((String)"dialog.message.error.creating.project", (Object[])new Object[]{this.getDisplayName()});
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(message, (Throwable)e);
            return;
        }
        LOG.info(message, (Throwable)e);
        String title = LangBundle.message((String)"dialog.title.create.project", (Object[])new Object[]{this.getDisplayName()});
        Messages.showErrorDialog((Project)project, (String)(message + ". " + e.getMessage()), (String)title);
    }

    public ActionLink createGitHubLink() {
        ActionLink link = new ActionLink(LangBundle.message((String)"link.label.on.github", (Object[])new Object[]{this.getName()}), (AnAction)DumbAwareAction.create(e -> BrowserUtil.open((String)("https://github.com/" + this.getGithubUserName() + "/" + this.getGithubRepositoryName()))));
        link.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        return link;
    }
}

