/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.impl;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TokenSequence
implements TokenList {
    private static final Logger LOG = Logger.getInstance(TokenSequence.class);
    private final CharSequence myText;
    final int[] lexStarts;
    final IElementType[] lexTypes;
    final int lexemeCount;

    TokenSequence(int[] lexStarts, IElementType[] lexTypes, int lexemeCount, CharSequence text) {
        this.lexStarts = lexStarts;
        this.lexTypes = lexTypes;
        this.lexemeCount = lexemeCount;
        this.myText = text;
        assert (lexemeCount < lexStarts.length);
        assert (lexemeCount < lexTypes.length);
    }

    void assertMatches(@NotNull CharSequence text, @NotNull Lexer lexer) {
        TokenSequence sequence = new Builder(text, lexer).performLexing();
        assert (this.lexemeCount == sequence.lexemeCount);
        for (int j = 0; j <= this.lexemeCount; ++j) {
            if (sequence.lexStarts[j] != this.lexStarts[j] || sequence.lexTypes[j] != this.lexTypes[j]) assert (false);
        }
    }

    @NotNull
    public static TokenSequence performLexing(@NotNull CharSequence text, @NotNull Lexer lexer) {
        TokenList existing;
        if (lexer instanceof TokenList.WrappingLexer && (existing = ((TokenList.WrappingLexer)lexer).getTokens()) instanceof TokenSequence && Comparing.equal((CharSequence)text, (CharSequence)((TokenSequence)existing).myText)) {
            return new TokenSequence(((TokenSequence)existing).lexStarts, (IElementType[])((TokenSequence)existing).lexTypes.clone(), ((TokenSequence)existing).lexemeCount, text);
        }
        return new Builder(text, lexer).performLexing();
    }

    public int getTokenCount() {
        return this.lexemeCount;
    }

    @Nullable
    public IElementType getTokenType(int index) {
        if (index < 0 || index >= this.getTokenCount()) {
            return null;
        }
        return this.lexTypes[index];
    }

    public int getTokenStart(int index) {
        return this.lexStarts[index];
    }

    public int getTokenEnd(int index) {
        return this.lexStarts[index + 1];
    }

    @NotNull
    public CharSequence getTokenizedText() {
        return this.myText;
    }

    private static class Builder {
        private final CharSequence myText;
        private final Lexer myLexer;
        private int[] myLexStarts;
        private IElementType[] myLexTypes;

        Builder(@NotNull CharSequence text, @NotNull Lexer lexer) {
            this.myText = text;
            this.myLexer = lexer;
            int approxLexCount = Math.max(10, this.myText.length() / 5);
            this.myLexStarts = new int[approxLexCount];
            this.myLexTypes = new IElementType[approxLexCount];
        }

        @NotNull
        TokenSequence performLexing() {
            IElementType type;
            this.myLexer.start(this.myText);
            int i2 = 0;
            int offset = 0;
            while ((type = this.myLexer.getTokenType()) != null) {
                int tokenStart;
                if (i2 % 20 == 0) {
                    ProgressIndicatorProvider.checkCanceled();
                }
                if (i2 >= this.myLexTypes.length - 1) {
                    this.resizeLexemes(i2 * 3 / 2);
                }
                if ((tokenStart = this.myLexer.getTokenStart()) < offset) {
                    this.reportDescendingOffsets(i2, offset, tokenStart);
                }
                this.myLexStarts[i2] = offset = tokenStart;
                this.myLexTypes[i2] = type;
                ++i2;
                this.myLexer.advance();
            }
            this.myLexStarts[i2] = this.myText.length();
            return new TokenSequence(this.myLexStarts, this.myLexTypes, i2, this.myText);
        }

        private void reportDescendingOffsets(int tokenIndex, int offset, int tokenStart) {
            StringBuilder sb = new StringBuilder();
            IElementType tokenType = this.myLexer.getTokenType();
            sb.append("Token sequence broken").append("\n  this: '").append(this.myLexer.getTokenText()).append("' (").append(tokenType).append(':').append(tokenType != null ? tokenType.getLanguage() : null).append(") ").append(tokenStart).append(":").append(this.myLexer.getTokenEnd());
            if (tokenIndex > 0) {
                int prevStart = this.myLexStarts[tokenIndex - 1];
                sb.append("\n  prev: '").append(this.myText.subSequence(prevStart, offset)).append("' (").append(this.myLexTypes[tokenIndex - 1]).append(':').append(this.myLexTypes[tokenIndex - 1].getLanguage()).append(") ").append(prevStart).append(":").append(offset);
            }
            int quoteStart = Math.max(tokenStart - 256, 0);
            int quoteEnd = Math.min(tokenStart + 256, this.myText.length());
            sb.append("\n  quote: [").append(quoteStart).append(':').append(quoteEnd).append("] '").append(this.myText.subSequence(quoteStart, quoteEnd)).append('\'');
            LOG.error((Object)sb);
        }

        private void resizeLexemes(int newSize) {
            this.myLexStarts = ArrayUtil.realloc((int[])this.myLexStarts, (int)newSize);
            this.myLexTypes = (IElementType[])ArrayUtil.realloc((Object[])this.myLexTypes, (int)newSize, (ArrayFactory)IElementType.ARRAY_FACTORY);
        }
    }
}

