/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.impl;

import com.intellij.jps.impl.JpsPluginBean;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.UnknownSourceRootType;
import org.jetbrains.jps.model.module.UnknownSourceRootTypeProperties;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.UnknownSourceRootPropertiesSerializer;
import org.jetbrains.jps.plugin.JpsPluginManager;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.service.impl.JpsServiceManagerImpl;

public final class JpsIdePluginManagerImpl
extends JpsPluginManager {
    private final List<PluginDescriptor> myExternalBuildPlugins = new CopyOnWriteArrayList<PluginDescriptor>();
    private final AtomicInteger myModificationStamp = new AtomicInteger(0);
    private final boolean myFullyLoaded;

    public JpsIdePluginManagerImpl() {
        Application application = ApplicationManager.getApplication();
        boolean bl = this.myFullyLoaded = application != null;
        if (!this.myFullyLoaded) {
            return;
        }
        ExtensionsArea rootArea = application.getExtensionArea();
        if (rootArea.hasExtensionPoint(JpsPluginBean.EP_NAME)) {
            final Ref initial = new Ref((Object)Boolean.TRUE);
            JpsPluginBean.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<JpsPluginBean>(){

                public void extensionAdded(@NotNull JpsPluginBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (((Boolean)initial.get()).booleanValue()) {
                        JpsIdePluginManagerImpl.this.myExternalBuildPlugins.add(pluginDescriptor);
                    } else {
                        JpsIdePluginManagerImpl.this.handlePluginAdded(pluginDescriptor);
                    }
                }

                public void extensionRemoved(@NotNull JpsPluginBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                    JpsIdePluginManagerImpl.this.handlePluginRemoved(pluginDescriptor);
                }
            }, true, null);
            initial.set((Object)Boolean.FALSE);
        }
        if (rootArea.hasExtensionPoint("com.intellij.compileServer.plugin")) {
            ExtensionPoint extensionPoint = rootArea.getExtensionPoint("com.intellij.compileServer.plugin");
            final Ref initial = new Ref((Object)Boolean.TRUE);
            extensionPoint.addExtensionPointListener(new ExtensionPointListener(){

                public void extensionAdded(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                    if (((Boolean)initial.get()).booleanValue()) {
                        JpsIdePluginManagerImpl.this.myExternalBuildPlugins.add(pluginDescriptor);
                    } else {
                        JpsIdePluginManagerImpl.this.handlePluginAdded(pluginDescriptor);
                    }
                }

                public void extensionRemoved(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                    JpsIdePluginManagerImpl.this.handlePluginRemoved(pluginDescriptor);
                }
            }, true, null);
            initial.set((Object)Boolean.FALSE);
        }
    }

    public boolean isFullyLoaded() {
        return this.myFullyLoaded;
    }

    private void handlePluginRemoved(@NotNull PluginDescriptor pluginDescriptor) {
        if (!this.myExternalBuildPlugins.contains(pluginDescriptor)) {
            return;
        }
        HashMap<Object, JpsModuleSourceRootPropertiesSerializer> removed = new HashMap<Object, JpsModuleSourceRootPropertiesSerializer>();
        for (JpsModelSerializerExtension extension : this.loadExtensions(JpsModelSerializerExtension.class)) {
            for (JpsModuleSourceRootPropertiesSerializer serializer : extension.getModuleSourceRootPropertiesSerializers()) {
                removed.put(serializer.getType(), serializer);
            }
        }
        for (JpsModelSerializerExtension extension : this.loadExtensions(JpsModelSerializerExtension.class, descriptor2 -> !descriptor2.equals(pluginDescriptor))) {
            for (JpsModuleSourceRootPropertiesSerializer serializer : extension.getModuleSourceRootPropertiesSerializers()) {
                removed.remove(serializer.getType());
            }
        }
        if (!removed.isEmpty()) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                JpsIdePluginManagerImpl.replaceWithUnknownRootType(project, removed.values());
            }
        }
        this.myExternalBuildPlugins.remove(pluginDescriptor);
        this.myModificationStamp.incrementAndGet();
        JpsServiceManager jpsServiceManager = JpsServiceManager.getInstance();
        if (jpsServiceManager instanceof JpsServiceManagerImpl) {
            ((JpsServiceManagerImpl)jpsServiceManager).cleanupExtensionCache();
        }
    }

    private void handlePluginAdded(@NotNull PluginDescriptor pluginDescriptor) {
        if (this.myExternalBuildPlugins.contains(pluginDescriptor)) {
            return;
        }
        HashSet<String> before = new HashSet<String>();
        for (JpsModelSerializerExtension extension : this.loadExtensions(JpsModelSerializerExtension.class)) {
            for (JpsModuleSourceRootPropertiesSerializer serializer : extension.getModuleSourceRootPropertiesSerializers()) {
                before.add(serializer.getTypeId());
            }
        }
        this.myExternalBuildPlugins.add(pluginDescriptor);
        this.myModificationStamp.incrementAndGet();
        HashMap<String, JpsModuleSourceRootPropertiesSerializer> added = new HashMap<String, JpsModuleSourceRootPropertiesSerializer>();
        for (JpsModelSerializerExtension extension : this.loadExtensions(JpsModelSerializerExtension.class)) {
            for (JpsModuleSourceRootPropertiesSerializer serializer : extension.getModuleSourceRootPropertiesSerializers()) {
                added.put(serializer.getTypeId(), serializer);
            }
        }
        added.keySet().removeAll(before);
        if (!added.isEmpty()) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                JpsIdePluginManagerImpl.updateCustomRootTypes(project, added.values());
            }
        }
    }

    private static void replaceWithUnknownRootType(Project project, Collection<JpsModuleSourceRootPropertiesSerializer<?>> unregisteredSerializers) {
        if (unregisteredSerializers.isEmpty()) {
            return;
        }
        HashMap serializers = new HashMap();
        for (JpsModuleSourceRootPropertiesSerializer<?> serializer : unregisteredSerializers) {
            serializers.put(serializer.getType(), serializer);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootModificationUtil.modifyModel((Module)module, model -> {
                boolean shouldCommit = false;
                for (ContentEntry contentEntry : model.getContentEntries()) {
                    for (SourceFolder folder : contentEntry.getSourceFolders()) {
                        JpsModuleSourceRootPropertiesSerializer removedSerializer = (JpsModuleSourceRootPropertiesSerializer)serializers.get(folder.getRootType());
                        if (removedSerializer == null) continue;
                        JpsIdePluginManagerImpl.changeType(folder, UnknownSourceRootPropertiesSerializer.forType((String)removedSerializer.getTypeId()), JpsIdePluginManagerImpl.serializeProperties(folder, removedSerializer));
                        shouldCommit = true;
                    }
                }
                return shouldCommit;
            });
        }
    }

    private static void updateCustomRootTypes(Project project, Collection<JpsModuleSourceRootPropertiesSerializer<?>> registeredSerializers) {
        if (registeredSerializers.isEmpty()) {
            return;
        }
        HashMap serializers = new HashMap();
        for (JpsModuleSourceRootPropertiesSerializer<?> ser : registeredSerializers) {
            serializers.put(ser.getTypeId(), ser);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            HashMap<SourceFolder, Pair> foldersToUpdate = new HashMap<SourceFolder, Pair>();
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                for (SourceFolder folder : contentEntry.getSourceFolders()) {
                    UnknownSourceRootType type;
                    JpsModuleSourceRootPropertiesSerializer serializer;
                    if (!(folder.getRootType() instanceof UnknownSourceRootType) || (serializer = (JpsModuleSourceRootPropertiesSerializer)serializers.get((type = (UnknownSourceRootType)folder.getRootType()).getUnknownTypeId())) == null) continue;
                    UnknownSourceRootTypeProperties properties = (UnknownSourceRootTypeProperties)folder.getJpsElement().getProperties((JpsModuleSourceRootType)type);
                    Object data2 = properties != null ? properties.getPropertiesData() : null;
                    foldersToUpdate.put(folder, new Pair((Object)serializer, (Object)(data2 instanceof Element ? (Element)data2 : null)));
                }
            }
            if (foldersToUpdate.isEmpty()) continue;
            ModuleRootModificationUtil.updateModel((Module)module, model -> {
                for (ContentEntry contentEntry : model.getContentEntries()) {
                    for (SourceFolder folder : contentEntry.getSourceFolders()) {
                        Pair pair = (Pair)foldersToUpdate.get(folder);
                        if (pair == null) continue;
                        JpsIdePluginManagerImpl.changeType(folder, (JpsModuleSourceRootPropertiesSerializer)pair.first, (Element)pair.second);
                    }
                }
            });
        }
    }

    @Nullable
    private static <P extends JpsElement> Element serializeProperties(SourceFolder root, @NotNull JpsModuleSourceRootPropertiesSerializer<P> serializer) {
        JpsElement properties = root.getJpsElement().getProperties((JpsModuleSourceRootType)serializer.getType());
        if (properties != null) {
            Element sourceElement = new Element("sourceFolder");
            serializer.saveProperties(properties, sourceElement);
            return sourceElement;
        }
        return null;
    }

    private static <P extends JpsElement> void changeType(SourceFolder root, @NotNull JpsModuleSourceRootPropertiesSerializer<P> serializer, @Nullable Element serializedProps) {
        root.changeType((JpsModuleSourceRootType)serializer.getType(), serializedProps != null ? serializer.loadProperties(serializedProps) : (JpsElement)((JpsModuleSourceRootType)serializer.getType()).createDefaultProperties());
    }

    public int getModificationStamp() {
        if (!this.myFullyLoaded && this.myModificationStamp.get() == 0 && ApplicationManager.getApplication() != null) {
            this.myModificationStamp.compareAndSet(0, 1);
        }
        return this.myModificationStamp.get();
    }

    @NotNull
    public <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass) {
        return this.loadExtensions(extensionClass, null);
    }

    @NotNull
    private <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass, @Nullable Predicate<PluginDescriptor> filter2) {
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        for (PluginDescriptor plugin : this.myExternalBuildPlugins) {
            if (filter2 != null && !filter2.test(plugin)) continue;
            ContainerUtil.addIfNotNull(loaders, (Object)plugin.getPluginClassLoader());
        }
        if (loaders.isEmpty()) {
            loaders.add(((Object)((Object)this)).getClass().getClassLoader());
        }
        return JpsIdePluginManagerImpl.loadExtensionsFrom(loaders, extensionClass);
    }

    @NotNull
    private static <T> Collection<T> loadExtensionsFrom(@NotNull Collection<ClassLoader> loaders, @NotNull Class<T> extensionClass) {
        if (loaders.isEmpty()) {
            return Collections.emptyList();
        }
        String resourceName = "META-INF/services/" + extensionClass.getName();
        LinkedHashSet classes = new LinkedHashSet();
        HashSet<String> loadedUrls = new HashSet<String>();
        for (ClassLoader loader : loaders) {
            try {
                Enumeration<URL> resources = loader.getResources(resourceName);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    if (!loadedUrls.add(url.toExternalForm())) continue;
                    JpsIdePluginManagerImpl.loadImplementations(url, loader, classes);
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError("Cannot load configuration files for " + extensionClass.getName(), e);
            }
        }
        ArrayList<T> extensions2 = new ArrayList<T>();
        for (Class aClass : classes) {
            try {
                extensions2.add(extensionClass.cast(aClass.newInstance()));
            }
            catch (Exception e) {
                throw new ServiceConfigurationError("Class " + aClass.getName() + " cannot be instantiated", e);
            }
        }
        return extensions2;
    }

    private static <T> void loadImplementations(URL url, ClassLoader loader, Set<? super Class<T>> result2) throws IOException {
        for (String name : JpsIdePluginManagerImpl.loadClassNames(url)) {
            try {
                result2.add(Class.forName(name, false, loader));
            }
            catch (ClassNotFoundException e) {
                throw new ServiceConfigurationError("Cannot find class " + name, e);
            }
        }
    }

    private static List<String> loadClassNames(URL url) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                int i2 = line.indexOf(35);
                if (i2 >= 0) {
                    line = line.substring(0, i2);
                }
                if ((line = line.trim()).isEmpty()) continue;
                result2.add(line);
            }
        }
        return result2;
    }
}

