/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectIntHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JpsElementPropertiesSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;

public class ProjectStructureUsageCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "project.structure";
    }

    public int getVersion() {
        return 3;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        Module[] modules2;
        Map typeNames = JBIterable.from((Iterable)JpsModelSerializerExtension.getExtensions()).filter(o -> PluginInfoDetectorKt.getPluginInfo(o.getClass()).isDevelopedByJetBrains()).flatMap(JpsModelSerializerExtension::getModuleSourceRootPropertiesSerializers).toMap(JpsElementPropertiesSerializer::getType, JpsElementPropertiesSerializer::getTypeId);
        int contentRoots = 0;
        int sourceRoots = 0;
        int excludedRoots = 0;
        int packagePrefix = 0;
        TObjectIntHashMap types = new TObjectIntHashMap();
        for (Module module : modules2 = ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            contentRoots += rootManager.getContentEntries().length;
            sourceRoots += rootManager.getSourceRoots(true).length;
            excludedRoots += rootManager.getExcludeRoots().length;
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder source : entry.getSourceFolders()) {
                    String key2;
                    if (StringUtil.isNotEmpty((String)source.getPackagePrefix())) {
                        ++packagePrefix;
                    }
                    if ((key2 = (String)typeNames.get(source.getRootType())) == null || types.increment((Object)key2)) continue;
                    types.put((Object)key2, 1);
                }
            }
        }
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"modules.total", (int)modules2.length));
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"content.roots.total", (int)contentRoots));
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"source.roots.total", (int)sourceRoots));
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"excluded.roots.total", (int)excludedRoots));
        types.forEachEntry((key, count) -> result2.add(MetricEventFactoryKt.newCounterMetric((String)"source.root", (int)count, (FeatureUsageData)new FeatureUsageData().addData("type", key))));
        if (PlatformUtils.isIntelliJ()) {
            result2.add(MetricEventFactoryKt.newCounterMetric((String)"package.prefix", (int)packagePrefix));
        }
        NamedScope[] localScopes = NamedScopeManager.getInstance((Project)project).getEditableScopes();
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"named.scopes.total.local", (int)localScopes.length));
        NamedScope[] sharedScopes = DependencyValidationManager.getInstance((Project)project).getEditableScopes();
        result2.add(MetricEventFactoryKt.newCounterMetric((String)"named.scopes.total.shared", (int)sharedScopes.length));
        return result2;
    }
}

