/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.ide.actions.ToolWindowMoveAction;
import com.intellij.ide.actions.ToolWindowViewModeAction;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAllowlistEP;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowCollector {
    private static final ToolWindowInfo UNKNOWN = new ToolWindowInfo("unknown", PluginInfoDetectorKt.getUnknownPlugin());
    private static final Map<String, ToolWindowInfo> ourToolwindowWhitelist = new HashMap<String, ToolWindowInfo>();

    public static ToolWindowCollector getInstance() {
        return (ToolWindowCollector)ServiceManager.getService(ToolWindowCollector.class);
    }

    private ToolWindowCollector() {
        for (ToolWindowAllowlistEP extension : ToolWindowAllowlistEP.EP_NAME.getExtensionList()) {
            ToolWindowCollector.addToolwindowToWhitelist(extension);
        }
        ToolWindowAllowlistEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ToolWindowAllowlistEP>(){

            public void extensionAdded(@NotNull ToolWindowAllowlistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                ToolWindowCollector.addToolwindowToWhitelist(extension);
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    private static void addToolwindowToWhitelist(ToolWindowAllowlistEP extension) {
        PluginInfo info;
        PluginDescriptor pluginDescriptor = extension == null ? null : extension.getPluginDescriptor();
        PluginInfo pluginInfo = info = pluginDescriptor != null ? PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor) : null;
        if (info != null && info.isDevelopedByJetBrains()) {
            ourToolwindowWhitelist.put(extension.id, new ToolWindowInfo(extension.id, info));
        }
    }

    public void recordActivation(@Nullable String toolWindowId, @Nullable WindowInfoImpl info) {
        ToolWindowCollector.record(toolWindowId, ToolWindowEventType.ACTIVATED, info);
    }

    public void recordHidden(@NotNull WindowInfoImpl info) {
        ToolWindowCollector.record(info.getId(), ToolWindowEventType.HIDDEN, info);
    }

    public void recordShown(@NotNull WindowInfoImpl info) {
        ToolWindowCollector.record(info.getId(), ToolWindowEventType.SHOWN, info);
    }

    public void recordClick(String toolWindowId, @Nullable WindowInfoImpl info) {
        ToolWindowCollector.record(toolWindowId, ToolWindowEventType.CLICKED, info);
    }

    private static void record(@Nullable String toolWindowId, @NotNull ToolWindowEventType eventType, @Nullable WindowInfoImpl windowInfo) {
        if (StringUtil.isEmpty((String)toolWindowId)) {
            return;
        }
        ToolWindowInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId);
        FeatureUsageData data2 = new FeatureUsageData().addData("id", info.myRecordedId).addPluginInfo(info.myPluginInfo);
        if (windowInfo != null) {
            data2.addData("ViewMode", ToolWindowViewModeAction.ViewMode.fromWindowInfo(windowInfo).toString());
            data2.addData("Location", ToolWindowMoveAction.Anchor.fromWindowInfo(windowInfo).toString());
        }
        FUCounterUsageLogger.getInstance().logEvent("toolwindow", StringUtil.toLowerCase((String)eventType.name()), data2);
    }

    @NotNull
    private static ToolWindowInfo getToolWindowInfo(@NotNull String toolWindowId) {
        if (ourToolwindowWhitelist.containsKey(toolWindowId)) {
            return ourToolwindowWhitelist.get(toolWindowId);
        }
        ToolWindowInfo info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])ToolWindowEP.EP_NAME.getExtensions());
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        if (info == null) {
            info = ToolWindowCollector.getToolWindowInfo(toolWindowId, (ToolWindowEP[])FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensions());
        }
        return info != null ? info : UNKNOWN;
    }

    @Nullable
    public static ToolWindowInfo getToolWindowInfo(@NotNull String toolWindowId, ToolWindowEP @NotNull [] toolWindows) {
        for (ToolWindowEP ep2 : toolWindows) {
            if (!StringUtil.equals((CharSequence)toolWindowId, (CharSequence)ep2.id)) continue;
            PluginDescriptor pluginDescriptor = ep2.getPluginDescriptor();
            return new ToolWindowInfo(ep2.id, PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor));
        }
        return null;
    }

    static {
        ourToolwindowWhitelist.put("Messages", new ToolWindowInfo("Messages"));
        ourToolwindowWhitelist.put("Debug", new ToolWindowInfo("Debug"));
        ourToolwindowWhitelist.put("Run", new ToolWindowInfo("Run"));
        ourToolwindowWhitelist.put("Build", new ToolWindowInfo("Build"));
        ourToolwindowWhitelist.put("Find", new ToolWindowInfo("Find"));
        ourToolwindowWhitelist.put("CVS", new ToolWindowInfo("CVS"));
        ourToolwindowWhitelist.put("Hierarchy", new ToolWindowInfo("Hierarchy"));
        ourToolwindowWhitelist.put("Inspection Results", new ToolWindowInfo("Inspection_Results"));
        ourToolwindowWhitelist.put("Dependency Viewer", new ToolWindowInfo("Dependency_Viewer"));
        ourToolwindowWhitelist.put("Module Dependencies", new ToolWindowInfo("Module_Dependencies"));
        ourToolwindowWhitelist.put("Duplicates", new ToolWindowInfo("Duplicates"));
        ourToolwindowWhitelist.put("Extract Method", new ToolWindowInfo("Extract_Method"));
        ourToolwindowWhitelist.put("Documentation", new ToolWindowInfo("Documentation"));
        ourToolwindowWhitelist.put("Preview", new ToolWindowInfo("Preview"));
        ourToolwindowWhitelist.put("Run Dashboard", new ToolWindowInfo("Run_Dashboard"));
        ourToolwindowWhitelist.put("Services", new ToolWindowInfo("Services"));
        ourToolwindowWhitelist.put("Endpoints", new ToolWindowInfo("Endpoints"));
    }

    private static class ToolWindowInfo {
        private final String myRecordedId;
        private final PluginInfo myPluginInfo;

        private ToolWindowInfo(@NotNull String recordedId) {
            this(recordedId, PluginInfoDetectorKt.getPlatformPlugin());
        }

        private ToolWindowInfo(@NotNull String recordedId, @NotNull PluginInfo info) {
            this.myRecordedId = recordedId;
            this.myPluginInfo = info;
        }
    }

    public static class ToolWindowUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "toolwindow".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if ("unknown".equals(data2)) {
                return ValidationResultType.ACCEPTED;
            }
            return ToolWindowUtilValidator.acceptWhenReportedByJetBrainsPlugin((EventContext)context);
        }
    }

    static enum ToolWindowEventType {
        ACTIVATED,
        CLICKED,
        SHOWN,
        HIDDEN;

    }
}

