/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.MenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.NotNull;

public class MainMenuCollector {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void record(@NotNull AnAction action2) {
        try {
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(action2.getClass());
            if (!info.isDevelopedByJetBrains()) {
                return;
            }
            AWTEvent e = EventQueue.getCurrentEvent();
            String path = null;
            if (e instanceof ItemEvent) {
                path = this.getPathFromMenuItem(e, action2);
            } else if (e instanceof MouseEvent) {
                path = this.getPathFromMenuSelectionManager(action2);
            }
            if (StringUtil.isEmpty((String)path)) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getPathFromMenuSelectionManager(@NotNull AnAction action2) {
        List<String> groups = Arrays.stream(MenuSelectionManager.defaultManager().getSelectedPath()).filter(o -> o instanceof ActionMenu).map(o -> ((ActionMenu)((Object)((Object)o))).getAnAction().getTemplateText()).collect(Collectors.toList());
        if (groups.size() > 0) {
            String text = MainMenuCollector.getActionText(action2);
            groups.add(text);
            return MainMenuCollector.convertMenuItemsToKey(groups);
        }
        return null;
    }

    private static String getActionText(@NotNull AnAction action2) {
        String actionId = ActionManager.getInstance().getId(action2);
        if (StringUtil.isEmpty((String)actionId)) {
            return "generated.on.runtime";
        }
        return action2.getTemplateText();
    }

    @NotNull
    private static String convertMenuItemsToKey(List<String> menuItems) {
        return StringUtil.join(menuItems, (String)" -> ");
    }

    @NotNull
    protected String getPathFromMenuItem(AWTEvent e, AnAction action2) {
        Object src = e.getSource();
        ArrayList<String> items = new ArrayList<String>();
        while (src instanceof MenuItem) {
            items.add(0, ((MenuItem)src).getLabel());
            src = ((MenuItem)src).getParent();
        }
        if (items.size() > 1) {
            items.set(items.size() - 1, MainMenuCollector.getActionText(action2));
        }
        return MainMenuCollector.convertMenuItemsToKey(items);
    }

    public static MainMenuCollector getInstance() {
        return (MainMenuCollector)ServiceManager.getService(MainMenuCollector.class);
    }

    public static final class State {
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="path", valueAttributeName="count")
        public Map<String, Integer> myValues = new HashMap<String, Integer>();
    }
}

