/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "keymaps.name";
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            return Collections.emptySet();
        }
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        FeatureUsageData data2 = new FeatureUsageData().addData("keymap_name", KeymapUsageCollector.getKeymapName(keymap2));
        if (keymap2.canModify()) {
            data2.addData("based_on", KeymapUsageCollector.getKeymapName(keymap2.getParent()));
        }
        return Collections.singleton(MetricEventFactoryKt.newMetric((String)"ide.keymap", (FeatureUsageData)data2));
    }

    @NotNull
    private static String getKeymapName(@Nullable Keymap keymap2) {
        if (keymap2 == null) {
            return "unknown";
        }
        return keymap2.canModify() ? "custom" : keymap2.getName();
    }
}

