/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTypeUsageCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "module.facets";
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        HashSet<String> facets2 = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (Facet facet2 : FacetManager.getInstance((Module)module).getAllFacets()) {
                facets2.add(facet2.getType().getStringId());
            }
        }
        return ContainerUtil.map2Set(facets2, facet -> new MetricEvent("module.with.facet", new FeatureUsageData().addData("facet", facet)));
    }

    public static class FacetTypeUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "facets_type".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if ("invalid".equals(data2) || FacetTypeUtilValidator.isThirdPartyValue((String)data2)) {
                return ValidationResultType.ACCEPTED;
            }
            FacetType facet = FacetTypeUtilValidator.findFacetById(data2);
            if (facet == null) {
                return ValidationResultType.REJECTED;
            }
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(facet.getClass());
            context.setPluginInfo(info);
            return info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
        }

        @Nullable
        private static FacetType findFacetById(@NotNull String data2) {
            FacetType[] facets2;
            for (FacetType facet : facets2 = (FacetType[])FacetType.EP_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)facet.getStringId(), (CharSequence)data2)) continue;
                return facet;
            }
            return null;
        }
    }
}

