/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.treeStructure.Tree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NotNull;

public final class JBTabsDemoAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        int[] count = new int[1];
        final JBTabsImpl tabs = new JBTabsImpl(null, null, Disposer.newDisposable());
        frame.getContentPane().add((Component)tabs.getComponent(), "Center");
        JPanel south = new JPanel(new FlowLayout());
        south.setOpaque(true);
        south.setBackground(Color.white);
        final JComboBox<Object> pos = new JComboBox<Object>(new Object[]{JBTabsPosition.top, JBTabsPosition.left, JBTabsPosition.right, JBTabsPosition.bottom});
        pos.setSelectedIndex(0);
        south.add(pos);
        pos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBTabsPosition p = (JBTabsPosition)pos.getSelectedItem();
                if (p != null) {
                    tabs.getPresentation().setTabsPosition(p);
                }
            }
        });
        JCheckBox bb = new JCheckBox("Buffered", true);
        bb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        south.add(bb);
        final JCheckBox f = new JCheckBox("Focused");
        f.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setFocused(f.isSelected());
            }
        });
        south.add(f);
        final JCheckBox v = new JCheckBox("Vertical");
        v.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setSideComponentVertical(v.isSelected());
            }
        });
        south.add(v);
        final JCheckBox before = new JCheckBox("Before", true);
        before.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setSideComponentBefore(before.isSelected());
            }
        });
        south.add(before);
        final JCheckBox row = new JCheckBox("Single row", true);
        row.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setSingleRow(row.isSelected());
            }
        });
        south.add(row);
        final JCheckBox hide = new JCheckBox("Hide tabs", tabs.isHideTabs());
        hide.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                tabs.setHideTabs(hide.isSelected());
            }
        });
        south.add(hide);
        frame.getContentPane().add((Component)south, "South");
        tabs.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                System.out.println("TabsWithActions.selectionChanged old=" + oldSelection + " new=" + newSelection);
            }
        });
        Tree someTree = new Tree(){

            public void addNotify() {
                super.addNotify();
                System.out.println("JBTabs.addNotify");
            }

            public void removeNotify() {
                System.out.println("JBTabs.removeNotify");
                super.removeNotify();
            }
        };
        tabs.addTab(new TabInfo((JComponent)someTree)).setText("Tree1").setActions((ActionGroup)new DefaultActionGroup(), null).setIcon(AllIcons.Debugger.Frame);
        Tree component2 = new Tree();
        final TabInfo toAnimate1 = new TabInfo((JComponent)component2);
        final JCheckBox attract1 = new JCheckBox("Attract 1");
        attract1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (attract1.isSelected()) {
                    toAnimate1.fireAlert();
                } else {
                    toAnimate1.stopAlerting();
                }
            }
        });
        south.add(attract1);
        JCheckBox hide1 = new JCheckBox("Hide 1", toAnimate1.isHidden());
        hide1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                toAnimate1.setHidden(!toAnimate1.isHidden());
            }
        });
        south.add(hide1);
        final JCheckBox block = new JCheckBox("Block", false);
        block.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tabs.setPaintBlocked(!block.isSelected(), true);
            }
        });
        south.add(block);
        final JCheckBox fill = new JCheckBox("Tab fill in", true);
        fill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tabs.getPresentation().setActiveTabFillIn(fill.isSelected() ? Color.white : null);
            }
        });
        south.add(fill);
        JButton refire = new JButton("Re-fire attraction");
        refire.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                toAnimate1.fireAlert();
            }
        });
        south.add(refire);
        JEditorPane text = new JEditorPane();
        text.setEditorKit(new HTMLEditorKit());
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < 50; ++i2) {
            buffer.append("1234567890abcdefghijklmnopqrstv1234567890abcdefghijklmnopqrstv1234567890abcdefghijklmnopqrstv<br>");
        }
        text.setText(buffer.toString());
        JLabel tb = new JLabel("Side comp");
        tb.setBorder(new LineBorder(Color.red));
        tabs.addTab(new TabInfo((JComponent)ScrollPaneFactory.createScrollPane((Component)text)).setSideComponent((JComponent)tb)).setText("Text text text");
        tabs.addTab(toAnimate1).append("Tree2", new SimpleTextAttributes(8, Color.black, Color.red));
        tabs.addTab(new TabInfo((JComponent)new JTable())).setText("Table 1").setActions((ActionGroup)new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo((JComponent)new JTable())).setText("Table 2").setActions((ActionGroup)new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo((JComponent)new JTable())).setText("Table 3").setActions((ActionGroup)new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo((JComponent)new JTable())).setText("Table 4").setActions((ActionGroup)new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo((JComponent)new JTable())).setText("Table 5").setActions((ActionGroup)new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo((JComponent)new JTable())).setText("Table 6").setActions((ActionGroup)new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo((JComponent)new JTable())).setText("Table 7").setActions((ActionGroup)new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo((JComponent)new JTable())).setText("Table 8").setActions((ActionGroup)new DefaultActionGroup(), null);
        tabs.addTab(new TabInfo((JComponent)new JTable())).setText("Table 9").setActions((ActionGroup)new DefaultActionGroup(), null);
        tabs.setTabSidePaintBorder(5);
        tabs.setPaintBorder(1, 1, 1, 1);
        tabs.getPresentation().setActiveTabFillIn(Color.white);
        tabs.setBorder((Border)new EmptyBorder(30, 30, 30, 30));
        tabs.setUiDecorator(new UiDecorator(){

            public UiDecorator.UiDecoration getDecoration() {
                return new UiDecorator.UiDecoration(null, new Insets(0, -1, 0, -1));
            }
        });
        frame.setBounds(1400, 200, 1000, 800);
        frame.show();
    }
}

