/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GrayFilterConfig
extends AnAction
implements DumbAware {
    private static final String BRIGHTNESS = "brightness";
    private static final String CONTRAST = "contrast";
    private static final String ALPHA = "alpha";
    private final Object[][] data = new Object[3][2];
    private boolean lafListenerAdded;

    private void setData() {
        this.data[0][0] = BRIGHTNESS;
        this.data[1][0] = CONTRAST;
        this.data[2][0] = ALPHA;
        this.data[0][1] = String.valueOf(this.getGrayFilterProperty(BRIGHTNESS));
        this.data[1][1] = String.valueOf(this.getGrayFilterProperty(CONTRAST));
        this.data[2][1] = String.valueOf(this.getGrayFilterProperty(ALPHA));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Window activeFrame = IdeFrameImpl.getActiveFrame();
        if (activeFrame == null) {
            return;
        }
        this.setData();
        if (!this.lafListenerAdded) {
            this.lafListenerAdded = true;
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(LafManagerListener.TOPIC, source -> this.setData());
        }
        final JTable table = new JTable(this.data, new String[]{"Property", "Value"}){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                return (table1, value2, isSelected, hasFocus, row1, column1) -> {
                    JLabel label2 = new JLabel((String)GrayFilterConfig.this.data[row][column]);
                    label2.setOpaque(true);
                    label2.setBackground(JBColor.border());
                    label2.setBorder((Border)JBUI.Borders.emptyLeft((int)UISettings.getDefFontSize()));
                    return label2;
                };
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        table.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            final JTextField component = new JTextField();

            public Object getCellEditorValue() {
                return this.component.getText();
            }

            public Component getTableCellEditorComponent(JTable table1, Object value2, boolean isSelected, int row, int column) {
                this.component.setText((String)GrayFilterConfig.this.data[row][column]);
                return this.component;
            }
        });
        table.getColumnModel().getColumn(1).getCellEditor().addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                String prop = (String)GrayFilterConfig.this.data[table.getSelectedRow()][0];
                try {
                    int value2 = Integer.parseInt((String)((TableCellEditor)e.getSource()).getCellEditorValue());
                    GrayFilterConfig.this.setGrayFilterProperty(prop, value2);
                    ((GrayFilterConfig)GrayFilterConfig.this).data[table.getSelectedRow()][1] = String.valueOf(GrayFilterConfig.this.getGrayFilterProperty(prop));
                    IconLoader.clearCache();
                    GrayFilterConfig.updateUI(SwingUtilities.getWindowAncestor(table));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        table.setColumnSelectionAllowed(true);
        table.setTableHeader(null);
        for (int c = 0; c < table.getColumnCount(); ++c) {
            table.getColumnModel().getColumn(c).setPreferredWidth(JBUIScale.scale((int)100));
        }
        for (int r = 0; r < table.getRowCount(); ++r) {
            table.setRowHeight(r, UISettings.getDefFontSize() * 2);
        }
        final JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)table, "Center");
        DialogWrapper dlg = new DialogWrapper(false){
            {
                super(x0);
                this.init();
            }

            protected JComponent createCenterPanel() {
                return tablePanel;
            }
        };
        dlg.setModal(false);
        dlg.setTitle("GrayFilter");
        dlg.setResizable(false);
        dlg.show();
    }

    private int getGrayFilterProperty(String prop) {
        UIUtil.GrayFilter filter2 = this.getGrayFilter();
        if (BRIGHTNESS.equals(prop)) {
            return filter2.getBrightness();
        }
        if (CONTRAST.equals(prop)) {
            return filter2.getContrast();
        }
        if (ALPHA.equals(prop)) {
            return filter2.getAlpha();
        }
        throw new IllegalArgumentException("wrong property: " + prop);
    }

    protected UIUtil.GrayFilter getGrayFilter() {
        return (UIUtil.GrayFilter)UIUtil.getGrayFilter();
    }

    private void setGrayFilterProperty(String prop, int value2) {
        UIUtil.GrayFilter filter2 = this.getGrayFilter();
        int brightness = filter2.getBrightness();
        int contrast = filter2.getContrast();
        int alpha = filter2.getAlpha();
        if (BRIGHTNESS.equals(prop)) {
            brightness = value2;
        } else if (CONTRAST.equals(prop)) {
            contrast = value2;
        } else if (ALPHA.equals(prop)) {
            alpha = value2;
        } else {
            return;
        }
        String key = this.getGrayFilterKey();
        UIManager.getDefaults().remove(key);
        UIManager.getDefaults().put(key, new UIUtil.GrayFilter(brightness, contrast, alpha));
    }

    protected String getGrayFilterKey() {
        return "grayFilter";
    }

    private static void updateUI(Window exclude) {
        for (Window w : Window.getWindows()) {
            if (w == exclude) continue;
            IJSwingUtilities.updateComponentTreeUI(w);
        }
    }
}

