/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.Patches;
import com.intellij.accessibility.AccessibilityUtils;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.AssertiveRepaintManager;
import com.intellij.ide.CliResult;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeRepaintManager;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.ide.gdpr.Agreements;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.ide.instrument.WriteIntentLockInstrumenter;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.StartupAbortedException;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.PrintStreamLogger;
import com.intellij.idea.SocketLock;
import com.intellij.idea.SplashManager;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.DeleteOldDirectoriesHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.swing.UIManager;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.LogLog;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;

@ApiStatus.Internal
public final class StartupUtil {
    public static final String IDEA_CLASS_BEFORE_APPLICATION_PROPERTY = "idea.class.before.app";
    public static final String USE_SEPARATE_WRITE_THREAD_PROPERTY = "idea.use.separate.write.thread";
    private static final String MAGIC_MAC_PATH = "/AppTranslocation/";
    private static SocketLock ourSocketLock;
    private static final AtomicBoolean ourSystemPatched;

    private StartupUtil() {
    }

    public static boolean isUsingSeparateWriteThread() {
        return Boolean.getBoolean(USE_SEPARATE_WRITE_THREAD_PROPERTY);
    }

    public static synchronized void addExternalInstanceListener(@Nullable Function<List<String>, Future<CliResult>> processor2) {
        if (ourSocketLock == null) {
            throw new AssertionError((Object)"Not initialized yet");
        }
        ourSocketLock.setCommandProcessor(processor2);
    }

    @Deprecated
    @Nullable
    public static synchronized BuiltInServer getServer() {
        return ourSocketLock == null ? null : ourSocketLock.getServer();
    }

    @NotNull
    public static synchronized CompletableFuture<BuiltInServer> getServerFuture() {
        CompletableFuture<BuiltInServer> serverFuture = ourSocketLock == null ? null : ourSocketLock.getServerFuture();
        return serverFuture == null ? CompletableFuture.completedFuture(null) : serverFuture;
    }

    private static @NotNull Future<@Nullable Object> loadEuaDocument(@NotNull ExecutorService executorService) {
        if (Main.isHeadless()) {
            return CompletableFuture.completedFuture(null);
        }
        return executorService.submit(() -> {
            if (!ApplicationInfoImpl.getShadowInstance().isVendorJetBrains()) {
                return null;
            }
            Activity euaActivity = StartUpMeasurer.startActivity((String)"eua getting");
            EndUserAgreement.Document result2 = EndUserAgreement.getLatestDocument();
            euaActivity.end();
            return result2;
        });
    }

    private static void runPreAppClass(@NotNull Logger log) {
        String classBeforeAppProperty = System.getProperty(IDEA_CLASS_BEFORE_APPLICATION_PROPERTY);
        if (classBeforeAppProperty != null) {
            try {
                Class<?> clazz = Class.forName(classBeforeAppProperty);
                Method invokeMethod = clazz.getDeclaredMethod("invoke", new Class[0]);
                invokeMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                log.error("Failed pre-app class init for class " + classBeforeAppProperty, (Throwable)e);
            }
        }
    }

    public static void prepareApp(@NotNull @NotNull String @NotNull [] args, @NotNull String mainClass) throws Exception {
        LoadingState.setStrictMode();
        LoadingState.setErrorHandler((message, throwable) -> Logger.getInstance(LoadingState.class).error(message, throwable));
        Activity activity = StartUpMeasurer.startMainActivity((String)"ForkJoin CommonPool configuration");
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)Main.isHeadless((String[])args));
        activity = activity.endAndStart("main class loading scheduling");
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Future<AppStarter> appStarterFuture = executorService.submit(() -> {
            Activity subActivity = StartUpMeasurer.startActivity((String)"main class loading");
            Class<?> aClass = Class.forName(mainClass);
            subActivity.end();
            return (AppStarter)aClass.newInstance();
        });
        activity = activity.endAndStart("log4j configuration");
        StartupUtil.configureLog4j();
        activity = activity.endAndStart("LaF init scheduling");
        Future<Object> euaDocument = StartupUtil.loadEuaDocument(executorService);
        CompletionStage initUiTask = StartupUtil.scheduleInitUi(args, executorService, euaDocument).exceptionally(e -> {
            StartupAbortedException.processException((Throwable)new StartupAbortedException("UI initialization failed", e));
            return null;
        });
        activity.end();
        if (!StartupUtil.checkJdkVersion()) {
            System.exit(4);
        }
        activity = StartUpMeasurer.startMainActivity((String)"config path computing");
        Path configPath = StartupUtil.canonicalPath(PathManager.getConfigPath());
        Path systemPath = StartupUtil.canonicalPath(PathManager.getSystemPath());
        activity = activity.endAndStart("config path existence check");
        boolean configImportNeeded = !Main.isHeadless() && (!Files.exists(configPath, new LinkOption[0]) || Files.exists(configPath.resolve("migrate.config"), new LinkOption[0]));
        activity = activity.endAndStart("system dirs checking");
        if (!StartupUtil.checkSystemDirs(configPath, systemPath)) {
            System.exit(5);
        }
        activity = activity.endAndStart("system dirs locking");
        StartupUtil.lockSystemDirs(configPath, systemPath, args);
        activity = activity.endAndStart("file logger configuration");
        Logger log = StartupUtil.setupLogger();
        activity.end();
        if (!configImportNeeded) {
            PluginManagerCore.scheduleDescriptorLoading();
        }
        NonUrgentExecutor.getInstance().execute(() -> {
            StartupUtil.setupSystemLibraries();
            StartupUtil.logEssentialInfoAboutIde(log, ApplicationInfoImpl.getShadowInstance());
            StartupUtil.loadSystemLibraries(log);
        });
        Activity subActivity = StartUpMeasurer.startActivity((String)"environment loading");
        EnvironmentUtil.loadEnvironment(() -> ((Activity)subActivity).end());
        if (!configImportNeeded) {
            StartupUtil.runPreAppClass(log);
        }
        StartupUtil.startApp(args, initUiTask, log, configImportNeeded, appStarterFuture, euaDocument);
    }

    @NotNull
    private static AppStarter getAppStarter(@NotNull Future<AppStarter> mainStartFuture) throws InterruptedException, ExecutionException {
        Activity activity = mainStartFuture.isDone() ? null : StartUpMeasurer.startMainActivity((String)"main class loading waiting");
        AppStarter result2 = mainStartFuture.get();
        if (activity != null) {
            activity.end();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startApp(String @NotNull [] args, final @NotNull CompletableFuture<?> initUiTask, final @NotNull Logger log, boolean configImportNeeded, @NotNull Future<AppStarter> appStarterFuture, @NotNull Future<@Nullable Object> euaDocument) throws Exception {
        if (!Main.isHeadless()) {
            boolean agreementDialogWasShown;
            Activity activity = StartUpMeasurer.startMainActivity((String)"eua showing");
            Object document = euaDocument.get();
            boolean bl = agreementDialogWasShown = document != null && StartupUtil.showUserAgreementAndConsentsIfNeeded(log, initUiTask, (EndUserAgreement.Document)document);
            if (configImportNeeded) {
                activity = activity.endAndStart("screen reader checking");
                StartupUtil.runInEdtAndWait(log, AccessibilityUtils::enableScreenReaderSupportIfNecessary, initUiTask);
            }
            if (configImportNeeded) {
                activity = activity.endAndStart("config importing");
                AppStarter appStarter = StartupUtil.getAppStarter(appStarterFuture);
                appStarter.beforeImportConfigs();
                Path newConfigDir = PathManager.getConfigDir();
                StartupUtil.runInEdtAndWait(log, () -> ConfigImportHelper.importConfigsTo(agreementDialogWasShown, newConfigDir, Arrays.asList(args), log), initUiTask);
                StartupUtil.runInEdtAndWait(log, DeleteOldDirectoriesHelper::run, initUiTask);
                appStarter.importFinished(newConfigDir);
                if (!ConfigImportHelper.isConfigImported()) {
                    EventQueue.invokeAndWait(() -> {
                        StartupUtil.runStartupWizard(appStarter);
                        PluginManagerCore.scheduleDescriptorLoading();
                    });
                } else {
                    PluginManagerCore.scheduleDescriptorLoading();
                }
            }
            activity.end();
        }
        EdtInvocationManager oldEdtInvocationManager = null;
        EdtInvocationManager.SwingEdtInvocationManager edtInvocationManager = new EdtInvocationManager.SwingEdtInvocationManager(){

            public void invokeAndWait(@NotNull Runnable task2) {
                StartupUtil.runInEdtAndWait(log, task2, initUiTask);
            }
        };
        try {
            oldEdtInvocationManager = EdtInvocationManager.setEdtInvocationManager((EdtInvocationManager)edtInvocationManager);
            StartupUtil.getAppStarter(appStarterFuture).start(Arrays.asList(args), initUiTask);
        }
        finally {
            EdtInvocationManager.restoreEdtInvocationManager((EdtInvocationManager)edtInvocationManager, (EdtInvocationManager)oldEdtInvocationManager);
        }
    }

    @NotNull
    private static CompletableFuture<?> scheduleInitUi(@NotNull @NotNull String @NotNull [] args, @NotNull Executor executor, @NotNull Future<@Nullable Object> eulaDocument) {
        CompletableFuture initUiFuture = new CompletableFuture();
        executor.execute(() -> {
            try {
                StartupUtil.checkHiDPISettings();
                System.setProperty("sun.awt.noerasebackground", "true");
                if (System.getProperty("com.jetbrains.suppressWindowRaise") == null) {
                    System.setProperty("com.jetbrains.suppressWindowRaise", "true");
                }
                EventQueue.invokeLater(() -> {
                    try {
                        StartupUiUtil.initDefaultLaF();
                    }
                    catch (Throwable e) {
                        initUiFuture.completeExceptionally(e);
                        return;
                    }
                    initUiFuture.complete(null);
                    StartUpMeasurer.setCurrentState((LoadingState)LoadingState.LAF_INITIALIZED);
                    if (Main.isHeadless()) {
                        return;
                    }
                    Activity activity = StartUpMeasurer.startActivity((String)"system font data initialization");
                    JBUIScale.getSystemFontData();
                    activity = activity.endAndStart("init JBUIScale");
                    JBUIScale.scale((float)1.0f);
                    if (!Main.isLightEdit() && !Boolean.getBoolean("nosplash")) {
                        Activity prepareSplashActivity = activity.endAndStart("splash preparation");
                        EventQueue.invokeLater(() -> {
                            boolean isEulaAccepted;
                            Activity eulaActivity = prepareSplashActivity.startChild("splash eula isAccepted");
                            try {
                                EndUserAgreement.Document document = (EndUserAgreement.Document)eulaDocument.get();
                                isEulaAccepted = document == null || document.isAccepted();
                            }
                            catch (InterruptedException | ExecutionException ignore) {
                                isEulaAccepted = true;
                            }
                            eulaActivity.end();
                            SplashManager.show(args, isEulaAccepted);
                            prepareSplashActivity.end();
                        });
                        return;
                    }
                    EventQueue.invokeLater(StartupUiUtil::configureHtmlKitStylesheet);
                });
            }
            catch (Throwable e) {
                initUiFuture.completeExceptionally(e);
            }
        });
        if (!Main.isHeadless()) {
            initUiFuture.thenRunAsync(StartupUtil::updateFrameClassAndWindowIcon, executor);
        }
        CompletableFuture<Object> instrumentationFuture = new CompletableFuture<Object>();
        if (StartupUtil.isUsingSeparateWriteThread()) {
            executor.execute(() -> {
                Activity activity = StartUpMeasurer.startActivity((String)"Write Intent Lock UI class transformer loading");
                try {
                    WriteIntentLockInstrumenter.instrument();
                }
                finally {
                    activity.end();
                    instrumentationFuture.complete(null);
                }
            });
        } else {
            instrumentationFuture.complete(null);
        }
        return CompletableFuture.allOf(initUiFuture, instrumentationFuture);
    }

    private static void updateFrameClassAndWindowIcon() {
        Activity activity = StartUpMeasurer.startActivity((String)"frame class updating");
        AppUIUtil.updateFrameClass(Toolkit.getDefaultToolkit());
        activity = activity.endAndStart("update window icon");
        if (!PluginManagerCore.isRunningFromSources() && !AppUIUtil.isWindowIconAlreadyExternallySet()) {
            AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
        }
        activity.end();
    }

    private static void configureLog4j() {
        Activity activity = StartUpMeasurer.startMainActivity((String)"console logger configuration");
        System.setProperty("log4j.defaultInitOverride", "true");
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        if (!root.getAllAppenders().hasMoreElements()) {
            root.setLevel(Level.WARN);
            root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        }
        activity.end();
    }

    private static boolean checkJdkVersion() {
        if ("true".equals(System.getProperty("idea.jre.check"))) {
            try {
                Class.forName("com.sun.jdi.Field", false, StartupUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException | LinkageError e) {
                String message = "Cannot load a JDK class: " + e.getMessage() + "\nPlease ensure you run the IDE on JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
        }
        if ("true".equals(System.getProperty("idea.64bit.check")) && !SystemInfoRt.is64Bit && PlatformUtils.isCidr()) {
            Main.showMessage((String)"Unsupported JVM", (String)"32-bit JVM is not supported. Please use a 64-bit version.", (boolean)true);
            return false;
        }
        return true;
    }

    public static void test_checkHiDPISettings() {
        StartupUtil.checkHiDPISettings();
    }

    private static void checkHiDPISettings() {
        if (!Boolean.parseBoolean(System.getProperty("hidpi", "true"))) {
            System.setProperty("sun.java2d.uiScale.enabled", "false");
        }
    }

    private static boolean checkSystemDirs(@NotNull Path configPath, @NotNull Path systemPath) {
        Path tempPath;
        Path logPath;
        if (configPath.equals(systemPath)) {
            String message = "Config and system paths seem to be equal.\n\nIf you have modified 'idea.config.path' or 'idea.system.path' properties,\nplease make sure they point to different directories, otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Config or System Path", (String)message, (boolean)true);
            return false;
        }
        if (!StartupUtil.checkDirectory(configPath, "Config", "idea.config.path", true, true, false)) {
            return false;
        }
        if (!StartupUtil.checkDirectory(systemPath, "System", "idea.system.path", true, true, false)) {
            return false;
        }
        if (!StartupUtil.checkDirectory(logPath, "Log", "idea.log.path", !(logPath = Paths.get(PathManager.getLogPath(), new String[0]).normalize()).startsWith(systemPath), false, false)) {
            return false;
        }
        return StartupUtil.checkDirectory(tempPath, "Temp", "idea.system.path", !(tempPath = Paths.get(PathManager.getTempPath(), new String[0]).normalize()).startsWith(systemPath), false, SystemInfoRt.isUnix && !SystemInfoRt.isMac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean checkDirectory(@NotNull Path directory, String kind, String property, boolean checkWrite, boolean checkLock, boolean checkExec) {
        boolean options2222;
        Path tempFile;
        String reason;
        String problem;
        block42: {
            block41: {
                problem = null;
                reason = null;
                tempFile = null;
                problem = "cannot create the directory";
                reason = "path is incorrect";
                if (!Files.isDirectory(directory, new LinkOption[0])) {
                    problem = "cannot create the directory";
                    reason = "parent directory is read-only or the user lacks necessary permissions";
                    Files.createDirectories(directory, new FileAttribute[0]);
                }
                if (checkWrite || checkLock || checkExec) {
                    problem = "cannot create a temporary file in the directory";
                    reason = "the directory is read-only or the user lacks necessary permissions";
                    tempFile = directory.resolve("ij" + new Random().nextInt(Integer.MAX_VALUE) + ".tmp");
                    OpenOption[] options2222 = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
                    Files.write(tempFile, "#!/bin/sh\nexit 0".getBytes(StandardCharsets.UTF_8), options2222);
                    if (checkLock) {
                        problem = "cannot create a lock file in the directory";
                        reason = "the directory is located on a network disk";
                        try (FileChannel channel = FileChannel.open(tempFile, StandardOpenOption.WRITE);
                             FileLock lock = channel.tryLock();){
                            if (lock == null) {
                                throw new IOException("File is locked");
                            }
                            break block41;
                        }
                    }
                    if (checkExec) {
                        problem = "cannot execute a test script in the directory";
                        reason = "the partition is mounted with 'no exec' option";
                        Files.getFileAttributeView(tempFile, PosixFileAttributeView.class, new LinkOption[0]).setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
                        int ec = new ProcessBuilder(tempFile.toAbsolutePath().toString()).start().waitFor();
                        if (ec != 0) {
                            throw new IOException("Unexpected exit value: " + ec);
                        }
                    }
                }
            }
            options2222 = true;
            if (tempFile == null) break block42;
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (Exception ec) {
                // empty catch block
            }
        }
        return options2222;
        catch (Exception e) {
            boolean bl;
            block43: {
                try {
                    String title = "Invalid " + kind + " Directory";
                    String advice = SystemInfoRt.isMac && PathManager.getSystemPath().contains(MAGIC_MAC_PATH) ? "The application seems to be trans-located by macOS and cannot be used in this state.\nPlease use Finder to move it to another location." : "If you have modified the '" + property + "' property, please make sure it is correct,\notherwise, please re-install the IDE.";
                    String message = "The IDE " + problem + ".\nPossible reason: " + reason + ".\n\n" + advice + "\n\n-----\nLocation: " + directory + "\n" + e.getClass().getName() + ": " + e.getMessage();
                    Main.showMessage((String)title, (String)message, (boolean)true);
                    bl = false;
                    if (tempFile == null) break block43;
                }
                catch (Throwable throwable) {
                    if (tempFile != null) {
                        try {
                            Files.deleteIfExists(tempFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }
    }

    private static void lockSystemDirs(@NotNull Path configPath, @NotNull Path systemPath, @NotNull @NotNull String @NotNull [] args) throws Exception {
        if (ourSocketLock != null) {
            throw new AssertionError((Object)"Already initialized");
        }
        ourSocketLock = new SocketLock(configPath, systemPath);
        Map.Entry<SocketLock.ActivationStatus, CliResult> status = ourSocketLock.lockAndTryActivate(args);
        switch (status.getKey()) {
            case NO_INSTANCE: {
                ShutDownTracker.getInstance().registerShutdownTask(() -> {
                    Class<StartupUtil> clazz = StartupUtil.class;
                    synchronized (StartupUtil.class) {
                        ourSocketLock.dispose();
                        ourSocketLock = null;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                });
                break;
            }
            case ACTIVATED: {
                CliResult result2 = status.getValue();
                String message = result2.message;
                if (message == null) {
                    message = "Already running";
                }
                System.out.println(message);
                System.exit(result2.exitCode);
            }
            case CANNOT_ACTIVATE: {
                String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.";
                Main.showMessage((String)"Too Many Instances", (String)message, (boolean)true);
                System.exit(6);
            }
        }
    }

    @NotNull
    private static Logger setupLogger() {
        try {
            Logger.setFactory((Logger.Factory)new LoggerFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logger log = Logger.getInstance(Main.class);
        log.info("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
        ShutDownTracker.getInstance().registerShutdownTask(() -> log.info("------------------------------------------------------ IDE SHUTDOWN ------------------------------------------------------"));
        if (Boolean.parseBoolean(System.getProperty("intellij.log.stdout", "true"))) {
            System.setOut(new PrintStreamLogger("STDOUT", System.out));
            System.setErr(new PrintStreamLogger("STDERR", System.err));
            LogLog.setQuietMode((boolean)true);
        }
        return log;
    }

    private static void setupSystemLibraries() {
        Activity subActivity = StartUpMeasurer.startActivity((String)"system libs setup");
        String ideTempPath = PathManager.getTempPath();
        if (System.getProperty("jna.tmpdir") == null) {
            System.setProperty("jna.tmpdir", ideTempPath);
        }
        if (System.getProperty("jna.nosys") == null) {
            System.setProperty("jna.nosys", "true");
        }
        if (SystemInfoRt.isWindows && System.getProperty("winp.folder.preferred") == null) {
            System.setProperty("winp.folder.preferred", ideTempPath);
        }
        if (System.getProperty("pty4j.tmpdir") == null) {
            System.setProperty("pty4j.tmpdir", ideTempPath);
        }
        if (System.getProperty("pty4j.preferred.native.folder") == null) {
            System.setProperty("pty4j.preferred.native.folder", Paths.get(PathManager.getLibPath(), "pty4j-native").toAbsolutePath().toString());
        }
        subActivity.end();
    }

    private static void loadSystemLibraries(@NotNull Logger log) {
        Activity activity = StartUpMeasurer.startActivity((String)"system libs loading");
        JnaLoader.load((Logger)log);
        IdeaWin32.isAvailable();
        activity.end();
    }

    private static void logEssentialInfoAboutIde(@NotNull Logger log, @NotNull ApplicationInfo appInfo) {
        String extDirs;
        Activity activity = StartUpMeasurer.startActivity((String)"essential IDE info logging");
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String buildDate = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.US).format(appInfo.getBuildDate().getTime());
        log.info("IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asString() + ", " + buildDate + ")");
        log.info("OS: " + SystemInfo.OS_NAME + " (" + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")");
        log.info("JRE: " + System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")");
        log.info("JVM: " + System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")");
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (arguments != null) {
            log.info("JVM Args: " + String.join((CharSequence)" ", arguments));
        }
        if ((extDirs = System.getProperty("java.ext.dirs")) != null) {
            for (String dir : extDirs.split(File.pathSeparator)) {
                Object[] content2 = new File(dir).list();
                if (content2 == null || content2.length <= 0) continue;
                log.info("ext: " + dir + ": " + Arrays.toString(content2));
            }
        }
        log.info("library path: " + System.getProperty("java.library.path"));
        log.info("boot library path: " + System.getProperty("sun.boot.library.path"));
        StartupUtil.logEnvVar(log, "_JAVA_OPTIONS");
        StartupUtil.logEnvVar(log, "JDK_JAVA_OPTIONS");
        StartupUtil.logEnvVar(log, "JAVA_TOOL_OPTIONS");
        log.info("locale=" + Locale.getDefault() + " JNU=" + System.getProperty("sun.jnu.encoding") + " file.encoding=" + System.getProperty("file.encoding") + "\n  " + "idea.config.path" + '=' + StartupUtil.logPath(PathManager.getConfigPath()) + "\n  " + "idea.system.path" + '=' + StartupUtil.logPath(PathManager.getSystemPath()) + "\n  " + "idea.plugins.path" + '=' + StartupUtil.logPath(PathManager.getPluginsPath()) + "\n  " + "idea.log.path" + '=' + StartupUtil.logPath(PathManager.getLogPath()));
        activity.end();
    }

    private static void logEnvVar(Logger log, String var) {
        String value2 = System.getenv(var);
        if (value2 != null) {
            log.info(var + '=' + value2);
        }
    }

    private static String logPath(String path) {
        try {
            Path configured = Paths.get(path, new String[0]);
            Path real = configured.toRealPath(new LinkOption[0]);
            if (!configured.equals(real)) {
                return path + " -> " + real;
            }
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
        return path;
    }

    private static void runStartupWizard(@NotNull AppStarter appStarter) {
        CustomizeIDEWizardStepsProvider provider;
        String stepsProviderName = ApplicationInfoImpl.getShadowInstance().getCustomizeIDEWizardStepsProvider();
        if (stepsProviderName == null) {
            return;
        }
        try {
            Class<?> providerClass = Class.forName(stepsProviderName);
            provider = (CustomizeIDEWizardStepsProvider)providerClass.newInstance();
        }
        catch (Throwable e) {
            Main.showMessage((String)"Configuration Wizard Failed", (Throwable)e);
            return;
        }
        appStarter.beforeStartupWizard();
        new CustomizeIDEWizardDialog(provider, appStarter, true, false).showIfNeeded();
        PluginManagerCore.invalidatePlugins();
        appStarter.startupWizardFinished(provider);
    }

    public static boolean patchSystem(@NotNull Logger log) {
        if (!ourSystemPatched.compareAndSet(false, true)) {
            return false;
        }
        Activity activity = StartUpMeasurer.startActivity((String)"event queue replacing");
        StartupUtil.replaceSystemEventQueue(log);
        if (!Main.isHeadless()) {
            StartupUtil.patchSystemForUi(log);
        }
        activity.end();
        return true;
    }

    @ApiStatus.Internal
    public static void replaceSystemEventQueue(@NotNull Logger log) {
        log.info("CPU cores: " + Runtime.getRuntime().availableProcessors() + "; ForkJoinPool.commonPool: " + ForkJoinPool.commonPool() + "; factory: " + ForkJoinPool.commonPool().getFactory());
        IdeEventQueue.getInstance();
    }

    private static void patchSystemForUi(@NotNull Logger log) {
        if (Patches.REPAINT_MANAGER_LEAK) {
            RepaintManager.setCurrentManager(new IdeRepaintManager());
        } else if ("true".equals(System.getProperty("idea.check.swing.threading"))) {
            RepaintManager.setCurrentManager(new AssertiveRepaintManager());
        }
        if (SystemInfo.isXWindow) {
            String wmName = X11UiUtil.getWmName();
            log.info("WM detected: " + wmName);
            if (wmName != null) {
                X11UiUtil.patchDetectedWm(wmName);
            }
        }
        IconManager.activate();
    }

    private static boolean showUserAgreementAndConsentsIfNeeded(@NotNull Logger log, @NotNull CompletableFuture<?> initUiTask, @NotNull EndUserAgreement.Document agreement) {
        boolean dialogWasShown = false;
        EndUserAgreement.updateCachedContentToLatestBundledVersion();
        if (!agreement.isAccepted()) {
            StartupUtil.runInEdtAndWait(log, () -> Agreements.INSTANCE.showEndUserAndDataSharingAgreements(agreement), initUiTask);
            dialogWasShown = true;
        } else if (((Boolean)ConsentOptions.getInstance().getConsents().second).booleanValue()) {
            StartupUtil.runInEdtAndWait(log, Agreements.INSTANCE::showDataSharingAgreement, initUiTask);
        }
        return dialogWasShown;
    }

    private static void runInEdtAndWait(@NotNull Logger log, @NotNull Runnable runnable2, @NotNull CompletableFuture<?> initUiTask) {
        initUiTask.join();
        try {
            if (!ourSystemPatched.get()) {
                EventQueue.invokeAndWait(() -> {
                    if (!StartupUtil.patchSystem(log)) {
                        return;
                    }
                    try {
                        UIManager.setLookAndFeel(IntelliJLaf.class.getName());
                        IconManager.activate();
                        IconLoader.activate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            EventQueue.invokeAndWait(runnable2);
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.warn((Throwable)e);
        }
    }

    @NotNull
    public static Path canonicalPath(@NotNull String path) {
        try {
            return Paths.get(new File(path).getCanonicalPath(), new String[0]);
        }
        catch (IOException ignore) {
            Path file2 = Paths.get(path, new String[0]);
            try {
                return file2.toAbsolutePath().normalize();
            }
            catch (IOError ignored) {
                return file2.normalize();
            }
        }
    }

    static {
        ourSystemPatched = new AtomicBoolean();
    }

    public static interface AppStarter {
        public void start(@NotNull List<String> var1, @NotNull CompletionStage<?> var2);

        default public void beforeImportConfigs() {
        }

        default public void beforeStartupWizard() {
        }

        default public void startupWizardFinished(@NotNull CustomizeIDEWizardStepsProvider provider) {
        }

        default public void importFinished(@NotNull Path newConfigDir) {
        }

        default public int customizeIdeWizardDialog(@NotNull List<AbstractCustomizeWizardStep> steps) {
            return -1;
        }
    }
}

