/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class SmartTreeStructure
extends AbstractTreeStructure {
    @NotNull
    protected final TreeModel myModel;
    protected final Project myProject;
    private TreeElementWrapper myRootElementWrapper;

    public SmartTreeStructure(@NotNull Project project, @NotNull TreeModel model) {
        this.myModel = model;
        this.myProject = project;
    }

    public void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        return SmartTreeStructure.asyncCommitDocuments((Project)this.myProject);
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element2, NodeDescriptor parentDescriptor) {
        return (AbstractTreeNode)element2;
    }

    public Object @NotNull [] getChildElements(@NotNull Object element2) {
        return ((AbstractTreeNode)element2).getChildren().toArray();
    }

    public Object getParentElement(@NotNull Object element2) {
        return ((AbstractTreeNode)element2).getParent();
    }

    @NotNull
    public Object getRootElement() {
        if (this.myRootElementWrapper == null) {
            this.myRootElementWrapper = this.createTree();
        }
        return this.myRootElementWrapper;
    }

    @NotNull
    protected TreeElementWrapper createTree() {
        return new TreeElementWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
    }

    public boolean isAlwaysLeaf(@NotNull Object element2) {
        return ((AbstractTreeNode)element2).isAlwaysLeaf();
    }

    public void rebuildTree() {
        ((CachingChildrenTreeNode)((Object)this.getRootElement())).rebuildChildren();
    }
}

