/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.find.impl.FindInProjectExtension;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeChooserUtils {
    private ScopeChooserUtils() {
    }

    @NotNull
    public static GlobalSearchScope findScopeByName(@NotNull Project project, @Nullable String scopeName) {
        if (scopeName == null) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        if (ScopeChooserUtils.getOpenFilesScopeName().equals(scopeName)) {
            return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopes.openFilesScope((Project)project));
        }
        if (ScopeChooserUtils.getCurrentFileScopeName().equals(scopeName)) {
            Object[] array2 = FileEditorManager.getInstance((Project)project).getSelectedFiles();
            List files2 = ContainerUtil.createMaybeSingletonList((Object)ArrayUtil.getFirstElement((Object[])array2));
            GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)project, (Collection)files2, (String)ScopeChooserUtils.getCurrentFileScopeName());
            return ScopeChooserUtils.intersectWithContentScope(project, scope);
        }
        for (SearchScope scope : PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, null, false, false, false, false, true)) {
            if (!(scope instanceof GlobalSearchScope) || !scope.getDisplayName().equals(scopeName)) continue;
            if (scope instanceof ScratchesSearchScope) {
                return (ScratchesSearchScope)scope;
            }
            return ScopeChooserUtils.intersectWithContentScope(project, (GlobalSearchScope)scope);
        }
        for (FindInProjectExtension extension : FindInProjectExtension.EP_NAME.getExtensionList()) {
            for (NamedScope namedScope : extension.getFilteredNamedScopes(project)) {
                if (!namedScope.getName().equals(scopeName)) continue;
                return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope));
            }
        }
        for (Iterator<Object> iterator2 : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = iterator2.getEditableScopes()) {
                if (!scope.getName().equals(scopeName)) continue;
                return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope));
            }
        }
        if (scopeName.startsWith("Module '") && scopeName.endsWith("'")) {
            return ProjectScope.getContentScope((Project)project);
        }
        return GlobalSearchScope.EMPTY_SCOPE;
    }

    @NotNull
    private static GlobalSearchScope intersectWithContentScope(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        return scope.intersectWith(ProjectScope.getContentScope((Project)project));
    }

    private static String getCurrentFileScopeName() {
        return IdeBundle.message((String)"scope.current.file", (Object[])new Object[0]);
    }

    private static String getOpenFilesScopeName() {
        return IdeBundle.message((String)"scope.open.files", (Object[])new Object[0]);
    }
}

