/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.util.projectWizard.CustomStepProjectGenerator;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.actions.ProjectSpecificAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.HideableProjectGenerator;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.TemplateProjectDirectoryGenerator;
import com.intellij.util.PairConsumer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNewProjectStep<T>
extends DefaultActionGroup
implements DumbAware {
    static final ExtensionPointName<DirectoryProjectGenerator<?>> EP_NAME = new ExtensionPointName("com.intellij.directoryProjectGenerator");
    private static final Logger LOG = Logger.getInstance(AbstractNewProjectStep.class);
    private final Customization<T> myCustomization;

    protected AbstractNewProjectStep(@NotNull Customization<T> customization) {
        super(Presentation.NULL_STRING, true);
        this.myCustomization = customization;
        this.updateActions();
        EP_NAME.addChangeListener(() -> this.updateActions(), null);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        this.updateActions();
    }

    protected void updateActions() {
        List<DirectoryProjectGenerator<?>> projectGenerators;
        this.removeAll();
        AbstractCallback<T> callback2 = this.myCustomization.createCallback();
        ProjectSpecificAction projectSpecificAction = this.myCustomization.createProjectSpecificAction(callback2);
        this.addProjectSpecificAction(projectSpecificAction);
        List<DirectoryProjectGenerator<?>> generators = this.myCustomization.getProjectGenerators();
        this.addAll(this.myCustomization.getActions(generators, callback2));
        if (!this.myCustomization.showUserDefinedProjects()) {
            return;
        }
        ProjectTemplate[] templates = new ArchivedTemplatesFactory().createTemplates("User-defined", null);
        if (templates.length == 0) {
            projectGenerators = Collections.emptyList();
        } else {
            projectGenerators = new ArrayList(templates.length);
            for (ProjectTemplate template : templates) {
                projectGenerators.add(new TemplateProjectDirectoryGenerator((LocalArchivedTemplate)template));
            }
        }
        this.addAll(this.myCustomization.getActions(projectGenerators, callback2));
    }

    protected void addProjectSpecificAction(@NotNull ProjectSpecificAction projectSpecificAction) {
        this.addAll(projectSpecificAction.getChildren(null));
    }

    public static <T> Project doGenerateProject(@Nullable Project projectToClose, @NotNull String locationString, @Nullable DirectoryProjectGenerator<T> generator, @NotNull T settings) {
        Path location = Paths.get(locationString, new String[0]);
        try {
            Files.createDirectories(location, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            String message = ActionsBundle.message((String)"action.NewDirectoryProject.cannot.create.dir", (Object[])new Object[]{location.toString()});
            Messages.showErrorDialog((Project)projectToClose, (String)message, (String)ActionsBundle.message((String)"action.NewDirectoryProject.title", (Object[])new Object[0]));
            return null;
        }
        VirtualFile baseDir = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)location.toString())));
        if (baseDir == null) {
            LOG.error("Couldn't find '" + location + "' in VFS");
            return null;
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
        if (baseDir.getChildren().length > 0) {
            String noText;
            String yesText;
            String title = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.title", (Object[])new Object[0]);
            String message = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.text", (Object[])new Object[]{location.toString()});
            int result2 = Messages.showYesNoDialog((Project)projectToClose, (String)message, (String)title, (String)(yesText = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.create.new", (Object[])new Object[0])), (String)(noText = ActionsBundle.message((String)"action.NewDirectoryProject.not.empty.dialog.open.existing", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon());
            if (result2 == 1) {
                return PlatformProjectOpenProcessor.doOpenProject(location, new OpenProjectTask());
            }
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(location.getParent());
        if (generator instanceof TemplateProjectDirectoryGenerator) {
            ((TemplateProjectDirectoryGenerator)generator).generateProject(baseDir.getName(), locationString);
        }
        OpenProjectTask options2 = OpenProjectTask.newProjectFromWizardAndRunConfigurators(projectToClose, false);
        Project project = ProjectManagerEx.getInstanceEx().openProject(location, options2);
        if (project != null && generator != null) {
            generator.generateProject(project, baseDir, settings, ModuleManager.getInstance((Project)project).getModules()[0]);
        }
        AbstractNewProjectStep.logProjectGeneratedEvent(generator);
        return project;
    }

    private static void logProjectGeneratedEvent(@Nullable DirectoryProjectGenerator<?> generator) {
        FeatureUsageData data2 = new FeatureUsageData();
        if (generator != null) {
            data2.addData("generator_id", generator.getClass().getName());
            data2.addPluginInfo(PluginInfoDetectorKt.getPluginInfo(generator.getClass()));
        }
        FUCounterUsageLogger.getInstance().logEvent("new.project.wizard", "project.generated", data2);
    }

    public static class AbstractCallback<T>
    implements PairConsumer<ProjectSettingsStepBase<T>, ProjectGeneratorPeer<T>> {
        public void consume(@Nullable ProjectSettingsStepBase<T> settings, @NotNull ProjectGeneratorPeer<T> projectGeneratorPeer) {
            if (settings == null) {
                return;
            }
            IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
            Project projectToClose = frame != null ? frame.getProject() : null;
            DirectoryProjectGenerator<T> generator = settings.getProjectGenerator();
            T actualSettings = projectGeneratorPeer.getSettings();
            AbstractNewProjectStep.doGenerateProject(projectToClose, settings.getProjectLocation(), generator, actualSettings);
        }
    }

    protected static abstract class Customization<T> {
        protected Customization() {
        }

        @NotNull
        protected ProjectSpecificAction createProjectSpecificAction(@NotNull AbstractCallback<T> callback2) {
            DirectoryProjectGenerator<T> emptyProjectGenerator = this.createEmptyProjectGenerator();
            return new ProjectSpecificAction(emptyProjectGenerator, this.createProjectSpecificSettingsStep(emptyProjectGenerator, callback2));
        }

        @NotNull
        protected abstract AbstractCallback<T> createCallback();

        @NotNull
        protected abstract DirectoryProjectGenerator<T> createEmptyProjectGenerator();

        @NotNull
        protected abstract ProjectSettingsStepBase<T> createProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator<T> var1, @NotNull AbstractCallback<T> var2);

        @NotNull
        protected List<DirectoryProjectGenerator<?>> getProjectGenerators() {
            return EP_NAME.getExtensionList();
        }

        public AnAction[] getActions(@NotNull List<DirectoryProjectGenerator<?>> generators, @NotNull AbstractCallback<T> callback2) {
            ArrayList<AnAction> actions = new ArrayList<AnAction>();
            for (DirectoryProjectGenerator<?> projectGenerator : generators) {
                try {
                    actions.addAll(Arrays.asList(this.getActions(projectGenerator, callback2)));
                }
                catch (Throwable throwable) {
                    LOG.error("Broken project generator " + projectGenerator, throwable);
                }
            }
            return actions.toArray(AnAction.EMPTY_ARRAY);
        }

        public AnAction @NotNull [] getActions(@NotNull DirectoryProjectGenerator<T> generator, @NotNull AbstractCallback<T> callback2) {
            if (this.shouldIgnore(generator)) {
                return AnAction.EMPTY_ARRAY;
            }
            ProjectSettingsStepBase step = generator instanceof CustomStepProjectGenerator ? (ProjectSettingsStepBase)((CustomStepProjectGenerator)((Object)generator)).createStep(generator, callback2) : this.createProjectSpecificSettingsStep(generator, callback2);
            ProjectSpecificAction projectSpecificAction = new ProjectSpecificAction(generator, step);
            return projectSpecificAction.getChildren(null);
        }

        protected boolean shouldIgnore(@NotNull DirectoryProjectGenerator<?> generator) {
            return generator instanceof HideableProjectGenerator && ((HideableProjectGenerator)((Object)generator)).isHidden();
        }

        public boolean showUserDefinedProjects() {
            return false;
        }
    }
}

