/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.LanguageRef;
import com.intellij.lang.Language;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.ui.IdeUICustomization;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoSymbolModel2
extends FilteringGotoByModel<LanguageRef> {
    private String[] mySeparators;
    private final boolean myAllContributors;

    public GotoSymbolModel2(@NotNull Project project, ChooseByNameContributor @NotNull [] contributors) {
        super(project, contributors);
        this.myAllContributors = false;
        this.addEpListener(project);
    }

    public GotoSymbolModel2(@NotNull Project project) {
        super(project, new ChooseByNameContributor[0]);
        this.myAllContributors = true;
        this.addEpListener(project);
    }

    private void addEpListener(@NotNull Project project) {
        ChooseByNameContributor.CLASS_EP_NAME.addChangeListener(() -> {
            this.mySeparators = null;
        }, (Disposable)project);
    }

    @Override
    protected List<ChooseByNameContributor> getContributorList() {
        if (this.myAllContributors) {
            return ChooseByNameRegistry.getInstance().getSymbolModelContributors();
        }
        return super.getContributorList();
    }

    @Override
    protected LanguageRef filterValueFor(NavigationItem item) {
        return LanguageRef.forNavigationitem(item);
    }

    @Override
    @Nullable
    protected synchronized Collection<LanguageRef> getFilterItems() {
        Collection result2 = super.getFilterItems();
        if (result2 == null) {
            return null;
        }
        HashSet<LanguageRef> items = new HashSet<LanguageRef>(result2);
        items.add(LanguageRef.forLanguage(Language.ANY));
        return items;
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotosymbol.enter.symbol.name", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        return IdeUICustomization.getInstance().projectMessage("checkbox.include.non.project.symbols", new Object[0]);
    }

    @NotNull
    public String getNotInMessage() {
        return IdeUICustomization.getInstance().projectMessage("label.no.matches.found.in.project", new Object[0]);
    }

    @NotNull
    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.matches.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries")) && Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToSymbol.includeLibraries"));
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries"))) {
            propertiesComponent.setValue("GoToSymbol.includeLibraries", Boolean.toString(state));
        }
    }

    public String getFullName(@NotNull Object element2) {
        for (ChooseByNameContributor c : this.getContributorList()) {
            String result2;
            if (!(c instanceof GotoClassContributor) || (result2 = ((GotoClassContributor)c).getQualifiedName((NavigationItem)element2)) == null) continue;
            return result2;
        }
        String elementName = this.getElementName(element2);
        if (elementName == null) {
            return null;
        }
        if (element2 instanceof PsiElement) {
            return SymbolPresentationUtil.getSymbolContainerText((PsiElement)element2) + "." + elementName;
        }
        return elementName;
    }

    public String @NotNull [] getSeparators() {
        if (this.mySeparators == null) {
            this.mySeparators = GotoClassModel2.getSeparatorsFromContributors(this.getContributors());
        }
        return this.mySeparators;
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    public boolean willOpenEditor() {
        return true;
    }
}

