/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.DataManager;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.ActionFromOptionDescriptorProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ChooseByNameWeightedItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.Matcher;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GotoActionItemProvider
implements ChooseByNameWeightedItemProvider {
    private static final int BONUS_FOR_SPACE_IN_PATTERN = 100;
    private static final int SETTINGS_PENALTY = 100;
    private final ActionManager myActionManager = ActionManager.getInstance();
    private final GotoActionModel myModel;
    private final ClearableLazyValue<Map<String, ApplyIntentionAction>> myIntentions;
    private static final Logger LOG = Logger.getInstance(GotoActionItemProvider.class);

    public GotoActionItemProvider(GotoActionModel model) {
        this.myModel = model;
        this.myIntentions = ClearableLazyValue.create(() -> (Map)ReadAction.compute(() -> this.myModel.getAvailableIntentions()));
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, String @NotNull [] names2, @NotNull String pattern) {
        return this.filterNames((ChooseByNameViewModel)base, names2, pattern);
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameViewModel base, String @NotNull [] names2, @NotNull String pattern) {
        return Collections.emptyList();
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer) {
        return this.filterElements((ChooseByNameViewModel)base, pattern, everywhere, cancelled, consumer);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer) {
        return this.filterElementsWithWeights(base, pattern, everywhere, cancelled, descriptor2 -> consumer.process(descriptor2.getItem()));
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        return this.filterElementsWithWeights((ChooseByNameViewModel)base, pattern, everywhere, indicator, consumer);
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        return this.filterElements(pattern, (Processor<? super GotoActionModel.MatchedValue>)((Processor)value2 -> {
            if (!everywhere && value2.value instanceof GotoActionModel.ActionWrapper && !((GotoActionModel.ActionWrapper)value2.value).isAvailable()) {
                return true;
            }
            return consumer.process((Object)new FoundItemDescriptor(value2, value2.getMatchingDegree()));
        }));
    }

    public boolean filterElements(@NotNull String pattern, @NotNull Processor<? super GotoActionModel.MatchedValue> consumer) {
        DataContext dataContext = DataManager.getInstance().getDataContext(this.myModel.getContextComponent());
        if (!this.processAbbreviations(pattern, consumer, dataContext)) {
            return false;
        }
        if (!this.processActions(pattern, consumer, dataContext)) {
            return false;
        }
        if (!this.processTopHits(pattern, consumer, dataContext)) {
            return false;
        }
        if (!this.processIntentions(pattern, consumer, dataContext)) {
            return false;
        }
        return this.processOptions(pattern, consumer, dataContext);
    }

    private boolean processAbbreviations(@NotNull String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext context) {
        MinusculeMatcher matcher = GotoActionItemProvider.buildWeightMatcher(pattern);
        List actionIds = AbbreviationManager.getInstance().findActions(pattern);
        JBIterable wrappers = JBIterable.from((Iterable)actionIds).filterMap(arg_0 -> ((ActionManager)this.myActionManager).getAction(arg_0)).transform(action2 -> {
            GotoActionModel.ActionWrapper wrapper2 = this.wrapAnAction((AnAction)action2, context);
            Integer degree = matcher.matchingDegree(pattern);
            return new GotoActionModel.MatchedValue(wrapper2, pattern, degree == null ? 0 : degree){

                @Override
                @NotNull
                public String getValueText() {
                    return this.pattern;
                }
            };
        });
        return GotoActionItemProvider.processItems(pattern, wrappers, consumer);
    }

    private boolean processTopHits(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        CollectConsumer collector = new CollectConsumer();
        String commandAccelerator = SearchTopHitProvider.getTopHitAccelerator();
        for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
            if (provider instanceof OptionsTopHitProvider.CoveredByToggleActions) continue;
            if (provider instanceof OptionsSearchTopHitProvider && !StringUtil.startsWith((CharSequence)pattern, (CharSequence)commandAccelerator)) {
                String prefix = commandAccelerator + ((OptionsSearchTopHitProvider)provider).getId() + " ";
                provider.consumeTopHits(prefix + pattern, (Consumer)collector, project);
            } else if (project != null && provider instanceof OptionsTopHitProvider.ProjectLevelProvidersAdapter) {
                ((OptionsTopHitProvider.ProjectLevelProvidersAdapter)provider).consumeAllTopHits(pattern, (Consumer<Object>)collector, project);
            }
            provider.consumeTopHits(pattern, (Consumer)collector, project);
        }
        Collection result2 = collector.getResult();
        JBIterable wrappers = JBIterable.from((Iterable)result2).transform(object -> object instanceof AnAction ? this.wrapAnAction((AnAction)object, dataContext) : object);
        return GotoActionItemProvider.processItems(pattern, wrappers, consumer);
    }

    private boolean processOptions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Map<String, String> map2 = this.myModel.getConfigurablesNames();
        SearchableOptionsRegistrarImpl registrar = (SearchableOptionsRegistrarImpl)SearchableOptionsRegistrar.getInstance();
        ArrayList<GotoActionModel.ActionWrapper> options2 = new ArrayList<GotoActionModel.ActionWrapper>();
        Set<String> words = registrar.getProcessedWords(pattern);
        Set<OptionDescription> optionDescriptions = null;
        String actionManagerName = this.myActionManager.getComponentName();
        boolean filterOutInspections = Registry.is((String)"go.to.action.filter.out.inspections", (boolean)true);
        for (String string : words) {
            Set<OptionDescription> set = registrar.getAcceptableDescriptions(string);
            if (set != null) {
                set.removeIf(description -> actionManagerName.equals(description.getPath()) || filterOutInspections && "Inspections".equals(description.getGroupName()));
                if (set.isEmpty()) continue;
                if (optionDescriptions == null) {
                    optionDescriptions = set;
                    continue;
                }
                optionDescriptions.retainAll(set);
                continue;
            }
            optionDescriptions = null;
            break;
        }
        if (!StringUtil.isEmptyOrSpaces((String)pattern)) {
            Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
            if (optionDescriptions == null) {
                optionDescriptions = new THashSet();
            }
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (!matcher.matches(entry.getValue())) continue;
                optionDescriptions.add(new OptionDescription(null, entry.getKey(), entry.getValue(), null, entry.getValue()));
            }
        }
        if (optionDescriptions != null && !optionDescriptions.isEmpty()) {
            HashSet<String> currentHits = new HashSet<String>();
            Iterator iterator2 = optionDescriptions.iterator();
            while (iterator2.hasNext()) {
                OptionDescription optionDescription = (OptionDescription)iterator2.next();
                String hit = optionDescription.getHit();
                if (hit != null && currentHits.add(hit.trim())) continue;
                iterator2.remove();
            }
            for (OptionDescription optionDescription : optionDescriptions) {
                for (ActionFromOptionDescriptorProvider converter : (ActionFromOptionDescriptorProvider[])ActionFromOptionDescriptorProvider.EP.getExtensions()) {
                    AnAction action2 = converter.provide(optionDescription);
                    if (action2 == null) continue;
                    options2.add(new GotoActionModel.ActionWrapper(action2, null, GotoActionModel.MatchMode.NAME, dataContext, this.myModel));
                }
                options2.add((GotoActionModel.ActionWrapper)optionDescription);
            }
        }
        return GotoActionItemProvider.processItems(pattern, JBIterable.from(options2), consumer);
    }

    private boolean processActions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Set<String> ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
        JBIterable actions = JBIterable.from(ids).filterMap(arg_0 -> ((ActionManager)this.myActionManager).getAction(arg_0));
        Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        QuickActionProvider provider = (QuickActionProvider)dataContext.getData(QuickActionProvider.KEY);
        if (provider != null) {
            actions = actions.append((Iterable)provider.getActions(true));
        }
        JBIterable actionWrappers = actions.unique().filterMap(action2 -> {
            GotoActionModel.MatchMode mode = this.myModel.actionMatches(pattern, matcher, (AnAction)action2);
            if (mode == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            return new GotoActionModel.ActionWrapper((AnAction)action2, this.myModel.getGroupMapping((AnAction)action2), mode, dataContext, this.myModel);
        });
        return GotoActionItemProvider.processItems(pattern, actionWrappers, consumer);
    }

    public void clearIntentions() {
        this.myIntentions.drop();
    }

    @NotNull
    static Matcher buildMatcher(String pattern) {
        return pattern.contains(" ") ? new WordPrefixMatcher(pattern) : NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    private boolean processIntentions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Matcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        Map intentionMap = (Map)this.myIntentions.getValue();
        JBIterable intentions = JBIterable.from(intentionMap.keySet()).filterMap(intentionText -> {
            ApplyIntentionAction intentionAction = (ApplyIntentionAction)((Object)((Object)intentionMap.get(intentionText)));
            if (this.myModel.actionMatches(pattern, matcher, intentionAction) == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            GotoActionModel.GroupMapping groupMapping = GotoActionModel.GroupMapping.createFromText(intentionText);
            return new GotoActionModel.ActionWrapper(intentionAction, groupMapping, GotoActionModel.MatchMode.INTENTION, dataContext, this.myModel);
        });
        return GotoActionItemProvider.processItems(pattern, intentions, consumer);
    }

    @NotNull
    private GotoActionModel.ActionWrapper wrapAnAction(@NotNull AnAction action2, DataContext dataContext) {
        return new GotoActionModel.ActionWrapper(action2, this.myModel.getGroupMapping(action2), GotoActionModel.MatchMode.NAME, dataContext, this.myModel);
    }

    private static boolean processItems(String pattern, JBIterable<?> items, Processor<? super GotoActionModel.MatchedValue> consumer) {
        MinusculeMatcher matcher = GotoActionItemProvider.buildWeightMatcher(pattern);
        ArrayList matched = ContainerUtil.newArrayList((Iterable)items.map(o -> {
            if (o instanceof GotoActionModel.MatchedValue) {
                return (GotoActionModel.MatchedValue)o;
            }
            Integer weight2 = GotoActionItemProvider.calcElementWeight(o, pattern, matcher);
            return weight2 != null ? new GotoActionModel.MatchedValue(o, pattern, weight2) : new GotoActionModel.MatchedValue(o, pattern);
        }));
        try {
            matched.sort((o1, o2) -> o1.compareWeights((GotoActionModel.MatchedValue)o2));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Comparison method violates its general contract with pattern '" + pattern + "'", (Throwable)e);
        }
        return ContainerUtil.process((List)matched, consumer);
    }

    @Nullable
    private static Integer calcElementWeight(Object element2, String pattern, MinusculeMatcher matcher) {
        String name = GotoActionItemProvider.getActionText(element2);
        if (name == null) {
            return null;
        }
        int degree = matcher.matchingDegree(name);
        if (pattern.trim().contains(" ")) {
            degree += 100;
        }
        if (element2 instanceof OptionDescription && degree > 0) {
            degree -= 100;
        }
        return Math.max(degree, 0);
    }

    private static MinusculeMatcher buildWeightMatcher(String pattern) {
        return NameUtil.buildMatcher((String)("*" + pattern)).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE).preferringStartMatches().build();
    }

    @Nullable
    public static String getActionText(Object value2) {
        if (value2 instanceof OptionDescription) {
            return ((OptionDescription)value2).getHit();
        }
        if (value2 instanceof AnAction) {
            return ((AnAction)value2).getTemplatePresentation().getText();
        }
        if (value2 instanceof GotoActionModel.ActionWrapper) {
            return ((GotoActionModel.ActionWrapper)value2).getAction().getTemplatePresentation().getText();
        }
        return null;
    }
}

