/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import org.jetbrains.annotations.NotNull;

public class DefaultFileNavigationContributor
implements ChooseByNameContributorEx,
DumbAware {
    private static final Logger LOG = Logger.getInstance(DefaultFileNavigationContributor.class);

    @Override
    public void processNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter2) {
        long started = System.currentTimeMillis();
        FilenameIndex.processAllFileNames(processor2, (GlobalSearchScope)scope, (IdFilter)filter2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("All names retrieved:" + (System.currentTimeMillis() - started));
        }
    }

    @Override
    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> _processor, @NotNull FindSymbolParameters parameters2) {
        boolean globalSearch = parameters2.getSearchScope().isSearchInLibraries();
        Processor processor2 = item -> {
            if (!globalSearch && ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)item.getVirtualFile())) {
                return true;
            }
            return _processor.process(item);
        };
        boolean directoriesOnly = DefaultFileNavigationContributor.isDirectoryOnlyPattern(parameters2);
        if (!directoriesOnly) {
            FilenameIndex.processFilesByName((String)name, (boolean)false, (Processor)processor2, (GlobalSearchScope)parameters2.getSearchScope(), (Project)parameters2.getProject(), (IdFilter)parameters2.getIdFilter());
        }
        if (directoriesOnly || Registry.is((String)"ide.goto.file.include.directories")) {
            FilenameIndex.processFilesByName((String)name, (boolean)true, (Processor)processor2, (GlobalSearchScope)parameters2.getSearchScope(), (Project)parameters2.getProject(), (IdFilter)parameters2.getIdFilter());
        }
    }

    private static boolean isDirectoryOnlyPattern(@NotNull FindSymbolParameters parameters2) {
        String completePattern = parameters2.getCompletePattern();
        return completePattern.endsWith("/") || completePattern.endsWith("\\");
    }
}

