/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.actions.searcheverywhere.FoundItemDescriptor;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameInScopeItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.CustomMatcherModel;
import com.intellij.ide.util.gotoByName.MatchResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SynchronizedCollectConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChooseByNameItemProvider
implements ChooseByNameInScopeItemProvider {
    private static final Logger LOG = Logger.getInstance(DefaultChooseByNameItemProvider.class);
    private static final String UNIVERSAL_SEPARATOR = "\u0000";
    private final SmartPsiElementPointer<PsiElement> myContext;

    public DefaultChooseByNameItemProvider(@Nullable PsiElement context) {
        this.myContext = context == null ? null : SmartPointerManager.getInstance((Project)context.getProject()).createSmartPsiElementPointer(context);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer) {
        return this.filterElements((ChooseByNameViewModel)base, pattern, everywhere, cancelled, consumer);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        return this.filterElementsWithWeights(base, DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere), indicator, res2 -> consumer.process(res2.getItem()));
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        return this.filterElements((ChooseByNameViewModel)base, parameters2, indicator, consumer);
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<Object> consumer) {
        return this.filterElementsWithWeights(base, parameters2, indicator, res2 -> consumer.process(res2.getItem()));
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        return this.filterElementsWithWeights((ChooseByNameViewModel)base, pattern, everywhere, indicator, consumer);
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        return this.filterElementsWithWeights(base, DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere), indicator, consumer);
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameBase base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        return this.filterElementsWithWeights((ChooseByNameViewModel)base, parameters2, indicator, consumer);
    }

    @Override
    public boolean filterElementsWithWeights(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @NotNull Processor<? super FoundItemDescriptor<?>> consumer) {
        return (Boolean)ProgressManager.getInstance().computePrioritized(() -> DefaultChooseByNameItemProvider.filterElements(base, indicator, this.myContext == null ? null : this.myContext.getElement(), () -> base.getModel().getNames(parameters2.isSearchInLibraries()), consumer, parameters2));
    }

    public static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @NotNull Processor<Object> consumer) {
        return DefaultChooseByNameItemProvider.filterElements(base, indicator, context, null, res2 -> consumer.process(res2.getItem()), DefaultChooseByNameItemProvider.createParameters(base, pattern, everywhere));
    }

    private static boolean filterElements(@NotNull ChooseByNameViewModel base, @NotNull ProgressIndicator indicator, @Nullable PsiElement context, @Nullable Supplier<String[]> allNamesProducer, @NotNull Processor<? super FoundItemDescriptor<?>> consumer, @NotNull FindSymbolParameters parameters2) {
        boolean everywhere = parameters2.isSearchInLibraries();
        String pattern = parameters2.getCompletePattern();
        if (base.getProject() != null) {
            base.getProject().putUserData(ChooseByNamePopup.CURRENT_SEARCH_PATTERN, (Object)pattern);
        }
        String namePattern = DefaultChooseByNameItemProvider.getNamePattern(base, pattern);
        boolean preferStartMatches = !pattern.startsWith("*");
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getSortedNamesForAllWildcards(base, parameters2, indicator, allNamesProducer, namePattern, preferStartMatches);
        indicator.checkCanceled();
        return DefaultChooseByNameItemProvider.processByNames(base, everywhere, indicator, context, consumer, namesList, parameters2);
    }

    @NotNull
    private static List<MatchResult> getSortedNamesForAllWildcards(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        String matchingPattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern);
        if (matchingPattern.isEmpty() && !base.canShowListForEmptyPattern()) {
            return Collections.emptyList();
        }
        List<MatchResult> result2 = DefaultChooseByNameItemProvider.getSortedNames(base, parameters2, indicator, allNamesProducer, matchingPattern, preferStartMatches);
        if (!namePattern.contains("*")) {
            return result2;
        }
        HashSet<String> allNames = new HashSet<String>(ContainerUtil.map(result2, mr -> mr.elementName));
        for (int i2 = 1; i2 < namePattern.length() - 1; ++i2) {
            if (namePattern.charAt(i2) != '*') continue;
            List<MatchResult> namesForSuffix = DefaultChooseByNameItemProvider.getSortedNames(base, parameters2, indicator, allNamesProducer, DefaultChooseByNameItemProvider.convertToMatchingPattern(base, namePattern.substring(i2 + 1)), preferStartMatches);
            for (MatchResult mr2 : namesForSuffix) {
                if (!allNames.add(mr2.elementName)) continue;
                result2.add(mr2);
            }
        }
        return result2;
    }

    @NotNull
    private static List<MatchResult> getSortedNames(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, String namePattern, boolean preferStartMatches) {
        List<MatchResult> namesList = DefaultChooseByNameItemProvider.getAllNames(base, parameters2, indicator, allNamesProducer, namePattern, preferStartMatches);
        indicator.checkCanceled();
        String pattern = parameters2.getCompletePattern();
        long started = System.currentTimeMillis();
        namesList.sort(Comparator.comparing(mr -> !pattern.equalsIgnoreCase(mr.elementName)).thenComparing(mr -> !namePattern.equalsIgnoreCase(mr.elementName)).thenComparing(Comparator.naturalOrder()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("sorted:" + (System.currentTimeMillis() - started) + ",results:" + namesList.size());
        }
        return namesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<MatchResult> getAllNames(@NotNull ChooseByNameViewModel base, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator indicator, @Nullable Supplier<String[]> allNamesProducer, @NotNull String namePattern, boolean preferStartMatches) {
        ArrayList namesList = new ArrayList();
        SynchronizedCollectConsumer collect = new SynchronizedCollectConsumer(namesList);
        ChooseByNameModel model = base.getModel();
        if (model instanceof ChooseByNameModelEx) {
            indicator.checkCanceled();
            long started = System.currentTimeMillis();
            String fullPattern = parameters2.getCompletePattern();
            MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(namePattern, preferStartMatches);
            ((ChooseByNameModelEx)model).processNames((Processor<? super String>)((Processor)arg_0 -> DefaultChooseByNameItemProvider.lambda$getAllNames$8(indicator, base, fullPattern, matcher, (CollectConsumer)collect, arg_0)), parameters2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("loaded + matched:" + (System.currentTimeMillis() - started) + "," + collect.getResult().size());
            }
        } else {
            if (allNamesProducer == null) {
                throw new IllegalArgumentException("Need to specify allNamesProducer when using a model which isn't a ChooseByNameModelEx");
            }
            String[] names2 = allNamesProducer.get();
            long started = System.currentTimeMillis();
            DefaultChooseByNameItemProvider.processNamesByPattern(base, names2, namePattern, indicator, (Consumer<? super MatchResult>)collect, preferStartMatches);
            if (LOG.isDebugEnabled()) {
                LOG.debug("matched:" + (System.currentTimeMillis() - started) + "," + names2.length);
            }
        }
        SynchronizedCollectConsumer synchronizedCollectConsumer = collect;
        synchronized (synchronizedCollectConsumer) {
            return new ArrayList<MatchResult>(namesList);
        }
    }

    @NotNull
    private static FindSymbolParameters createParameters(@NotNull ChooseByNameViewModel base, @NotNull String pattern, boolean everywhere) {
        ChooseByNameModel model = base.getModel();
        IdFilter idFilter = model instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model).getIdFilter(everywhere) : null;
        GlobalSearchScope searchScope = FindSymbolParameters.searchScopeFor(base.getProject(), everywhere);
        return new FindSymbolParameters(pattern, DefaultChooseByNameItemProvider.getNamePattern(base, pattern), searchScope, idFilter);
    }

    private static boolean processByNames(@NotNull ChooseByNameViewModel base, boolean everywhere, @NotNull ProgressIndicator indicator, final @Nullable PsiElement context, @NotNull Processor<? super FoundItemDescriptor<?>> consumer, @NotNull List<? extends MatchResult> namesList, @NotNull FindSymbolParameters parameters2) {
        SmartList sameNameElements = new SmartList();
        final ChooseByNameModel model = base.getModel();
        Comparator<Pair<Object, MatchResult>> weightComparator = new Comparator<Pair<Object, MatchResult>>(){
            final Comparator<Object> modelComparator;
            {
                this.modelComparator = model instanceof Comparator ? (Comparator)model : new PathProximityComparator(context);
            }

            @Override
            public int compare(Pair<Object, MatchResult> o1, Pair<Object, MatchResult> o2) {
                int result2 = this.modelComparator.compare(o1.first, o2.first);
                return result2 != 0 ? result2 : ((MatchResult)o1.second).compareTo((MatchResult)o2.second);
            }
        };
        MinusculeMatcher fullMatcher = DefaultChooseByNameItemProvider.getFullMatcher(parameters2, base);
        for (MatchResult matchResult : namesList) {
            Object[] elements2;
            indicator.checkCanceled();
            String name = matchResult.elementName;
            Object[] objectArray = elements2 = model instanceof ContributorsBasedGotoByModel ? ((ContributorsBasedGotoByModel)model).getElementsByName(name, parameters2, indicator) : model.getElementsByName(name, everywhere, DefaultChooseByNameItemProvider.getNamePattern(base, parameters2.getCompletePattern()));
            if (elements2.length > 1) {
                sameNameElements.clear();
                for (Object element2 : elements2) {
                    indicator.checkCanceled();
                    MatchResult qualifiedResult = DefaultChooseByNameItemProvider.matchQualifiedName(model, fullMatcher, element2);
                    if (qualifiedResult == null) continue;
                    sameNameElements.add(Pair.create((Object)element2, (Object)qualifiedResult));
                }
                sameNameElements.sort(weightComparator);
                List processedItems = ContainerUtil.map((Collection)sameNameElements, p -> new FoundItemDescriptor(p.first, result2.matchingDegree));
                if (ContainerUtil.process((List)processedItems, consumer)) continue;
                return false;
            }
            if (elements2.length != 1 || DefaultChooseByNameItemProvider.matchQualifiedName(model, fullMatcher, elements2[0]) == null || consumer.process((Object)new FoundItemDescriptor(elements2[0], matchResult.matchingDegree))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected PathProximityComparator getPathProximityComparator() {
        return new PathProximityComparator(this.myContext == null ? null : this.myContext.getElement());
    }

    @NotNull
    private static MinusculeMatcher getFullMatcher(@NotNull FindSymbolParameters parameters2, @NotNull ChooseByNameViewModel base) {
        String fullRawPattern = DefaultChooseByNameItemProvider.buildFullPattern(base, parameters2.getCompletePattern());
        String fullNamePattern = DefaultChooseByNameItemProvider.buildFullPattern(base, base.transformPattern(parameters2.getCompletePattern()));
        return NameUtil.buildMatcherWithFallback((String)fullRawPattern, (String)fullNamePattern, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    @NotNull
    private static String buildFullPattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        String fullPattern = "*" + DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern);
        for (String separator : base.getModel().getSeparators()) {
            fullPattern = StringUtil.replace((String)fullPattern, (String)separator, (String)"*\u0000*");
        }
        return fullPattern;
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        String transformedPattern = base.transformPattern(pattern);
        return DefaultChooseByNameItemProvider.getNamePattern(base.getModel(), transformedPattern);
    }

    @NotNull
    private static String getNamePattern(@NotNull ChooseByNameModel model, @NotNull String pattern) {
        String[] separators = model.getSeparators();
        int lastSeparatorOccurrence = 0;
        for (String separator : separators) {
            int idx = pattern.lastIndexOf(separator);
            if (idx == pattern.length() - 1) {
                idx = pattern.lastIndexOf(separator, idx - 1);
            }
            lastSeparatorOccurrence = Math.max(lastSeparatorOccurrence, idx == -1 ? idx : idx + separator.length());
        }
        return pattern.substring(lastSeparatorOccurrence);
    }

    @Nullable
    private static MatchResult matchQualifiedName(@NotNull ChooseByNameModel model, @NotNull MinusculeMatcher fullMatcher, @NotNull Object element2) {
        String fullName = model.getFullName(element2);
        if (fullName == null) {
            return null;
        }
        for (String separator : model.getSeparators()) {
            fullName = StringUtil.replace((String)fullName, (String)separator, (String)UNIVERSAL_SEPARATOR);
        }
        return DefaultChooseByNameItemProvider.matchName(fullMatcher, fullName);
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, String @NotNull [] names2, @NotNull String pattern) {
        return this.filterNames((ChooseByNameViewModel)base, names2, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameViewModel base, String @NotNull [] names2, @NotNull String pattern) {
        boolean preferStartMatches = pattern.startsWith("*");
        if ((pattern = DefaultChooseByNameItemProvider.convertToMatchingPattern(base, pattern)).isEmpty() && !base.canShowListForEmptyPattern()) {
            return Collections.emptyList();
        }
        ArrayList<String> filtered2 = new ArrayList<String>();
        DefaultChooseByNameItemProvider.processNamesByPattern(base, names2, pattern, ProgressIndicatorProvider.getGlobalProgressIndicator(), (Consumer<? super MatchResult>)((Consumer)result2 -> {
            List list2 = filtered2;
            synchronized (list2) {
                filtered2.add(result2.elementName);
            }
        }), preferStartMatches);
        ArrayList<String> arrayList = filtered2;
        synchronized (arrayList) {
            return filtered2;
        }
    }

    private static void processNamesByPattern(@NotNull ChooseByNameViewModel base, String @NotNull [] names2, @NotNull String pattern, ProgressIndicator indicator, @NotNull Consumer<? super MatchResult> consumer, boolean preferStartMatches) {
        MinusculeMatcher matcher = DefaultChooseByNameItemProvider.buildPatternMatcher(pattern, preferStartMatches);
        Processor processor2 = name -> {
            ProgressManager.checkCanceled();
            MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, pattern, matcher, name);
            if (result2 != null) {
                consumer.consume((Object)result2);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(names2), indicator, processor2)) {
            throw new ProcessCanceledException();
        }
    }

    @NotNull
    private static String convertToMatchingPattern(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        return DefaultChooseByNameItemProvider.addSearchAnywherePatternDecorationIfNeeded(base, DefaultChooseByNameItemProvider.removeModelSpecificMarkup(base.getModel(), pattern));
    }

    @NotNull
    private static String addSearchAnywherePatternDecorationIfNeeded(@NotNull ChooseByNameViewModel base, @NotNull String pattern) {
        String trimmedPattern;
        if (base.isSearchInAnyPlace() && !(trimmedPattern = pattern.trim()).isEmpty() && trimmedPattern.length() > 1) {
            pattern = "*" + pattern;
        }
        return pattern;
    }

    @NotNull
    private static String removeModelSpecificMarkup(@NotNull ChooseByNameModel model, @NotNull String pattern) {
        if (model instanceof ContributorsBasedGotoByModel) {
            pattern = ((ContributorsBasedGotoByModel)model).removeModelSpecificMarkup(pattern);
        }
        return pattern;
    }

    @Nullable
    protected static MatchResult matches(@NotNull ChooseByNameViewModel base, @NotNull String pattern, @NotNull MinusculeMatcher matcher, @Nullable String name) {
        if (name == null) {
            return null;
        }
        if (base.getModel() instanceof CustomMatcherModel) {
            try {
                return ((CustomMatcherModel)base.getModel()).matches(name, pattern) ? new MatchResult(name, 0, true) : null;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return DefaultChooseByNameItemProvider.matchName(matcher, name);
    }

    @Nullable
    private static MatchResult matchName(@NotNull MinusculeMatcher matcher, @NotNull String name) {
        FList fragments = matcher.matchingFragments(name);
        return fragments != null ? new MatchResult(name, matcher.matchingDegree(name, false, fragments), MinusculeMatcher.isStartMatch((Iterable)fragments)) : null;
    }

    @NotNull
    private static MinusculeMatcher buildPatternMatcher(@NotNull String pattern, boolean preferStartMatches) {
        NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)pattern).withCaseSensitivity(NameUtil.MatchingCaseSensitivity.NONE);
        if (preferStartMatches) {
            builder2 = builder2.preferringStartMatches();
        }
        return builder2.build();
    }

    private static /* synthetic */ boolean lambda$getAllNames$8(ProgressIndicator indicator, ChooseByNameViewModel base, String fullPattern, MinusculeMatcher matcher, CollectConsumer collect, String sequence) {
        indicator.checkCanceled();
        MatchResult result2 = DefaultChooseByNameItemProvider.matches(base, fullPattern, matcher, sequence);
        if (result2 != null) {
            collect.consume((Object)result2);
            return true;
        }
        return false;
    }

    protected static class PathProximityComparator
    implements Comparator<Object> {
        @NotNull
        private final PsiProximityComparator myProximityComparator;

        private PathProximityComparator(@Nullable PsiElement context) {
            this.myProximityComparator = new PsiProximityComparator(context);
        }

        private static boolean isCompiledWithoutSource(Object o) {
            return o instanceof PsiCompiledElement && ((PsiCompiledElement)o).getNavigationElement() == o;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int rc = this.myProximityComparator.compare(o1, o2);
            if (rc != 0) {
                return rc;
            }
            int o1Weight = PathProximityComparator.isCompiledWithoutSource(o1) ? 1 : 0;
            int o2Weight = PathProximityComparator.isCompiledWithoutSource(o2) ? 1 : 0;
            return o1Weight - o2Weight;
        }
    }
}

