/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class ContributorsBasedGotoByModel
implements ChooseByNameModelEx,
PossiblyDumbAware {
    public static final Logger LOG = Logger.getInstance(ContributorsBasedGotoByModel.class);
    protected final Project myProject;
    private final List<ChooseByNameContributor> myContributors;
    private final ConcurrentMap<ChooseByNameContributor, TIntHashSet> myContributorToItsSymbolsMap = ContainerUtil.createConcurrentWeakMap();

    protected ContributorsBasedGotoByModel(@NotNull Project project, ChooseByNameContributor @NotNull [] contributors) {
        this(project, Arrays.asList(contributors));
    }

    protected ContributorsBasedGotoByModel(@NotNull Project project, @NotNull List<ChooseByNameContributor> contributors) {
        this.myProject = project;
        this.myContributors = contributors;
        assert (!contributors.contains(null));
    }

    public boolean isDumbAware() {
        return ContainerUtil.find(this.getContributorList(), o -> DumbService.isDumbAware((Object)o)) != null;
    }

    @NotNull
    public ListCellRenderer getListCellRenderer() {
        return new NavigationItemListCellRenderer();
    }

    public boolean sameNamesForProjectAndLibraries() {
        return false;
    }

    @Override
    public void processNames(final @NotNull Processor<? super String> nameProcessor, final @NotNull FindSymbolParameters parameters2) {
        long start2 = System.currentTimeMillis();
        List<ChooseByNameContributor> contributors = this.filterDumb(this.getContributorList());
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        ReadActionProcessor<ChooseByNameContributor> processor2 = new ReadActionProcessor<ChooseByNameContributor>(){

            public boolean processInReadAction(@NotNull ChooseByNameContributor contributor) {
                try {
                    if (!ContributorsBasedGotoByModel.this.myProject.isDisposed()) {
                        long contributorStarted = System.currentTimeMillis();
                        ContributorsBasedGotoByModel.this.processContributorNames(contributor, parameters2, (Processor<? super String>)nameProcessor);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(contributor + " for " + (System.currentTimeMillis() - contributorStarted));
                        }
                    }
                }
                catch (ProcessCanceledException | IndexNotReadyException contributorStarted) {
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex);
                }
                return true;
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(contributors, indicator, processor2)) {
            throw new ProcessCanceledException();
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        long finish = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug("processNames(): " + (finish - start2) + "ms;");
        }
    }

    public void processContributorNames(@NotNull ChooseByNameContributor contributor, @NotNull FindSymbolParameters parameters2, @NotNull Processor<? super String> nameProcessor) {
        TIntHashSet filter2 = new TIntHashSet(1000);
        if (contributor instanceof ChooseByNameContributorEx) {
            ((ChooseByNameContributorEx)contributor).processNames((Processor<? super String>)((Processor)s -> {
                if (nameProcessor.process(s)) {
                    filter2.add(s.hashCode());
                }
                return true;
            }), parameters2.getSearchScope(), parameters2.getIdFilter());
        } else {
            String[] names2;
            for (String element2 : names2 = contributor.getNames(this.myProject, parameters2.isSearchInLibraries())) {
                if (!nameProcessor.process((Object)element2)) continue;
                filter2.add(element2.hashCode());
            }
        }
        this.myContributorToItsSymbolsMap.put(contributor, filter2);
    }

    IdFilter getIdFilter(boolean withLibraries) {
        return IdFilter.getProjectIdFilter((Project)this.myProject, (boolean)withLibraries);
    }

    public String @NotNull [] getNames(boolean checkBoxState) {
        THashSet allNames = new THashSet();
        Collection result2 = Collections.synchronizedCollection(allNames);
        this.processNames((Processor<? super String>)Processors.cancelableCollectProcessor(result2), FindSymbolParameters.simple(this.myProject, checkBoxState));
        if (LOG.isDebugEnabled()) {
            LOG.debug("getNames(): (got " + allNames.size() + " elements)");
        }
        return ArrayUtilRt.toStringArray((Collection)allNames);
    }

    private List<ChooseByNameContributor> filterDumb(List<ChooseByNameContributor> contributors) {
        if (!DumbService.getInstance((Project)this.myProject).isDumb()) {
            return contributors;
        }
        ArrayList<ChooseByNameContributor> answer = new ArrayList<ChooseByNameContributor>(contributors.size());
        for (ChooseByNameContributor contributor : contributors) {
            if (!DumbService.isDumbAware((Object)contributor)) continue;
            answer.add(contributor);
        }
        return answer;
    }

    public Object @NotNull [] getElementsByName(@NotNull String name, @NotNull FindSymbolParameters parameters2, @NotNull ProgressIndicator canceled) {
        List applicable = ContainerUtil.filter(this.filterDumb(this.getContributorList()), contributor -> {
            TIntHashSet filter2 = (TIntHashSet)this.myContributorToItsSymbolsMap.get(contributor);
            return filter2 == null || filter2.contains(name.hashCode());
        });
        if (applicable.isEmpty()) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        long elementByNameStarted = System.currentTimeMillis();
        List items = Collections.synchronizedList(new ArrayList());
        Processor processor2 = contributor -> {
            if (this.myProject.isDisposed()) {
                return true;
            }
            try {
                boolean searchInLibraries = parameters2.isSearchInLibraries();
                long contributorStarted = System.currentTimeMillis();
                if (contributor instanceof ChooseByNameContributorEx) {
                    ((ChooseByNameContributorEx)contributor).processElementsWithName(name, (Processor<? super NavigationItem>)((Processor)item -> {
                        canceled.checkCanceled();
                        if (this.acceptItem((NavigationItem)item)) {
                            items.add(item);
                        }
                        return true;
                    }), parameters2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + ",");
                    }
                } else {
                    NavigationItem[] itemsByName;
                    for (NavigationItem item2 : itemsByName = contributor.getItemsByName(name, parameters2.getLocalPatternName(), this.myProject, searchInLibraries)) {
                        VirtualFile file2;
                        canceled.checkCanceled();
                        if (item2 == null) {
                            PluginException.logPluginError((Logger)LOG, (String)("null item from contributor " + contributor + " for name " + name), null, contributor.getClass());
                            continue;
                        }
                        VirtualFile virtualFile = file2 = item2 instanceof PsiElement && !(item2 instanceof PomTargetPsiElement) ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)item2)) : null;
                        if (file2 != null && !parameters2.getSearchScope().contains(file2) || !this.acceptItem(item2)) continue;
                        items.add(item2);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(System.currentTimeMillis() - contributorStarted + "," + contributor + "," + itemsByName.length);
                    }
                }
            }
            catch (ProcessCanceledException searchInLibraries) {
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
            return true;
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(applicable, canceled, processor2)) {
            canceled.cancel();
        }
        canceled.checkCanceled();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving " + name + ":" + items.size() + " for " + (System.currentTimeMillis() - elementByNameStarted));
        }
        return ArrayUtil.toObjectArray(items);
    }

    public Object @NotNull [] getElementsByName(@NotNull String name, boolean checkBoxState, @NotNull String pattern) {
        return this.getElementsByName(name, FindSymbolParameters.wrap(pattern, this.myProject, checkBoxState), new ProgressIndicatorBase());
    }

    public String getElementName(@NotNull Object element2) {
        if (!(element2 instanceof NavigationItem)) {
            throw new AssertionError((Object)(element2 + " of " + element2.getClass() + " in " + this + " of " + this.getClass()));
        }
        return ((NavigationItem)element2).getName();
    }

    public String getHelpId() {
        return null;
    }

    protected List<ChooseByNameContributor> getContributorList() {
        return this.myContributors;
    }

    protected ChooseByNameContributor[] getContributors() {
        return this.getContributorList().toArray(new ChooseByNameContributor[0]);
    }

    protected boolean acceptItem(NavigationItem item) {
        return true;
    }

    public boolean useMiddleMatching() {
        return true;
    }

    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        return pattern;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }
}

