/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import com.intellij.Patches;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.GotoFileAction;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.util.gotoByName.AnchoredSet;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModelEx;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ChooseByNameViewModel;
import com.intellij.ide.util.gotoByName.ContributorsBasedGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.ide.util.gotoByName.PreserveSelection;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.ide.util.gotoByName.SelectIndex;
import com.intellij.ide.util.gotoByName.SelectMostRelevant;
import com.intellij.ide.util.gotoByName.SelectionPolicy;
import com.intellij.ide.util.gotoByName.SelectionPolicyKt;
import com.intellij.ide.util.gotoByName.SelectionSnapshot;
import com.intellij.ide.util.gotoByName.SmartPointerListModel;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseByNameBase
implements ChooseByNameViewModel {
    public static final String TEMPORARILY_FOCUSABLE_COMPONENT_KEY = "ChooseByNameBase.TemporarilyFocusableComponent";
    private static final Logger LOG = Logger.getInstance(ChooseByNameBase.class);
    @Nullable
    protected final Project myProject;
    protected final ChooseByNameModel myModel;
    @NotNull
    protected ChooseByNameItemProvider myProvider;
    final String myInitialText;
    private boolean mySearchInAnyPlace;
    Component myPreviouslyFocusedComponent;
    private boolean myInitialized;
    final JPanelProvider myTextFieldPanel = new JPanelProvider();
    protected final MyTextField myTextField = new MyTextField();
    private final CardLayout myCard = new CardLayout();
    private final JPanel myCardContainer = new JPanel(this.myCard);
    protected final JCheckBox myCheckBox = new JCheckBox();
    private JComponent myToolArea;
    JScrollPane myListScrollPane;
    private final SmartPointerListModel<Object> myListModel = new SmartPointerListModel();
    protected final JList<Object> myList = new JBList(this.myListModel);
    private final List<Pair<String, Integer>> myHistory = new ArrayList<Pair<String, Integer>>();
    private final List<Pair<String, Integer>> myFuture = new ArrayList<Pair<String, Integer>>();
    protected ChooseByNamePopupComponent.Callback myActionListener;
    protected final Alarm myAlarm = new Alarm();
    private boolean myDisposedFlag;
    private final String[][] myNames = new String[2][];
    private volatile CalcElementsThread myCalcElementsThread;
    private int myListSizeIncreasing = 30;
    private int myMaximumListSizeLimit = 30;
    @NonNls
    private static final String NOT_FOUND_IN_PROJECT_CARD = "syslib";
    @NonNls
    private static final String NOT_FOUND_CARD = "nfound";
    @NonNls
    private static final String CHECK_BOX_CARD = "chkbox";
    @NonNls
    private static final String SEARCHING_CARD = "searching";
    private final int myRebuildDelay;
    private final Alarm myHideAlarm = new Alarm();
    private static final boolean myShowListAfterCompletionKeyStroke = false;
    JBPopup myTextPopup;
    protected JBPopup myDropdownPopup;
    private boolean myClosedByShiftEnter;
    final int myInitialIndex;
    private String myFindUsagesTitle;
    private ShortcutSet myCheckBoxShortcut;
    private final boolean myInitIsDone;
    private boolean myAlwaysHasMore;
    private Point myFocusPoint;
    @Nullable
    SelectionSnapshot currentChosenInfo;
    public static final String EXTRA_ELEM = "...";
    private static final String ACTION_NAME = "Show All in View";

    public boolean checkDisposed() {
        return this.myDisposedFlag;
    }

    public void setDisposed(boolean disposedFlag) {
        this.myDisposedFlag = disposedFlag;
        if (disposedFlag) {
            this.setNamesSync(true, null);
            this.setNamesSync(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNamesSync(boolean checkboxState, String @Nullable [] value2) {
        String[][] stringArray = this.myNames;
        synchronized (this.myNames) {
            this.myNames[checkboxState ? 1 : 0] = value2;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected ChooseByNameBase(Project project, @NotNull ChooseByNameModel model, String initialText, PsiElement context) {
        this(project, model, ChooseByNameModelEx.getItemProvider(model, context), initialText, 0);
    }

    protected ChooseByNameBase(Project project, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, String initialText) {
        this(project, model, provider, initialText, 0);
    }

    protected ChooseByNameBase(@Nullable Project project, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, String initialText, int initialIndex) {
        this.myProject = project;
        this.myModel = model;
        this.myInitialText = initialText;
        this.myProvider = provider;
        this.myInitialIndex = initialIndex;
        this.mySearchInAnyPlace = Registry.is((String)"ide.goto.middle.matching") && model.useMiddleMatching();
        this.myRebuildDelay = Registry.intValue((String)"ide.goto.rebuild.delay");
        this.myTextField.setText(this.myInitialText);
        this.myInitIsDone = true;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public boolean isSearchInAnyPlace() {
        return this.mySearchInAnyPlace;
    }

    public void setSearchInAnyPlace(boolean searchInAnyPlace) {
        this.mySearchInAnyPlace = searchInAnyPlace;
    }

    public boolean isClosedByShiftEnter() {
        return this.myClosedByShiftEnter;
    }

    public boolean isOpenInCurrentWindowRequested() {
        return this.isClosedByShiftEnter();
    }

    public void setToolArea(@NotNull JComponent toolArea) {
        if (this.myToolArea != null) {
            throw new IllegalStateException("Tool area is modifiable only before invoke()");
        }
        this.myToolArea = toolArea;
    }

    public void setFindUsagesTitle(@Nullable String findUsagesTitle) {
        this.myFindUsagesTitle = findUsagesTitle;
    }

    public void invoke(ChooseByNamePopupComponent.Callback callback2, ModalityState modalityState, boolean allowMultipleSelection) {
        this.initUI(callback2, modalityState, allowMultipleSelection);
    }

    @Override
    @NotNull
    public ChooseByNameModel getModel() {
        return this.myModel;
    }

    protected void initUI(ChooseByNamePopupComponent.Callback callback2, ModalityState modalityState, boolean allowMultipleSelection) {
        Color color;
        this.myPreviouslyFocusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
        this.myActionListener = callback2;
        this.myTextFieldPanel.setLayout(new BoxLayout(this.myTextFieldPanel, 1));
        JPanel hBox = new JPanel();
        hBox.setLayout(new BoxLayout(hBox, 0));
        JPanel caption2Tools = new JPanel(new BorderLayout());
        if (this.myModel.getPromptText() != null) {
            JLabel label2 = new JLabel(this.myModel.getPromptText());
            label2.setFont(UIUtil.getLabelFont().deriveFont(1));
            caption2Tools.add((Component)label2, "West");
        }
        caption2Tools.add((Component)hBox, "East");
        String checkBoxName = this.myModel.getCheckBoxName();
        Color fg = UIUtil.getLabelDisabledForeground();
        Color color2 = color = StartupUiUtil.isUnderDarcula() ? ColorUtil.shift((Color)fg, (double)1.2) : ColorUtil.shift((Color)fg, (double)0.7);
        String text = checkBoxName == null ? "" : "<html>" + checkBoxName + (this.myCheckBoxShortcut != null && this.myCheckBoxShortcut.getShortcuts().length > 0 ? " <b color='" + ColorUtil.toHex((Color)color) + "'>" + KeymapUtil.getShortcutsText((Shortcut[])this.myCheckBoxShortcut.getShortcuts()) + "</b>" : "") + "</html>";
        this.myCheckBox.setText(text);
        this.myCheckBox.setAlignmentX(4.0f);
        this.myCheckBox.setBorder(null);
        this.myCheckBox.setSelected(this.myModel.loadInitialCheckBoxState());
        if (checkBoxName == null) {
            this.myCheckBox.setVisible(false);
        }
        this.addCard(this.myCheckBox, CHECK_BOX_CARD);
        this.addCard(new HintLabel(this.myModel.getNotInMessage()), NOT_FOUND_IN_PROJECT_CARD);
        this.addCard(new HintLabel(IdeBundle.message((String)"label.choosebyname.no.matches.found", (Object[])new Object[0])), NOT_FOUND_CARD);
        JPanel searching = new JPanel(new BorderLayout(5, 0));
        searching.add((Component)new AsyncProcessIcon(SEARCHING_CARD), "West");
        searching.add((Component)new HintLabel(IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0])), "Center");
        this.addCard(searching, SEARCHING_CARD);
        this.myCard.show(this.myCardContainer, CHECK_BOX_CARD);
        if (this.isCheckboxVisible()) {
            hBox.add(this.myCardContainer);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ShowFindUsagesAction(){

            @Override
            public PsiElement @NotNull [] getElements() {
                List objects = ChooseByNameBase.this.myListModel.getItems();
                ArrayList<PsiElement> elements2 = new ArrayList<PsiElement>(objects.size());
                for (Object object : objects) {
                    if (object instanceof PsiElement) {
                        elements2.add((PsiElement)object);
                        continue;
                    }
                    if (!(object instanceof DataProvider)) continue;
                    ContainerUtil.addIfNotNull(elements2, (Object)CommonDataKeys.PSI_ELEMENT.getData((DataProvider)object));
                }
                return PsiUtilCore.toPsiElementArray(elements2);
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ChooseByNameBase", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(0);
        actionToolbar.updateActionsImmediately();
        JComponent toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setBorder(null);
        if (this.myToolArea == null) {
            this.myToolArea = new JLabel((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1, (int)24)));
        } else {
            this.myToolArea.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        }
        hBox.add(this.myToolArea);
        hBox.add(toolbarComponent);
        this.myTextFieldPanel.add(caption2Tools);
        new MyCopyReferenceAction().registerCustomShortcutSet(ActionManager.getInstance().getAction("$Copy").getShortcutSet(), this.myTextField);
        this.myTextFieldPanel.add(this.myTextField);
        Font editorFont = EditorUtil.getEditorFont();
        this.myTextField.setFont(editorFont);
        this.myTextField.putClientProperty("caretWidth", JBUIScale.scale((int)EditorUtil.getDefaultCaretWidth()));
        if (checkBoxName != null && this.myCheckBoxShortcut != null) {
            new DumbAwareAction(IdeBundle.messagePointer((String)"action.AnActionButton.text.change.goto.check.box", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ChooseByNameBase.this.myCheckBox.setSelected(!ChooseByNameBase.this.myCheckBox.isSelected());
                }
            }.registerCustomShortcutSet(this.myCheckBoxShortcut, (JComponent)this.myTextField);
        }
        if (this.isCloseByFocusLost()) {
            this.myTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(@NotNull FocusEvent e) {
                    if (Registry.is((String)"focus.follows.mouse.workarounds")) {
                        PointerInfo pointerInfo;
                        if (ChooseByNameBase.this.myFocusPoint != null && (pointerInfo = MouseInfo.getPointerInfo()) != null && ChooseByNameBase.this.myFocusPoint.equals(pointerInfo.getLocation())) {
                            IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                            ChooseByNameBase.this.myFocusPoint = null;
                            return;
                        }
                        ChooseByNameBase.this.myFocusPoint = null;
                    }
                    ChooseByNameBase.this.cancelListUpdater();
                    ChooseByNameBase.this.myHideAlarm.addRequest(() -> {
                        JBPopup popup2 = JBPopupFactory.getInstance().getChildFocusedPopup(e.getComponent());
                        if (popup2 != null) {
                            popup2.addListener(new JBPopupListener(){

                                public void onClosed(@NotNull LightweightWindowEvent event) {
                                    if (event.isOk()) {
                                        ChooseByNameBase.this.hideHint();
                                    }
                                }
                            });
                        } else {
                            Component oppositeComponent = e.getOppositeComponent();
                            if (oppositeComponent == ChooseByNameBase.this.myCheckBox) {
                                IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                                return;
                            }
                            if (oppositeComponent != null && !(oppositeComponent instanceof JFrame) && ChooseByNameBase.this.myList.isShowing() && (oppositeComponent == ChooseByNameBase.this.myList || SwingUtilities.isDescendingFrom(ChooseByNameBase.this.myList, oppositeComponent))) {
                                IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                                return;
                            }
                            if (ChooseByNameBase.this.isDescendingFromTemporarilyFocusableToolWindow(oppositeComponent)) {
                                return;
                            }
                            if (UIUtil.haveCommonOwner((Component)oppositeComponent, (Component)e.getComponent())) {
                                return;
                            }
                            ChooseByNameBase.this.hideHint();
                        }
                    }, 5);
                }
            });
        }
        this.myCheckBox.addItemListener(__ -> this.rebuildList(false));
        this.myCheckBox.setFocusable(false);
        this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                SelectMostRelevant toSelect2 = ChooseByNameBase.this.currentChosenInfo != null && ChooseByNameBase.this.currentChosenInfo.hasSamePattern(ChooseByNameBase.this) ? PreserveSelection.INSTANCE : SelectMostRelevant.INSTANCE;
                ChooseByNameBase.this.rebuildList(toSelect2, ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
            }
        });
        final Set<KeyStroke> upShortcuts = ChooseByNameBase.getShortcuts("EditorUp");
        final Set<KeyStroke> downShortcuts = ChooseByNameBase.getShortcuts("EditorDown");
        this.myTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e.getKeyCode() == 10 && (e.getModifiers() & 1) != 0) {
                    ChooseByNameBase.this.myClosedByShiftEnter = true;
                    ChooseByNameBase.this.close(true);
                }
                if (!ChooseByNameBase.this.myListScrollPane.isVisible()) {
                    return;
                }
                KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
                int keyCode = upShortcuts.contains(stroke) ? 38 : (downShortcuts.contains(stroke) ? 40 : e.getKeyCode());
                switch (keyCode) {
                    case 40: {
                        ScrollingUtil.moveDown(ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 38: {
                        ScrollingUtil.moveUp(ChooseByNameBase.this.myList, (int)e.getModifiersEx());
                        break;
                    }
                    case 33: {
                        ScrollingUtil.movePageUp(ChooseByNameBase.this.myList);
                        break;
                    }
                    case 34: {
                        ScrollingUtil.movePageDown(ChooseByNameBase.this.myList);
                        break;
                    }
                    case 9: {
                        ChooseByNameBase.this.close(true);
                        break;
                    }
                    case 10: {
                        if (ChooseByNameBase.this.myList.getSelectedValue() != ChooseByNameBase.EXTRA_ELEM) break;
                        ChooseByNameBase.this.myMaximumListSizeLimit = ChooseByNameBase.this.myMaximumListSizeLimit + ChooseByNameBase.this.myListSizeIncreasing;
                        ChooseByNameBase.this.rebuildList(new SelectIndex(ChooseByNameBase.this.myList.getSelectedIndex()), ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
                        e.consume();
                    }
                }
            }
        });
        this.myTextField.addActionListener(__ -> {
            if (!this.getChosenElements().isEmpty()) {
                this.doClose(true);
            }
        });
        this.myList.setFocusable(false);
        this.myList.setSelectionMode(allowMultipleSelection ? 2 : 0);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (!ChooseByNameBase.this.myTextField.hasFocus()) {
                    IdeFocusManager.getInstance((Project)ChooseByNameBase.this.myProject).requestFocus((Component)ChooseByNameBase.this.myTextField, true);
                }
                if (clickCount == 2) {
                    int selectedIndex = ChooseByNameBase.this.myList.getSelectedIndex();
                    Rectangle selectedCellBounds = ChooseByNameBase.this.myList.getCellBounds(selectedIndex, selectedIndex);
                    if (selectedCellBounds != null && selectedCellBounds.contains(e.getPoint())) {
                        if (ChooseByNameBase.this.myList.getSelectedValue() == ChooseByNameBase.EXTRA_ELEM) {
                            ChooseByNameBase.this.myMaximumListSizeLimit = ChooseByNameBase.this.myMaximumListSizeLimit + ChooseByNameBase.this.myListSizeIncreasing;
                            ChooseByNameBase.this.rebuildList(new SelectIndex(selectedIndex), ChooseByNameBase.this.myRebuildDelay, ModalityState.current(), null);
                        } else {
                            ChooseByNameBase.this.doClose(true);
                        }
                    }
                    return true;
                }
                return false;
            }
        }.installOn(this.myList);
        ListCellRenderer modelRenderer = this.myModel.getListCellRenderer();
        this.myList.setCellRenderer((list2, value2, index, isSelected, cellHasFocus) -> (Component)AstLoadingFilter.disallowTreeLoading(() -> modelRenderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus)));
        this.myList.setVisibleRowCount(16);
        this.myList.setFont(editorFont);
        this.myList.addListSelectionListener(__ -> {
            if (this.checkDisposed()) {
                return;
            }
            this.chosenElementMightChange();
            this.updateDocumentation();
            List<Object> chosenElements = this.getChosenElements();
            if (!chosenElements.isEmpty()) {
                this.currentChosenInfo = new SelectionSnapshot(this.getTrimmedText(), new HashSet<Object>(chosenElements));
            }
        });
        this.myListScrollPane = ScrollPaneFactory.createScrollPane(this.myList, (boolean)true);
        this.myTextFieldPanel.setBorder(JBUI.Borders.empty((int)5));
        this.showTextFieldPanel();
        this.myInitialized = true;
        if (modalityState != null) {
            this.rebuildList(SelectionPolicyKt.fromIndex(this.myInitialIndex), 0, modalityState, null);
        }
    }

    private boolean isDescendingFromTemporarilyFocusableToolWindow(@Nullable Component component2) {
        if (component2 == null || this.myProject == null || this.myProject.isDisposed()) {
            return false;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
        String activeToolWindowId = toolWindowManager.getActiveToolWindowId();
        ToolWindow toolWindow = activeToolWindowId == null ? null : toolWindowManager.getToolWindow(activeToolWindowId);
        JComponent toolWindowComponent = toolWindow != null ? toolWindow.getComponent() : null;
        return toolWindowComponent != null && toolWindowComponent.getClientProperty(TEMPORARILY_FOCUSABLE_COMPONENT_KEY) != null && SwingUtilities.isDescendingFrom(component2, toolWindowComponent);
    }

    private void addCard(@NotNull JComponent comp, @NotNull String cardId) {
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)comp, "East");
        this.myCardContainer.add((Component)wrapper2, cardId);
    }

    public void setCheckBoxShortcut(@NotNull ShortcutSet shortcutSet) {
        this.myCheckBoxShortcut = shortcutSet;
    }

    @NotNull
    private static Set<KeyStroke> getShortcuts(@NotNull String actionId) {
        HashSet<KeyStroke> result2 = new HashSet<KeyStroke>();
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            result2.add(keyboardShortcut.getFirstKeyStroke());
        }
        return result2;
    }

    private void hideHint() {
        if (!this.myTextFieldPanel.focusRequested()) {
            this.doClose(false);
            this.myTextFieldPanel.hideHint();
        }
    }

    public void rebuildList(boolean initial) {
        this.rebuildList(initial ? SelectionPolicyKt.fromIndex(this.myInitialIndex) : SelectMostRelevant.INSTANCE, this.myRebuildDelay, ModalityState.current(), null);
    }

    private void updateDocumentation() {
        JBPopup hint = this.myTextFieldPanel.getHint();
        Object element2 = this.getChosenElement();
        if (hint != null) {
            Object o;
            if (element2 instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)element2);
            } else if (element2 instanceof DataProvider && (o = ((DataProvider)element2).getData(CommonDataKeys.PSI_ELEMENT.getName())) instanceof PsiElement) {
                this.myTextFieldPanel.updateHint((PsiElement)o);
            }
        }
    }

    @Override
    @NotNull
    public String transformPattern(@NotNull String pattern) {
        return pattern;
    }

    protected void doClose(boolean ok) {
        if (this.checkDisposed()) {
            return;
        }
        if (this.closeForbidden(ok)) {
            return;
        }
        this.cancelListUpdater();
        this.close(ok);
        this.myListModel.removeAll();
    }

    protected boolean closeForbidden(boolean ok) {
        return false;
    }

    void cancelListUpdater() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.checkDisposed()) {
            return;
        }
        CalcElementsThread calcElementsThread = this.myCalcElementsThread;
        if (calcElementsThread != null) {
            calcElementsThread.cancel();
            this.myCalcElementsThread = null;
        }
    }

    @NotNull
    public String getTrimmedText() {
        return StringUtil.trimLeading((String)StringUtil.notNullize((String)this.myTextField.getText()));
    }

    private synchronized String @NotNull [] ensureNamesLoaded(boolean checkboxState) {
        String[] cached = this.getNamesSync(checkboxState);
        if (cached != null) {
            return cached;
        }
        if (checkboxState && this.myModel instanceof ContributorsBasedGotoByModel && ((ContributorsBasedGotoByModel)this.myModel).sameNamesForProjectAndLibraries() && this.getNamesSync(false) != null) {
            String[] allNames = this.getNamesSync(false);
            this.setNamesSync(true, allNames);
            return allNames;
        }
        String[] result2 = this.myModel.getNames(checkboxState);
        assert (result2 != null) : "Model " + this.myModel + "(" + this.myModel.getClass() + ") returned null names";
        this.setNamesSync(checkboxState, result2);
        return result2;
    }

    public String @NotNull [] getNames(boolean checkboxState) {
        this.setNamesSync(checkboxState, null);
        return this.ensureNamesLoaded(checkboxState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getNamesSync(boolean checkboxState) {
        String[][] stringArray = this.myNames;
        synchronized (this.myNames) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.myNames[checkboxState ? 1 : 0];
        }
    }

    @NotNull
    protected Set<Object> filter(@NotNull Set<Object> elements2) {
        return elements2;
    }

    protected abstract boolean isCheckboxVisible();

    protected abstract boolean isShowListForEmptyPattern();

    protected abstract boolean isCloseByFocusLost();

    protected void showTextFieldPanel() {
        JLayeredPane layeredPane = this.getLayeredPane();
        Dimension preferredTextFieldPanelSize = this.myTextFieldPanel.getPreferredSize();
        int x = (layeredPane.getWidth() - preferredTextFieldPanelSize.width) / 2;
        int paneHeight = layeredPane.getHeight();
        int y = paneHeight / 3 - preferredTextFieldPanelSize.height / 2;
        ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myTextFieldPanel, (JComponent)this.myTextField);
        builder2.setLocateWithinScreenBounds(false);
        builder2.setKeyEventHandler(event -> {
            if (this.myTextPopup == null || !AbstractPopup.isCloseRequest(event) || !this.myTextPopup.isCancelKeyEnabled()) {
                return false;
            }
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
            if (this.isDescendingFromTemporarilyFocusableToolWindow(focusManager.getFocusOwner())) {
                focusManager.requestFocus((Component)this.myTextField, true);
                return false;
            }
            this.myTextPopup.cancel((InputEvent)event);
            return true;
        }).setCancelCallback(() -> {
            this.myTextPopup = null;
            this.close(false);
            return Boolean.TRUE;
        }).setFocusable(true).setRequestFocus(true).setModalContext(false).setCancelOnClickOutside(false);
        Point point = new Point(x, y);
        SwingUtilities.convertPointToScreen(point, layeredPane);
        Rectangle bounds2 = new Rectangle(point, new Dimension(preferredTextFieldPanelSize.width + 20, preferredTextFieldPanelSize.height));
        this.myTextPopup = builder2.createPopup();
        this.myTextPopup.setSize(bounds2.getSize());
        this.myTextPopup.setLocation(bounds2.getLocation());
        MnemonicHelper.init((Component)this.myTextFieldPanel);
        if (this.myProject != null && !this.myProject.isDefault()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)this.myTextPopup);
        }
        Disposer.register((Disposable)this.myTextPopup, () -> this.cancelListUpdater());
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        this.myTextPopup.show((Component)layeredPane);
    }

    private JLayeredPane getLayeredPane() {
        JLayeredPane layeredPane;
        Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
        if (window instanceof JFrame) {
            layeredPane = ((JFrame)window).getLayeredPane();
        } else if (window instanceof JDialog) {
            layeredPane = ((JDialog)window).getLayeredPane();
        } else if (window instanceof JWindow) {
            layeredPane = ((JWindow)window).getLayeredPane();
        } else {
            throw new IllegalStateException("cannot find parent window: project=" + this.myProject + (this.myProject != null ? "; open=" + this.myProject.isOpen() : "") + "; window=" + window);
        }
        return layeredPane;
    }

    void rebuildList(@NotNull SelectionPolicy pos, int delay, @NotNull ModalityState modalityState, @Nullable Runnable postRunnable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myInitialized) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        if (delay > 0) {
            this.myAlarm.addRequest(() -> this.rebuildList(pos, 0, modalityState, postRunnable), delay, ModalityState.stateForComponent((Component)this.myTextField));
            return;
        }
        CalcElementsThread calcElementsThread = this.myCalcElementsThread;
        if (calcElementsThread != null) {
            calcElementsThread.cancel();
        }
        String text = this.getTrimmedText();
        if (!this.canShowListForEmptyPattern() && text.isEmpty()) {
            this.myListModel.removeAll();
            this.hideList();
            this.myTextFieldPanel.hideHint();
            this.myCard.show(this.myCardContainer, CHECK_BOX_CARD);
            return;
        }
        ListCellRenderer cellRenderer = this.myList.getCellRenderer();
        if (cellRenderer instanceof ExpandedItemListCellRendererWrapper) {
            cellRenderer = ((ExpandedItemListCellRendererWrapper)cellRenderer).getWrappee();
        }
        String pattern = ChooseByNameBase.patternToLowerCase(this.transformPattern(text));
        Matcher matcher = ChooseByNameBase.buildPatternMatcher(this.isSearchInAnyPlace() ? "*" + pattern : pattern);
        if (cellRenderer instanceof MatcherHolder) {
            ((MatcherHolder)((Object)cellRenderer)).setPatternMatcher(matcher);
        }
        MatcherHolder.associateMatcher(this.myList, matcher);
        this.scheduleCalcElements(text, this.myCheckBox.isSelected(), modalityState, pos, elements2 -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (postRunnable != null) {
                postRunnable.run();
            }
        });
    }

    private void backgroundCalculationFinished(@NotNull Collection<?> result2, @NotNull SelectionPolicy toSelect2) {
        this.myCalcElementsThread = null;
        this.setElementsToList(toSelect2, result2);
        this.myList.repaint();
        this.chosenElementMightChange();
        if (result2.isEmpty()) {
            this.myTextFieldPanel.hideHint();
        }
    }

    public void scheduleCalcElements(@NotNull String text, boolean checkboxState, @NotNull ModalityState modalityState, @NotNull SelectionPolicy policy, @NotNull Consumer<? super Set<?>> callback2) {
        new CalcElementsThread(text, checkboxState, modalityState, policy, callback2).scheduleThread();
    }

    private static boolean isShowListAfterCompletionKeyStroke() {
        return false;
    }

    private void setElementsToList(@NotNull SelectionPolicy pos, @NotNull Collection<?> elements2) {
        PointerInfo pointerInfo;
        if (this.checkDisposed()) {
            return;
        }
        if (this.isCloseByFocusLost() && Registry.is((String)"focus.follows.mouse.workarounds") && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
            this.myFocusPoint = pointerInfo.getLocation();
        }
        if (elements2.isEmpty()) {
            this.myListModel.removeAll();
            this.myTextField.setForeground((Color)JBColor.red);
            this.hideList();
            return;
        }
        Object[] oldElements = this.myListModel.getItems().toArray();
        Object[] newElements = elements2.toArray();
        if (ArrayUtil.contains(null, (Object[])newElements)) {
            LOG.error("Null after filtering elements by " + this);
        }
        List<ModelDiff.Cmd> commands = ModelDiff.createDiffCmds(this.myListModel, oldElements, newElements);
        this.myTextField.setForeground(UIUtil.getTextFieldForeground());
        if (commands == null || commands.isEmpty()) {
            this.applySelection(pos);
            this.showList();
            this.myTextFieldPanel.repositionHint();
        } else {
            this.appendToModel(commands, pos);
        }
    }

    @VisibleForTesting
    public int calcSelectedIndex(Object @NotNull [] modelElements, @NotNull String trimmedText) {
        int bestPosition;
        if (this.myModel instanceof Comparator) {
            return 0;
        }
        Matcher matcher = ChooseByNameBase.buildPatternMatcher(this.transformPattern(trimmedText));
        String statContext = this.statisticsContext();
        Comparator<Object> itemComparator = Comparator.comparing(e -> trimmedText.equalsIgnoreCase(this.myModel.getElementName(e))).thenComparing(e -> this.matchingDegree(matcher, e)).thenComparing(e -> this.getUseCount(statContext, e)).reversed();
        for (bestPosition = 0; bestPosition < modelElements.length - 1 && ChooseByNameBase.isSpecialElement(modelElements[bestPosition]); ++bestPosition) {
        }
        for (int i2 = 1; i2 < modelElements.length; ++i2) {
            Object modelElement = modelElements[i2];
            if (ChooseByNameBase.isSpecialElement(modelElement) || itemComparator.compare(modelElement, modelElements[bestPosition]) >= 0) continue;
            bestPosition = i2;
        }
        return bestPosition;
    }

    private static boolean isSpecialElement(@NotNull Object modelElement) {
        return EXTRA_ELEM.equals(modelElement);
    }

    private int getUseCount(@NotNull String statContext, @NotNull Object modelElement) {
        String text = this.myModel.getFullName(modelElement);
        return text == null ? Integer.MIN_VALUE : StatisticsManager.getInstance().getUseCount(new StatisticsInfo(statContext, text));
    }

    private int matchingDegree(@NotNull Matcher matcher, @NotNull Object modelElement) {
        String name = this.myModel.getElementName(modelElement);
        return name != null && matcher instanceof MinusculeMatcher ? ((MinusculeMatcher)matcher).matchingDegree(name) : Integer.MIN_VALUE;
    }

    @NotNull
    @NonNls
    String statisticsContext() {
        return "choose_by_name#" + this.myModel.getPromptText() + "#" + this.myCheckBox.isSelected() + "#" + this.getTrimmedText();
    }

    private void appendToModel(@NotNull List<? extends ModelDiff.Cmd> commands, @NotNull SelectionPolicy selection) {
        for (ModelDiff.Cmd cmd : commands) {
            cmd.apply();
        }
        this.showList();
        this.myTextFieldPanel.repositionHint();
        if (!this.myListModel.isEmpty()) {
            this.applySelection(selection);
        }
    }

    private void applySelection(@NotNull SelectionPolicy selection) {
        List<Integer> indices = selection.performSelection(this, this.myListModel);
        this.myList.setSelectedIndices(Ints.toArray(indices));
        if (!indices.isEmpty()) {
            ScrollingUtil.ensureIndexIsVisible(this.myList, (int)indices.get(0), (int)0);
        }
    }

    @Deprecated
    public boolean hasPostponedAction() {
        return false;
    }

    protected abstract void showList();

    protected abstract void hideList();

    protected abstract void close(boolean var1);

    @Nullable
    public Object getChosenElement() {
        List<Object> elements2 = this.getChosenElements();
        return elements2.size() == 1 ? elements2.get(0) : null;
    }

    @NotNull
    protected List<Object> getChosenElements() {
        return ContainerUtil.filter(this.myList.getSelectedValuesList(), o -> o != null && !ChooseByNameBase.isSpecialElement(o));
    }

    protected void chosenElementMightChange() {
    }

    @NotNull
    public ChooseByNameItemProvider getProvider() {
        return this.myProvider;
    }

    private void handlePaste(@NotNull String str) {
        if (!this.myInitIsDone) {
            return;
        }
        if (this.myModel instanceof GotoClassModel2 && ChooseByNameBase.isFileName(str)) {
            SwingUtilities.invokeLater(() -> {
                GotoFileAction gotoFile = new GotoFileAction();
                DataContext context = DataManager.getInstance().getDataContext((Component)this.myTextField);
                gotoFile.actionPerformed(AnActionEvent.createFromAnAction((AnAction)gotoFile, null, (String)"unknown", (DataContext)context));
            });
        }
    }

    private static boolean isFileName(@NotNull String name) {
        int index = name.lastIndexOf(46);
        if (index > 0) {
            String ext = name.substring(index + 1);
            if (ext.contains(":")) {
                ext = ext.substring(0, ext.indexOf(58));
            }
            if (FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(ext) != UnknownFileType.INSTANCE) {
                return true;
            }
        }
        return false;
    }

    private boolean isProjectDisposed() {
        return this.myProject != null && this.myProject.isDisposed();
    }

    @NotNull
    private static String patternToLowerCase(@NotNull String pattern) {
        return StringUtil.toLowerCase((String)pattern);
    }

    @Override
    public boolean canShowListForEmptyPattern() {
        return this.isShowListForEmptyPattern() || ChooseByNameBase.isShowListAfterCompletionKeyStroke() && this.lastKeyStrokeIsCompletion();
    }

    private boolean lastKeyStrokeIsCompletion() {
        return this.myTextField.isCompletionKeyStroke();
    }

    @NotNull
    private static Matcher buildPatternMatcher(@NotNull String pattern) {
        return NameUtil.buildMatcher((String)pattern, (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }

    @Override
    public int getMaximumListSizeLimit() {
        return this.myMaximumListSizeLimit;
    }

    public void setMaximumListSizeLimit(int maximumListSizeLimit) {
        this.myMaximumListSizeLimit = maximumListSizeLimit;
    }

    public void setListSizeIncreasing(int listSizeIncreasing) {
        this.myListSizeIncreasing = listSizeIncreasing;
    }

    public void setAlwaysHasMore(boolean enabled) {
        this.myAlwaysHasMore = enabled;
    }

    @NotNull
    public JTextField getTextField() {
        return this.myTextField;
    }

    private class MyCopyReferenceAction
    extends DumbAwareAction {
        private MyCopyReferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(ChooseByNameBase.this.myTextField.getSelectedText() == null && ChooseByNameBase.this.getChosenElement() instanceof PsiElement);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CopyReferenceAction.doCopy((PsiElement)ChooseByNameBase.this.getChosenElement(), ChooseByNameBase.this.myProject);
        }
    }

    private static class MyUsageInfo2UsageAdapter
    extends UsageInfo2UsageAdapter {
        private final PsiElement myElement;
        private final boolean mySeparateGroup;

        MyUsageInfo2UsageAdapter(@NotNull PsiElement element2, final boolean separateGroup) {
            super(new UsageInfo(element2){

                public boolean isDynamicUsage() {
                    return separateGroup || super.isDynamicUsage();
                }
            });
            this.myElement = element2;
            this.mySeparateGroup = separateGroup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MyUsageInfo2UsageAdapter)) {
                return false;
            }
            MyUsageInfo2UsageAdapter adapter2 = (MyUsageInfo2UsageAdapter)((Object)o);
            if (this.mySeparateGroup != adapter2.mySeparateGroup) {
                return false;
            }
            return this.myElement.equals(adapter2.myElement);
        }

        public int hashCode() {
            int result2 = this.myElement.hashCode();
            result2 = 31 * result2 + (this.mySeparateGroup ? 1 : 0);
            return result2;
        }
    }

    private abstract class ShowFindUsagesAction
    extends DumbAwareAction {
        ShowFindUsagesAction() {
            super(ChooseByNameBase.ACTION_NAME, ChooseByNameBase.ACTION_NAME, AllIcons.General.Pin_tab);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ChooseByNameBase.this.cancelListUpdater();
            final UsageViewPresentation presentation2 = new UsageViewPresentation();
            final String text = ChooseByNameBase.this.getTrimmedText();
            String prefixPattern = ChooseByNameBase.this.myFindUsagesTitle + " '" + text + "'";
            presentation2.setCodeUsagesString(prefixPattern);
            presentation2.setUsagesInGeneratedCodeString(prefixPattern + " in generated code");
            presentation2.setTabName(prefixPattern);
            presentation2.setTabText(prefixPattern);
            presentation2.setTargetsNodeText("Unsorted " + StringUtil.toLowerCase((String)ChooseByNameBase.patternToLowerCase(prefixPattern)));
            PsiElement[] elements2 = this.getElements();
            final ArrayList targets2 = new ArrayList();
            final LinkedHashSet usages = new LinkedHashSet();
            this.fillUsages(Arrays.asList(elements2), usages, targets2);
            if (ChooseByNameBase.this.myListModel.contains(ChooseByNameBase.EXTRA_ELEM)) {
                final boolean everywhere = ChooseByNameBase.this.myCheckBox.isSelected();
                ChooseByNameBase.this.hideHint();
                final LinkedHashSet collected = new LinkedHashSet();
                ProgressManager.getInstance().run((Task)new Task.Modal(ChooseByNameBase.this.myProject, prefixPattern, true){
                    private CalcElementsThread myCalcUsagesThread;

                    public void run(final @NotNull ProgressIndicator indicator) {
                        ChooseByNameBase.this.ensureNamesLoaded(everywhere);
                        indicator.setIndeterminate(true);
                        final TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor(indicator);
                        this.myCalcUsagesThread = new CalcElementsThread(text, everywhere, ModalityState.NON_MODAL, PreserveSelection.INSTANCE, __ -> {}){

                            @Override
                            protected boolean isOverflow(@NotNull Set<Object> elementsArray) {
                                tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                                if (elementsArray.size() > 1000 - ChooseByNameBase.this.myMaximumListSizeLimit && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                                    UsageViewManagerImpl.showTooManyUsagesWarningLater((Project)this.getProject(), (TooManyUsagesStatus)tooManyUsagesStatus, (ProgressIndicator)indicator, null);
                                }
                                return false;
                            }
                        };
                        ApplicationManager.getApplication().runReadAction(() -> {
                            this.myCalcUsagesThread.addElementsByPattern(text, collected, indicator, everywhere);
                            indicator.setText(LangBundle.message((String)"progress.text.prepare", (Object[])new Object[0]));
                            ShowFindUsagesAction.this.fillUsages(collected, usages, targets2);
                        });
                    }

                    public void onSuccess() {
                        ShowFindUsagesAction.this.showUsageView(targets2, usages, presentation2);
                    }

                    public void onCancel() {
                        this.myCalcUsagesThread.cancel();
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        super.onThrowable(error);
                        this.myCalcUsagesThread.cancel();
                    }
                });
            } else {
                ChooseByNameBase.this.hideHint();
                this.showUsageView(targets2, usages, presentation2);
            }
        }

        private void fillUsages(@NotNull Collection<Object> matchElementsArray, @NotNull Collection<? super Usage> usages, @NotNull List<? super PsiElement> targets2) {
            for (Object o : matchElementsArray) {
                if (!(o instanceof PsiElement)) continue;
                PsiElement element2 = (PsiElement)o;
                if (element2.getTextRange() != null) {
                    usages.add((Usage)new MyUsageInfo2UsageAdapter(element2, false));
                    continue;
                }
                targets2.add((PsiElement)element2);
            }
        }

        private void showUsageView(@NotNull List<? extends PsiElement> targets2, @NotNull Collection<? extends Usage> usages, @NotNull UsageViewPresentation presentation2) {
            UsageTarget[] usageTargets = targets2.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert(PsiUtilCore.toPsiElementArray(targets2));
            UsageViewManager.getInstance((Project)ChooseByNameBase.this.myProject).showUsages(usageTargets, usages.toArray(Usage.EMPTY_ARRAY), presentation2);
        }

        public void update(@NotNull AnActionEvent e) {
            if (ChooseByNameBase.this.myFindUsagesTitle == null || ChooseByNameBase.this.myProject == null) {
                e.getPresentation().setVisible(false);
                return;
            }
            PsiElement[] elements2 = this.getElements();
            e.getPresentation().setEnabled(elements2.length > 0);
        }

        public abstract PsiElement @NotNull [] getElements();
    }

    private static class HintLabel
    extends JLabel {
        private HintLabel(@NotNull String text) {
            super(text, 4);
            this.setForeground((Color)JBColor.DARK_GRAY);
        }
    }

    private class CalcElementsThread
    extends ReadTask {
        @NotNull
        private final String myPattern;
        private final boolean myCheckboxState;
        @NotNull
        private final Consumer<? super Set<?>> myCallback;
        private final ModalityState myModalityState;
        @NotNull
        private SelectionPolicy mySelectionPolicy;
        private final ProgressIndicator myProgress = new ProgressIndicatorBase();
        private final Alarm myShowCardAlarm = new Alarm();
        private final Alarm myUpdateListAlarm = new Alarm();

        CalcElementsThread(String pattern, @NotNull boolean checkboxState, @NotNull ModalityState modalityState, @NotNull SelectionPolicy policy, Consumer<? super Set<?>> callback2) {
            this.myPattern = pattern;
            this.myCheckboxState = checkboxState;
            this.myCallback = callback2;
            this.myModalityState = modalityState;
            this.mySelectionPolicy = policy;
        }

        void scheduleThread() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ChooseByNameBase.this.myCalcElementsThread = this;
            this.showCard(ChooseByNameBase.SEARCHING_CARD, 200);
            ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myProgress, this);
        }

        @Override
        public ReadTask.Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) {
            if (ChooseByNameBase.this.myProject == null || DumbService.isDumbAware((Object)ChooseByNameBase.this.myModel)) {
                return super.runBackgroundProcess(indicator);
            }
            return (ReadTask.Continuation)DumbService.getInstance((Project)ChooseByNameBase.this.myProject).runReadActionInSmartMode(() -> this.performInReadAction(indicator));
        }

        @Override
        @Nullable
        public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
            if (ChooseByNameBase.this.isProjectDisposed()) {
                return null;
            }
            Set<Object> elements2 = Collections.synchronizedSet(new LinkedHashSet());
            this.scheduleIncrementalListUpdate(elements2, 0);
            boolean scopeExpanded = this.populateElements(elements2);
            String cardToShow = elements2.isEmpty() ? ChooseByNameBase.NOT_FOUND_CARD : (scopeExpanded ? ChooseByNameBase.NOT_FOUND_IN_PROJECT_CARD : ChooseByNameBase.CHECK_BOX_CARD);
            AnchoredSet resultSet = new AnchoredSet(ChooseByNameBase.this.filter(elements2));
            return new ReadTask.Continuation(() -> {
                if (!ChooseByNameBase.this.checkDisposed() && !this.myProgress.isCanceled()) {
                    CalcElementsThread currentBgProcess = ChooseByNameBase.this.myCalcElementsThread;
                    LOG.assertTrue(currentBgProcess == this, (Object)currentBgProcess);
                    this.showCard(cardToShow, 0);
                    Set<Object> filtered2 = resultSet.getElements();
                    ChooseByNameBase.this.backgroundCalculationFinished(filtered2, this.mySelectionPolicy);
                    this.myCallback.consume(filtered2);
                }
            }, this.myModalityState);
        }

        private void scheduleIncrementalListUpdate(@NotNull Set<Object> elements2, int lastCount) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.myUpdateListAlarm.addRequest(() -> {
                if (ChooseByNameBase.this.myCalcElementsThread != this || !this.myProgress.isRunning()) {
                    return;
                }
                int count = elements2.size();
                if (count > lastCount) {
                    ChooseByNameBase.this.setElementsToList(this.mySelectionPolicy, new ArrayList(elements2));
                    if (ChooseByNameBase.this.currentChosenInfo != null) {
                        this.mySelectionPolicy = PreserveSelection.INSTANCE;
                    }
                }
                this.scheduleIncrementalListUpdate(elements2, count);
            }, 200);
        }

        private boolean populateElements(@NotNull Set<Object> elements2) {
            boolean scopeExpanded = false;
            try {
                scopeExpanded = this.fillWithScopeExpansion(elements2, this.myPattern);
                String lowerCased = ChooseByNameBase.patternToLowerCase(this.myPattern);
                if (elements2.isEmpty() && !lowerCased.equals(this.myPattern)) {
                    scopeExpanded = this.fillWithScopeExpansion(elements2, lowerCased);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return scopeExpanded;
        }

        private boolean fillWithScopeExpansion(@NotNull Set<Object> elements2, @NotNull String pattern) {
            this.addElementsByPattern(pattern, elements2, this.myProgress, this.myCheckboxState);
            if (elements2.isEmpty() && !this.myCheckboxState) {
                this.addElementsByPattern(pattern, elements2, this.myProgress, true);
                return true;
            }
            return false;
        }

        @Override
        public void onCanceled(@NotNull ProgressIndicator indicator) {
            LOG.assertTrue(ChooseByNameBase.this.myCalcElementsThread == this, (Object)ChooseByNameBase.this.myCalcElementsThread);
            if (!ChooseByNameBase.this.isProjectDisposed() && !ChooseByNameBase.this.checkDisposed()) {
                new CalcElementsThread(this.myPattern, this.myCheckboxState, this.myModalityState, this.mySelectionPolicy, this.myCallback).scheduleThread();
            }
        }

        private void addElementsByPattern(@NotNull String pattern, @NotNull Set<Object> elements2, @NotNull ProgressIndicator indicator, boolean everywhere) {
            long start2 = System.currentTimeMillis();
            ChooseByNameBase.this.myProvider.filterElements(ChooseByNameBase.this, pattern, everywhere, indicator, (Processor<Object>)((Processor)o -> {
                if (indicator.isCanceled()) {
                    return false;
                }
                if (o == null) {
                    LOG.error("Null returned from " + ChooseByNameBase.this.myProvider + " with " + ChooseByNameBase.this.myModel + " in " + ChooseByNameBase.this);
                    return true;
                }
                elements2.add(o);
                if (this.isOverflow(elements2)) {
                    elements2.add(ChooseByNameBase.EXTRA_ELEM);
                    return false;
                }
                return true;
            }));
            if (ChooseByNameBase.this.myAlwaysHasMore) {
                elements2.add(ChooseByNameBase.EXTRA_ELEM);
            }
            if (ContributorsBasedGotoByModel.LOG.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                ContributorsBasedGotoByModel.LOG.debug("addElementsByPattern(" + pattern + "): " + (end - start2) + "ms; " + elements2.size() + " elements");
            }
        }

        private void showCard(@NotNull String card, int delay) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            this.myShowCardAlarm.cancelAllRequests();
            this.myShowCardAlarm.addRequest(() -> {
                if (!this.myProgress.isCanceled()) {
                    ChooseByNameBase.this.myCard.show(ChooseByNameBase.this.myCardContainer, card);
                }
            }, delay, this.myModalityState);
        }

        protected boolean isOverflow(@NotNull Set<Object> elementsArray) {
            return elementsArray.size() >= ChooseByNameBase.this.myMaximumListSizeLimit;
        }

        private void cancel() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myProgress.cancel();
        }
    }

    protected final class MyTextField
    extends JTextField
    implements PopupOwner,
    TypeSafeDataProvider {
        private final KeyStroke myCompletionKeyStroke;
        private final KeyStroke forwardStroke;
        private final KeyStroke backStroke;
        private boolean completionKeyStrokeHappened;

        private MyTextField() {
            super(40);
            if (!UIUtil.isUnderDefaultMacTheme() && !UIUtil.isUnderWin10LookAndFeel()) {
                if (!(this.getUI() instanceof DarculaTextFieldUI)) {
                    this.setUI(DarculaTextFieldUI.createUI(this));
                }
                this.setBorder(new DarculaTextBorder());
            }
            this.enableEvents(8L);
            this.myCompletionKeyStroke = this.getShortcut("CodeCompletion");
            this.forwardStroke = this.getShortcut("Forward");
            this.backStroke = this.getShortcut("Back");
            this.setFocusTraversalKeysEnabled(false);
            this.putClientProperty("JTextField.variant", "search");
            this.setDocument(new PlainDocument(){

                @Override
                public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                    super.insertString(offs, str, a);
                    if (str != null && str.length() > 1) {
                        ChooseByNameBase.this.handlePaste(str);
                    }
                }
            });
        }

        @Nullable
        private KeyStroke getShortcut(@NotNull String actionCodeCompletion) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionCodeCompletion).getShortcuts()) {
                if (!(shortcut instanceof KeyboardShortcut)) continue;
                return ((KeyboardShortcut)shortcut).getFirstKeyStroke();
            }
            return null;
        }

        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            if (LangDataKeys.POSITION_ADJUSTER_POPUP.equals(key)) {
                if (ChooseByNameBase.this.myDropdownPopup != null && ChooseByNameBase.this.myDropdownPopup.isVisible()) {
                    sink.put(key, (Object)ChooseByNameBase.this.myDropdownPopup);
                }
            } else if (LangDataKeys.PARENT_POPUP.equals(key) && ChooseByNameBase.this.myTextPopup != null && ChooseByNameBase.this.myTextPopup.isVisible()) {
                sink.put(key, (Object)ChooseByNameBase.this.myTextPopup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processKeyEvent(@NotNull KeyEvent e) {
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
            if (keyStroke.equals(this.myCompletionKeyStroke)) {
                this.completionKeyStrokeHappened = true;
                e.consume();
                String pattern = ChooseByNameBase.this.getTrimmedText();
                int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                ChooseByNameBase.this.myHistory.add(Pair.create((Object)pattern, (Object)oldPos));
                Runnable postRunnable = () -> this.fillInCommonPrefix(pattern);
                ChooseByNameBase.this.rebuildList(SelectMostRelevant.INSTANCE, 0, ModalityState.current(), postRunnable);
                return;
            }
            if (keyStroke.equals(this.backStroke)) {
                e.consume();
                if (!ChooseByNameBase.this.myHistory.isEmpty()) {
                    String oldText = ChooseByNameBase.this.getTrimmedText();
                    int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                    Pair last = (Pair)ChooseByNameBase.this.myHistory.remove(ChooseByNameBase.this.myHistory.size() - 1);
                    ChooseByNameBase.this.myTextField.setText((String)last.first);
                    ChooseByNameBase.this.myFuture.add(Pair.create((Object)oldText, (Object)oldPos));
                    ChooseByNameBase.this.rebuildList(SelectMostRelevant.INSTANCE, 0, ModalityState.current(), null);
                }
                return;
            }
            if (keyStroke.equals(this.forwardStroke)) {
                e.consume();
                if (!ChooseByNameBase.this.myFuture.isEmpty()) {
                    String oldText = ChooseByNameBase.this.getTrimmedText();
                    int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
                    Pair next = (Pair)ChooseByNameBase.this.myFuture.remove(ChooseByNameBase.this.myFuture.size() - 1);
                    ChooseByNameBase.this.myTextField.setText((String)next.first);
                    ChooseByNameBase.this.myHistory.add(Pair.create((Object)oldText, (Object)oldPos));
                    ChooseByNameBase.this.rebuildList(SelectMostRelevant.INSTANCE, 0, ModalityState.current(), null);
                }
                return;
            }
            int position = ChooseByNameBase.this.myTextField.getCaretPosition();
            int code = keyStroke.getKeyCode();
            int modifiers = keyStroke.getModifiers();
            try {
                super.processKeyEvent(e);
            }
            catch (NullPointerException e1) {
                if (!Patches.SUN_BUG_ID_6322854) {
                    throw e1;
                }
            }
            finally {
                if ((code == 38 || code == 40) && modifiers == 0) {
                    ChooseByNameBase.this.myTextField.setCaretPosition(position);
                }
            }
        }

        private void fillInCommonPrefix(@NotNull String pattern) {
            List<String> list2 = ChooseByNameBase.this.myProvider.filterNames(ChooseByNameBase.this, ChooseByNameBase.this.getNames(ChooseByNameBase.this.myCheckBox.isSelected()), pattern);
            if (list2.isEmpty()) {
                return;
            }
            if (this.isComplexPattern(pattern)) {
                return;
            }
            String oldText = ChooseByNameBase.this.getTrimmedText();
            int oldPos = ChooseByNameBase.this.myList.getSelectedIndex();
            String commonPrefix = null;
            if (!list2.isEmpty()) {
                for (String name : list2) {
                    String string = StringUtil.toLowerCase((String)name);
                    if (commonPrefix == null) {
                        commonPrefix = string;
                        continue;
                    }
                    while (!commonPrefix.isEmpty() && !string.startsWith(commonPrefix)) {
                        commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
                    }
                    if (!commonPrefix.isEmpty()) continue;
                    break;
                }
                commonPrefix = list2.get(0).substring(0, commonPrefix.length());
                for (int i2 = 1; i2 < list2.size(); ++i2) {
                    String string = list2.get(i2).substring(0, commonPrefix.length());
                    if (string.equals(commonPrefix)) continue;
                    commonPrefix = StringUtil.toLowerCase((String)commonPrefix);
                    break;
                }
            }
            if (commonPrefix == null) {
                commonPrefix = "";
            }
            if (!StringUtil.startsWithIgnoreCase((String)commonPrefix, (String)pattern)) {
                commonPrefix = pattern;
            }
            String newPattern = commonPrefix;
            ChooseByNameBase.this.myHistory.add(Pair.create((Object)oldText, (Object)oldPos));
            ChooseByNameBase.this.myTextField.setText(newPattern);
            ChooseByNameBase.this.myTextField.setCaretPosition(newPattern.length());
            ChooseByNameBase.this.rebuildList(false);
        }

        private boolean isComplexPattern(@NotNull String pattern) {
            if (pattern.indexOf(42) >= 0) {
                return true;
            }
            for (String s : ChooseByNameBase.this.myModel.getSeparators()) {
                if (!pattern.contains(s)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public Point getBestPopupPosition() {
            return new Point(ChooseByNameBase.this.myTextFieldPanel.getWidth(), this.getHeight());
        }

        @Override
        protected void paintComponent(@NotNull Graphics g) {
            GraphicsUtil.setupAntialiasing((Graphics)g);
            super.paintComponent(g);
        }

        boolean isCompletionKeyStroke() {
            return this.completionKeyStrokeHappened;
        }
    }

    public class JPanelProvider
    extends JPanel
    implements DataProvider,
    QuickSearchComponent {
        private JBPopup myHint;
        private boolean myFocusRequested;

        JPanelProvider() {
        }

        public Object getData(@NotNull String dataId) {
            if (PlatformDataKeys.SEARCH_INPUT_TEXT.is(dataId)) {
                return ChooseByNameBase.this.myTextField.getText();
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ChooseByNameBase.this.myModel.getHelpId();
            }
            if (ChooseByNameBase.this.myCalcElementsThread != null) {
                return null;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                Object element2 = ChooseByNameBase.this.getChosenElement();
                if (element2 instanceof PsiElement) {
                    return element2;
                }
                if (element2 instanceof DataProvider) {
                    return ((DataProvider)element2).getData(dataId);
                }
            } else {
                if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                    List<Object> chosenElements = ChooseByNameBase.this.getChosenElements();
                    ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(chosenElements.size());
                    for (Object element3 : chosenElements) {
                        if (!(element3 instanceof PsiElement)) continue;
                        result2.add((PsiElement)element3);
                    }
                    return PsiUtilCore.toPsiElementArray(result2);
                }
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId)) {
                    return this.getBounds();
                }
            }
            return null;
        }

        public void registerHint(@NotNull JBPopup h) {
            if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
                this.myHint.cancel();
            }
            this.myHint = h;
        }

        boolean focusRequested() {
            boolean focusRequested = this.myFocusRequested;
            this.myFocusRequested = false;
            return focusRequested;
        }

        @Override
        public void requestFocus() {
            this.myFocusRequested = true;
        }

        public void unregisterHint() {
            this.myHint = null;
        }

        public void hideHint() {
            if (this.myHint != null) {
                this.myHint.cancel();
            }
        }

        @Nullable
        public JBPopup getHint() {
            return this.myHint;
        }

        void updateHint(PsiElement element2) {
            if (this.myHint == null || !this.myHint.isVisible()) {
                return;
            }
            PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
            if (updateProcessor != null) {
                updateProcessor.updatePopup(element2);
            }
        }

        void repositionHint() {
            if (this.myHint == null || !this.myHint.isVisible()) {
                return;
            }
            PopupPositionManager.positionPopupInBestPosition(this.myHint, null, null);
        }
    }
}

