/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.ComponentHighlightingListener;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.ui.search.TraverseUIHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.CollectConsumer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchUtil {
    private static final String DEBUGGER_CONFIGURABLE_CLASS = "com.intellij.xdebugger.impl.settings.DebuggerConfigurable";
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");
    private static final Pattern QUOTED = Pattern.compile("\"([^\"]+)\"");
    private static final Pattern NON_WORD_PATTERN = Pattern.compile("[\\W&&[^\\p{Punct}\\p{Blank}]]");
    public static final String HIGHLIGHT_WITH_BORDER = "searchUtil.highlightWithBorder";
    private static final String STYLE_END = "</style>";

    private SearchUtil() {
    }

    public static void processProjectConfigurables(Project project, Map<SearchableConfigurable, Set<OptionDescription>> options2) {
        SearchUtil.processConfigurables(ShowSettingsUtilImpl.getConfigurables(project, true), options2);
    }

    private static void processConfigurables(@NotNull List<? extends Configurable> configurables, Map<SearchableConfigurable, Set<OptionDescription>> options2) {
        for (Configurable configurable2 : configurables) {
            if (!(configurable2 instanceof SearchableConfigurable) || configurable2 instanceof SearchableConfigurable.Parent && !((SearchableConfigurable.Parent)configurable2).isVisible()) continue;
            SearchableConfigurable searchableConfigurable = (SearchableConfigurable)configurable2;
            TreeSet<OptionDescription> configurableOptions = new TreeSet<OptionDescription>();
            options2.put(searchableConfigurable, configurableOptions);
            for (TraverseUIHelper extension : (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions()) {
                extension.beforeConfigurable(searchableConfigurable, configurableOptions);
            }
            if (configurable2 instanceof MasterDetails) {
                MasterDetails md = (MasterDetails)configurable2;
                md.initUi();
                SearchUtil.processComponent(searchableConfigurable, configurableOptions, md.getMaster());
                SearchUtil.processComponent(searchableConfigurable, configurableOptions, md.getDetails().getComponent());
            } else {
                SearchUtil.processComponent(searchableConfigurable, configurableOptions, configurable2.createComponent());
                Configurable unwrapped = SearchUtil.unwrapConfigurable(configurable2);
                if (unwrapped instanceof CompositeConfigurable) {
                    unwrapped.disposeUIResources();
                    List children2 = ((CompositeConfigurable)unwrapped).getConfigurables();
                    for (UnnamedConfigurable child2 : children2) {
                        JComponent component2;
                        TreeSet childConfigurableOptions = new TreeSet();
                        options2.put(new SearchableConfigurableAdapter(searchableConfigurable, child2), childConfigurableOptions);
                        if (child2 instanceof SearchableConfigurable) {
                            SearchUtil.processUILabel(((SearchableConfigurable)child2).getDisplayName(), childConfigurableOptions, null);
                        }
                        if ((component2 = child2.createComponent()) != null) {
                            SearchUtil.processComponent(component2, childConfigurableOptions, null);
                        }
                        configurableOptions.removeAll(childConfigurableOptions);
                    }
                }
            }
            for (TraverseUIHelper extension : (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions()) {
                extension.afterConfigurable(searchableConfigurable, configurableOptions);
            }
        }
    }

    @NotNull
    private static Configurable unwrapConfigurable(@NotNull Configurable configurable2) {
        Class clazz;
        Configurable rootConfigurable;
        UnnamedConfigurable wrapped;
        if (configurable2 instanceof ConfigurableWrapper && (wrapped = ((ConfigurableWrapper)configurable2).getConfigurable()) instanceof SearchableConfigurable) {
            configurable2 = (Configurable)wrapped;
        }
        if (DEBUGGER_CONFIGURABLE_CLASS.equals(configurable2.getClass().getName()) && (rootConfigurable = (Configurable)ReflectionUtil.getField((Class)(clazz = ReflectionUtil.forName((String)DEBUGGER_CONFIGURABLE_CLASS)), (Object)configurable2, Configurable.class, (String)"myRootConfigurable")) != null) {
            return rootConfigurable;
        }
        return configurable2;
    }

    private static void processComponent(SearchableConfigurable configurable2, Set<? super OptionDescription> configurableOptions, JComponent component2) {
        if (component2 != null) {
            for (TraverseUIHelper extension : (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions()) {
                extension.beforeComponent(configurable2, component2, configurableOptions);
            }
            SearchUtil.processUILabel(configurable2.getDisplayName(), configurableOptions, null);
            SearchUtil.processComponent(component2, configurableOptions, null);
            for (TraverseUIHelper extension : (TraverseUIHelper[])TraverseUIHelper.helperExtensionPoint.getExtensions()) {
                extension.afterComponent(configurable2, component2, configurableOptions);
            }
        }
    }

    private static void processComponent(JComponent component2, Set<? super OptionDescription> configurableOptions, String path) {
        block7: {
            block10: {
                Object tabbedPane;
                block9: {
                    block8: {
                        block6: {
                            String label2;
                            TitledBorder titledBorder;
                            String title;
                            if (component2 instanceof SkipSelfSearchComponent) {
                                return;
                            }
                            Border border = component2.getBorder();
                            if (border instanceof TitledBorder && (title = (titledBorder = (TitledBorder)border).getTitle()) != null) {
                                SearchUtil.processUILabel(title, configurableOptions, path);
                            }
                            if ((label2 = SearchUtil.getLabelFromComponent(component2)) == null) break block6;
                            SearchUtil.processUILabel(label2, configurableOptions, path);
                            break block7;
                        }
                        if (!(component2 instanceof JComboBox)) break block8;
                        List<String> labels = SearchUtil.getItemsFromComboBox((JComboBox)component2);
                        for (String each : labels) {
                            SearchUtil.processUILabel(each, configurableOptions, path);
                        }
                        break block7;
                    }
                    if (!(component2 instanceof JTabbedPane)) break block9;
                    tabbedPane = (JTabbedPane)component2;
                    int tabCount = ((JTabbedPane)tabbedPane).getTabCount();
                    for (int i2 = 0; i2 < tabCount; ++i2) {
                        String title = path != null ? path + '.' + ((JTabbedPane)tabbedPane).getTitleAt(i2) : ((JTabbedPane)tabbedPane).getTitleAt(i2);
                        SearchUtil.processUILabel(title, configurableOptions, title);
                        Component tabComponent = ((JTabbedPane)tabbedPane).getComponentAt(i2);
                        if (!(tabComponent instanceof JComponent)) continue;
                        SearchUtil.processComponent((JComponent)tabComponent, configurableOptions, title);
                    }
                    break block7;
                }
                if (!(component2 instanceof TabbedPaneWrapper.TabbedPaneHolder)) break block10;
                tabbedPane = ((TabbedPaneWrapper.TabbedPaneHolder)component2).getTabbedPaneWrapper();
                int tabCount = ((TabbedPaneWrapper)tabbedPane).getTabCount();
                for (int i3 = 0; i3 < tabCount; ++i3) {
                    String tabTitle = ((TabbedPaneWrapper)tabbedPane).getTitleAt(i3);
                    String title = path != null ? path + '.' + tabTitle : tabTitle;
                    SearchUtil.processUILabel(title, configurableOptions, title);
                    JComponent tabComponent = ((TabbedPaneWrapper)tabbedPane).getComponentAt(i3);
                    if (tabComponent == null) continue;
                    SearchUtil.processComponent(tabComponent, configurableOptions, title);
                }
                break block7;
            }
            Component[] components = component2.getComponents();
            if (components == null) break block7;
            for (Component child2 : components) {
                if (!(child2 instanceof JComponent)) continue;
                SearchUtil.processComponent((JComponent)child2, configurableOptions, path);
            }
        }
    }

    @Nullable
    private static String getLabelFromComponent(@Nullable Component component2) {
        String label2 = null;
        if (component2 instanceof JLabel) {
            label2 = ((JLabel)component2).getText();
        } else if (component2 instanceof JCheckBox) {
            label2 = ((JCheckBox)component2).getText();
        } else if (component2 instanceof JRadioButton) {
            label2 = ((JRadioButton)component2).getText();
        } else if (component2 instanceof JButton) {
            label2 = ((JButton)component2).getText();
        }
        return StringUtil.nullize((String)label2, (boolean)true);
    }

    @NotNull
    private static List<String> getItemsFromComboBox(@NotNull JComboBox<?> comboBox2) {
        DefaultListCellRenderer renderer = comboBox2.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        JList<Object> jList = new BasicComboPopup(comboBox2).getList();
        ArrayList<String> result2 = new ArrayList<String>();
        int count = comboBox2.getItemCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object value2 = comboBox2.getItemAt(i2);
            Component labelComponent = renderer.getListCellRendererComponent(jList, value2, i2, false, false);
            String label2 = SearchUtil.getLabelFromComponent(labelComponent);
            if (label2 == null) continue;
            result2.add(label2);
        }
        return result2;
    }

    private static void processUILabel(String title, Set<? super OptionDescription> configurableOptions, String path) {
        title = HTML_PATTERN.matcher(title).replaceAll(" ");
        Set words = SearchableOptionsRegistrar.getInstance().getProcessedWordsWithoutStemming(title);
        title = NON_WORD_PATTERN.matcher(title).replaceAll(" ");
        for (String option2 : words) {
            configurableOptions.add((OptionDescription)new OptionDescription(option2, title, path));
        }
    }

    public static void lightOptions(SearchableConfigurable configurable2, JComponent component2, String option2) {
        if (!SearchUtil.traverseComponentsTree(configurable2, component2, option2, true)) {
            SearchUtil.traverseComponentsTree(configurable2, component2, option2, false);
        }
    }

    private static int getSelection(String tabIdx, int tabCount, Function<Integer, String> titleGetter) {
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        for (int i2 = 0; i2 < tabCount; ++i2) {
            Set pathWords = searchableOptionsRegistrar.getProcessedWords(tabIdx);
            String title = titleGetter.apply(i2);
            if (!pathWords.isEmpty()) {
                Set titleWords = searchableOptionsRegistrar.getProcessedWords(title);
                pathWords.removeAll(titleWords);
                if (!pathWords.isEmpty()) continue;
                return i2;
            }
            if (!tabIdx.equalsIgnoreCase(title)) continue;
            return i2;
        }
        return -1;
    }

    private static boolean traverseComponentsTree(SearchableConfigurable configurable2, JComponent rootComponent, String option2, boolean force) {
        String title;
        Border border;
        int index;
        Set paths;
        rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, null);
        if (option2 == null || option2.trim().length() == 0) {
            return false;
        }
        String label2 = SearchUtil.getLabelFromComponent(rootComponent);
        if (label2 != null) {
            if (SearchUtil.isComponentHighlighted(label2, option2, force, configurable2)) {
                SearchUtil.highlightComponent(rootComponent, option2);
                return true;
            }
        } else if (rootComponent instanceof JComboBox) {
            List<String> labels = SearchUtil.getItemsFromComboBox((JComboBox)rootComponent);
            if (ContainerUtil.exists(labels, it -> SearchUtil.isComponentHighlighted(it, option2, force, configurable2))) {
                SearchUtil.highlightComponent(rootComponent, option2);
                return true;
            }
        } else if (rootComponent instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)rootComponent;
            paths = SearchableOptionsRegistrar.getInstance().getInnerPaths(configurable2, option2);
            for (String path : paths) {
                if (path == null || (index = SearchUtil.getSelection(path, tabbedPane.getTabCount(), i2 -> tabbedPane.getTitleAt((int)i2))) <= -1 || index >= tabbedPane.getTabCount() || !(tabbedPane.getTabComponentAt(index) instanceof JComponent)) continue;
                SearchUtil.highlightComponent((JComponent)tabbedPane.getTabComponentAt(index), option2);
            }
        } else if (rootComponent instanceof TabbedPaneWrapper.TabbedPaneHolder) {
            TabbedPaneWrapper tabbedPaneWrapper = ((TabbedPaneWrapper.TabbedPaneHolder)rootComponent).getTabbedPaneWrapper();
            paths = SearchableOptionsRegistrar.getInstance().getInnerPaths(configurable2, option2);
            for (String path : paths) {
                if (path == null || (index = SearchUtil.getSelection(path, tabbedPaneWrapper.getTabCount(), i2 -> tabbedPaneWrapper.getTitleAt((int)i2))) <= -1 || index >= tabbedPaneWrapper.getTabCount()) continue;
                SearchUtil.highlightComponent((JComponent)tabbedPaneWrapper.getTabComponentAt(index), option2);
            }
        }
        if ((border = rootComponent.getBorder()) instanceof TitledBorder && SearchUtil.isComponentHighlighted(title = ((TitledBorder)border).getTitle(), option2, force, configurable2)) {
            SearchUtil.highlightComponent(rootComponent, option2);
            rootComponent.putClientProperty(HIGHLIGHT_WITH_BORDER, Boolean.TRUE);
            return true;
        }
        boolean highlight = false;
        for (Component component2 : rootComponent.getComponents()) {
            if (!(component2 instanceof JComponent) || !SearchUtil.traverseComponentsTree(configurable2, (JComponent)component2, option2, force)) continue;
            highlight = true;
        }
        return highlight;
    }

    private static void highlightComponent(@NotNull JComponent rootComponent, @NotNull String searchString) {
        ((ComponentHighlightingListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ComponentHighlightingListener.TOPIC)).highlight(rootComponent, searchString);
    }

    public static boolean isComponentHighlighted(String text, String option2, boolean force, SearchableConfigurable configurable2) {
        Set options2;
        if (text == null || option2 == null || option2.length() == 0) {
            return false;
        }
        SearchableOptionsRegistrar searchableOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
        Set words = searchableOptionsRegistrar.getProcessedWords(option2);
        Set set = options2 = configurable2 != null ? searchableOptionsRegistrar.replaceSynonyms(words, configurable2) : words;
        if (options2.isEmpty()) {
            return StringUtil.toLowerCase((String)text).contains(StringUtil.toLowerCase((String)option2));
        }
        Set tokens = searchableOptionsRegistrar.getProcessedWords(text);
        if (!force) {
            options2.retainAll(tokens);
            boolean highlight = !options2.isEmpty();
            return highlight || StringUtil.toLowerCase((String)text).contains(StringUtil.toLowerCase((String)option2));
        }
        options2.removeAll(tokens);
        return options2.isEmpty();
    }

    public static String markup(@NotNull String textToMarkup, @Nullable String filter2) {
        String foot;
        String head;
        if (filter2 == null || filter2.length() == 0) {
            return textToMarkup;
        }
        int bodyStart = textToMarkup.indexOf("<body>");
        int bodyEnd = textToMarkup.indexOf("</body>");
        if (bodyStart >= 0) {
            head = textToMarkup.substring(0, bodyStart += "<body>".length());
            foot = bodyEnd >= 0 ? textToMarkup.substring(bodyEnd) : "";
            textToMarkup = textToMarkup.substring(bodyStart, bodyEnd);
        } else {
            foot = "";
            head = "";
        }
        Pattern insideHtmlTagPattern = Pattern.compile("[<[^<>]*>]*<[^<>]*");
        SearchableOptionsRegistrar registrar = SearchableOptionsRegistrar.getInstance();
        HashSet quoted = new HashSet();
        filter2 = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(textToMarkup, filter2), quoted);
        Set options2 = registrar.getProcessedWords(filter2);
        Set words = registrar.getProcessedWords(textToMarkup);
        for (String option2 : options2) {
            if (!words.contains(option2)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, option2);
        }
        for (String stripped : quoted) {
            if (registrar.isStopWord(stripped)) continue;
            textToMarkup = SearchUtil.markup(textToMarkup, insideHtmlTagPattern, stripped);
        }
        return head + textToMarkup + foot;
    }

    private static String quoteStrictOccurrences(String textToMarkup, String filter2) {
        StringBuilder cur = new StringBuilder();
        String s = StringUtil.toLowerCase((String)textToMarkup);
        for (String part : filter2.split(" ")) {
            if (s.contains(part)) {
                cur.append("\"").append(part).append("\" ");
                continue;
            }
            cur.append(part).append(" ");
        }
        return cur.toString();
    }

    private static String markup(String textToMarkup, Pattern insideHtmlTagPattern, String option2) {
        int styleIdx = textToMarkup.indexOf("<style");
        int styleEndIdx = textToMarkup.indexOf(STYLE_END);
        if (styleIdx < 0 || styleEndIdx < 0) {
            return SearchUtil.markupInText(textToMarkup, insideHtmlTagPattern, option2);
        }
        return SearchUtil.markup(textToMarkup.substring(0, styleIdx), insideHtmlTagPattern, option2) + SearchUtil.markup(textToMarkup.substring(styleEndIdx + STYLE_END.length()), insideHtmlTagPattern, option2);
    }

    private static String markupInText(String textToMarkup, Pattern insideHtmlTagPattern, String option2) {
        int idx;
        StringBuilder result2 = new StringBuilder();
        int beg = 0;
        while ((idx = StringUtil.indexOfIgnoreCase((String)textToMarkup, (String)option2, (int)beg)) != -1) {
            String prefix = textToMarkup.substring(beg, idx);
            String toMark = textToMarkup.substring(idx, idx + option2.length());
            if (insideHtmlTagPattern.matcher(prefix).matches()) {
                int lastIdx = textToMarkup.indexOf(">", idx);
                result2.append(prefix).append(textToMarkup, idx, lastIdx + 1);
                beg = lastIdx + 1;
                continue;
            }
            result2.append(prefix).append("<font color='#ffffff' bgColor='#1d5da7'>").append(toMark).append("</font>");
            beg = idx + option2.length();
        }
        result2.append(textToMarkup.substring(beg));
        return result2.toString();
    }

    public static void appendFragments(String filter2, String text, @SimpleTextAttributes.StyleAttributeConstant int style, Color foreground, Color background, SimpleColoredComponent textRenderer) {
        if (text == null) {
            return;
        }
        if (filter2 == null || filter2.length() == 0) {
            textRenderer.setDynamicSearchMatchHighlighting(false);
            textRenderer.append(text, new SimpleTextAttributes(background, foreground, (Color)JBColor.RED, style));
        } else {
            textRenderer.setDynamicSearchMatchHighlighting(true);
            ObjectOpenHashSet quoted = new ObjectOpenHashSet();
            filter2 = SearchUtil.processFilter(SearchUtil.quoteStrictOccurrences(text, filter2), (Set<? super String>)quoted);
            Int2ObjectRBTreeMap indexToString = new Int2ObjectRBTreeMap();
            for (String stripped : quoted) {
                int idx;
                int beg = 0;
                while ((idx = StringUtil.indexOfIgnoreCase((String)text, (String)stripped, (int)beg)) != -1) {
                    indexToString.put(idx, (Object)text.substring(idx, idx + stripped.length()));
                    beg = idx + stripped.length();
                }
            }
            ArrayList<String> selectedWords = new ArrayList<String>();
            int pos = 0;
            for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable((Int2ObjectMap)indexToString)) {
                String stripped = (String)entry.getValue();
                int start2 = entry.getIntKey();
                if (pos > start2) {
                    String highlighted = (String)selectedWords.get(selectedWords.size() - 1);
                    if (highlighted.length() >= stripped.length()) continue;
                    selectedWords.remove(highlighted);
                }
                SearchUtil.appendSelectedWords(text, selectedWords, pos, start2, filter2);
                selectedWords.add(stripped);
                pos = start2 + stripped.length();
            }
            SearchUtil.appendSelectedWords(text, selectedWords, pos, text.length(), filter2);
            int idx = 0;
            for (String word : selectedWords) {
                String before = (text = text.substring(idx)).substring(0, text.indexOf(word));
                if (before.length() > 0) {
                    textRenderer.append(before, new SimpleTextAttributes(background, foreground, null, style));
                }
                idx = text.indexOf(word) + word.length();
                textRenderer.append(text.substring(idx - word.length(), idx), new SimpleTextAttributes(background, foreground, null, style | 0x40));
            }
            String after2 = text.substring(idx);
            if (after2.length() > 0) {
                textRenderer.append(after2, new SimpleTextAttributes(background, foreground, null, style));
            }
        }
    }

    private static void appendSelectedWords(String text, List<? super String> selectedWords, int pos, int end, String filter2) {
        if (pos < end) {
            String[] words;
            Set filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter2);
            for (String word : words = text.substring(pos, end).split("[\\W&&[^-]]+")) {
                if (!filters.contains(PorterStemmerUtil.stem(StringUtil.toLowerCase((String)word)))) continue;
                selectedWords.add(word);
            }
        }
    }

    @NotNull
    public static List<Set<String>> findKeys(String filter2, Set<? super String> quoted) {
        filter2 = SearchUtil.processFilter(StringUtil.toLowerCase((String)filter2), quoted);
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        SearchableOptionsRegistrarImpl optionsRegistrar = (SearchableOptionsRegistrarImpl)SearchableOptionsRegistrar.getInstance();
        for (String word : optionsRegistrar.getProcessedWords(filter2)) {
            Set<OptionDescription> descriptions = optionsRegistrar.getAcceptableDescriptions(word);
            HashSet<String> keySet = new HashSet<String>();
            if (descriptions != null) {
                for (OptionDescription description : descriptions) {
                    keySet.add(description.getPath());
                }
            }
            keySetList.add(keySet);
        }
        if (keySetList.isEmpty() && !StringUtil.isEmptyOrSpaces((String)filter2)) {
            keySetList.add(Collections.singleton(filter2));
        }
        return keySetList;
    }

    private static String processFilter(String filter2, Set<? super String> quoted) {
        StringBuilder withoutQuoted = new StringBuilder();
        int beg = 0;
        Matcher matcher = QUOTED.matcher(filter2);
        while (matcher.find()) {
            int start2 = matcher.start(1);
            withoutQuoted.append(" ").append(filter2, beg, start2);
            beg = matcher.end(1);
            String trimmed = filter2.substring(start2, beg).trim();
            if (trimmed.length() <= 0) continue;
            quoted.add(trimmed);
        }
        return withoutQuoted + " " + filter2.substring(beg);
    }

    @NotNull
    public static List<Configurable> expand(ConfigurableGroup @NotNull [] groups) {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        CollectConsumer consumer = new CollectConsumer(result2);
        for (ConfigurableGroup group : groups) {
            SearchUtil.processExpandedGroups(group, (Consumer<? super Configurable>)consumer);
        }
        return result2;
    }

    @NotNull
    public static List<Configurable> expandGroup(@NotNull ConfigurableGroup group) {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        SearchUtil.processExpandedGroups(group, (Consumer<? super Configurable>)new CollectConsumer(result2));
        return result2;
    }

    public static void processExpandedGroups(@NotNull ConfigurableGroup group, @NotNull Consumer<? super Configurable> consumer) {
        Object[] configurables = group.getConfigurables();
        ArrayList result2 = new ArrayList();
        ContainerUtil.addAll(result2, (Object[])configurables);
        for (Object each : configurables) {
            SearchUtil.addChildren((Configurable)each, result2);
        }
        for (Configurable configurable2 : result2) {
            if (!SearchUtil.isAcceptable(configurable2)) continue;
            consumer.accept((Configurable)configurable2);
        }
    }

    public static boolean isAcceptable(@NotNull Configurable configurable2) {
        return !(configurable2 instanceof SearchableConfigurable.Parent) || ((SearchableConfigurable.Parent)configurable2).isVisible();
    }

    private static void addChildren(@NotNull Configurable configurable2, @NotNull List<? super Configurable> list2) {
        if (configurable2 instanceof Configurable.Composite) {
            for (Configurable eachKid : ((Configurable.Composite)configurable2).getConfigurables()) {
                list2.add((Configurable)eachKid);
                SearchUtil.addChildren(eachKid, list2);
            }
        }
    }

    private static final class SearchableConfigurableAdapter
    implements SearchableConfigurable {
        private final SearchableConfigurable myOriginal;
        private final UnnamedConfigurable myDelegate;

        private SearchableConfigurableAdapter(@NotNull SearchableConfigurable original, @NotNull UnnamedConfigurable delegate) {
            this.myOriginal = original;
            this.myDelegate = delegate;
        }

        @NotNull
        public String getId() {
            return this.myOriginal.getId();
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return this.myOriginal.getDisplayName();
        }

        @NotNull
        public Class<?> getOriginalClass() {
            return this.myDelegate instanceof SearchableConfigurable ? ((SearchableConfigurable)this.myDelegate).getOriginalClass() : this.myDelegate.getClass();
        }

        @Nullable
        public JComponent createComponent() {
            return null;
        }

        public boolean isModified() {
            return false;
        }

        public void apply() {
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

