/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.search;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;

final class IndexedCharsInterner {
    private int[] idToIndex = new int[10];
    private final OpenTHashSet<CharSequence> mySet = new OpenTHashSet<CharSequence>(10, 0.9f, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE){

        protected void rehash(int newCapacity) {
            Object[] oldSet = this._set;
            int oldSize = IndexedCharsInterner.this.mySet.size();
            super.rehash(newCapacity);
            for (int i2 = 0; i2 < oldSize - 1; ++i2) {
                int oldIndex = IndexedCharsInterner.this.idToIndex[i2];
                CharSequence oldString = (CharSequence)oldSet[oldIndex];
                int newIndex = this.index(oldString);
                assert (newIndex != -1);
                ((IndexedCharsInterner)IndexedCharsInterner.this).idToIndex[i2] = newIndex;
            }
        }
    };

    IndexedCharsInterner() {
    }

    public int toId(@NotNull String name) {
        int id2;
        CharSequence seq = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)name);
        int index = this.mySet.index((Object)seq);
        if (index == -1) {
            id2 = this.mySet.size();
            this.mySet.add((Object)seq);
            index = this.mySet.index((Object)seq);
            assert (index != -1);
            if (id2 >= this.idToIndex.length) {
                this.idToIndex = ArrayUtil.realloc((int[])this.idToIndex, (int)(this.idToIndex.length * 3 / 2));
            }
            this.idToIndex[id2] = index;
            assert (ArrayUtil.indexOf((int[])this.idToIndex, (int)index) == id2);
            assert (this.toId(name) == id2);
        } else {
            id2 = ArrayUtil.indexOf((int[])this.idToIndex, (int)index);
        }
        assert (StringUtil.equals((CharSequence)this.fromId(id2), (CharSequence)name));
        return id2;
    }

    @NotNull
    public CharSequence fromId(int id2) {
        assert (id2 >= 0 && id2 < this.mySet.size());
        return (CharSequence)this.mySet.get(this.idToIndex[id2]);
    }
}

