/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ScreenAreaConsumer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PopupLocationTracker {
    private static final Collection<ScreenAreaConsumer> ourAreaConsumers = new LinkedHashSet<ScreenAreaConsumer>();

    public static boolean register(final @NotNull ScreenAreaConsumer consumer) {
        if (!Registry.is((String)"ide.use.screen.area.tracker", (boolean)false)) {
            return true;
        }
        if (!Disposer.isDisposed((Disposable)consumer) && ourAreaConsumers.add(consumer)) {
            Disposer.register((Disposable)consumer, (Disposable)new Disposable(){

                public void dispose() {
                    ourAreaConsumers.remove(consumer);
                }
            });
            return true;
        }
        return false;
    }

    public static boolean canRectangleBeUsed(@NotNull Component parent, @NotNull Rectangle desiredScreenBounds, @Nullable ScreenAreaConsumer excludedConsumer) {
        if (!Registry.is((String)"ide.use.screen.area.tracker", (boolean)false)) {
            return true;
        }
        Window window = ComponentUtil.getWindow((Component)parent);
        if (window != null) {
            for (ScreenAreaConsumer consumer : ourAreaConsumers) {
                Rectangle area;
                if (consumer == excludedConsumer || window != consumer.getUnderlyingWindow() || !(area = consumer.getConsumedScreenBounds()).intersects(desiredScreenBounds)) continue;
                return false;
            }
        }
        return true;
    }
}

