/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.NotABooleanOptionDescription;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.popup.Balloon;
import java.nio.file.FileVisitResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class PluginBooleanOptionDescriptor
extends NotABooleanOptionDescription
implements BooleanOptionDescription.RequiresRebuild {
    private static final NotificationGroup PLUGINS_LIST_CHANGED_GROUP = new NotificationGroup("Plugins updates", NotificationDisplayType.STICKY_BALLOON, true, null, null, null, PluginManagerCore.CORE_ID);
    private static final NotificationGroup PLUGINS_AUTO_SWITCH_GROUP = new NotificationGroup("Plugins AutoSwitch", NotificationDisplayType.BALLOON, true, null, null, null, PluginManagerCore.CORE_ID);
    private static final Notifier ourRestartNeededNotifier = new Notifier();
    private final IdeaPluginDescriptor plugin;

    PluginBooleanOptionDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        super("Plugins: " + descriptor2.getName(), "preferences.pluginManager");
        this.plugin = descriptor2;
    }

    public boolean isOptionEnabled() {
        return this.plugin.isEnabled();
    }

    public void setOptionState(boolean enabled) {
        Collection<IdeaPluginDescriptor> autoSwitchedIds = enabled ? PluginBooleanOptionDescriptor.getPluginsIdsToEnable(this.plugin) : PluginBooleanOptionDescriptor.getPluginsIdsToDisable(this.plugin);
        boolean enabledWithoutRestart = PluginEnabler.enablePlugins(null, autoSwitchedIds, enabled);
        if (autoSwitchedIds.size() > 1) {
            this.showAutoSwitchNotification(autoSwitchedIds, enabled);
        }
        if (!enabledWithoutRestart) {
            ourRestartNeededNotifier.showNotification();
        }
    }

    private void showAutoSwitchNotification(final @NotNull Collection<IdeaPluginDescriptor> autoSwitchedPlugins, final boolean enabled) {
        StringBuilder builder2 = new StringBuilder();
        for (IdeaPluginDescriptor autoSwitchedPlugin : autoSwitchedPlugins) {
            if (builder2.length() > 0) {
                builder2.append(", ");
            }
            builder2.append('\"').append(autoSwitchedPlugin.getName()).append('\"');
        }
        String dependenciesString = builder2.toString();
        String titleKey = enabled ? "plugins.auto.enabled.notification.title" : "plugins.auto.disabled.notification.title";
        String contentKey = enabled ? "plugins.auto.enabled.notification.content" : "plugins.auto.disabled.notification.content";
        String pluginString = '\"' + this.getOption() + '\"';
        final Notification switchNotification = PLUGINS_AUTO_SWITCH_GROUP.createNotification(IdeBundle.message((String)contentKey, (Object[])new Object[]{pluginString, dependenciesString}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)titleKey, (Object[])new Object[0])).addAction((AnAction)new UndoPluginsSwitchAction(autoSwitchedPlugins, enabled));
        PluginManager.getInstance().addDisablePluginListener(new Runnable(){

            @Override
            public void run() {
                Balloon balloon;
                boolean notificationValid;
                Stream<PluginId> ids = autoSwitchedPlugins.stream().map(PluginDescriptor::getPluginId);
                boolean bl = notificationValid = enabled ? ids.noneMatch(PluginManagerCore::isDisabled) : ids.allMatch(PluginManagerCore::isDisabled);
                if (!notificationValid) {
                    switchNotification.expire();
                }
                if ((balloon = switchNotification.getBalloon()) == null || balloon.isDisposed()) {
                    ApplicationManager.getApplication().invokeLater(() -> PluginManager.getInstance().removeDisablePluginListener(this));
                }
            }
        });
        Notifications.Bus.notify((Notification)switchNotification);
    }

    @NotNull
    private static Collection<IdeaPluginDescriptor> getPluginsIdsToEnable(@NotNull IdeaPluginDescriptor rootDescriptor) {
        HashSet<IdeaPluginDescriptor> result2 = new HashSet<IdeaPluginDescriptor>();
        result2.add(rootDescriptor);
        if (!(rootDescriptor instanceof IdeaPluginDescriptorImpl)) {
            return result2;
        }
        PluginManagerCore.processAllDependencies((IdeaPluginDescriptorImpl)rootDescriptor, false, descriptor2 -> {
            if (descriptor2.getPluginId() == PluginManagerCore.CORE_ID) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (!descriptor2.isEnabled()) {
                return result2.add((IdeaPluginDescriptor)descriptor2) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        });
        return result2;
    }

    @NotNull
    private static Collection<IdeaPluginDescriptor> getPluginsIdsToDisable(@NotNull IdeaPluginDescriptor rootDescriptor) {
        HashSet<IdeaPluginDescriptor> result2 = new HashSet<IdeaPluginDescriptor>();
        result2.add(rootDescriptor);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        PluginId rootId = rootDescriptor.getPluginId();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
            IdeaPluginDescriptorImpl pluginDescriptor;
            PluginId pluginId = plugin.getPluginId();
            if (pluginId == rootId || appInfo.isEssentialPlugin(pluginId) || !plugin.isEnabled() || plugin.isImplementationDetail() || !(plugin instanceof IdeaPluginDescriptorImpl) || (pluginDescriptor = (IdeaPluginDescriptorImpl)plugin).isDeleted()) continue;
            PluginManagerCore.processAllDependencies(pluginDescriptor, false, descriptor2 -> {
                if (descriptor2.getPluginId() == rootId) {
                    result2.add(plugin);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        return result2;
    }

    private static final class Notifier {
        private final AtomicReference<Notification> prevNotification = new AtomicReference();

        private Notifier() {
        }

        public void showNotification() {
            Notification prev = this.prevNotification.get();
            if (prev != null && prev.getBalloon() != null && !prev.getBalloon().isDisposed()) {
                return;
            }
            Notification next = PLUGINS_LIST_CHANGED_GROUP.createNotification(IdeBundle.message((String)"plugins.changed.notification.content", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}), NotificationType.INFORMATION).setTitle(IdeBundle.message((String)"plugins.changed.notification.title", (Object[])new Object[0])).addAction(new AnAction(IdeBundle.message((String)"ide.restart.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ApplicationManager.getApplication().restart();
                }
            });
            if (this.prevNotification.compareAndSet(prev, next)) {
                Notifications.Bus.notify((Notification)next);
            }
        }
    }

    private static final class UndoPluginsSwitchAction
    extends NotificationAction {
        private final Collection<IdeaPluginDescriptor> myDescriptors;
        private final boolean myEnabled;

        UndoPluginsSwitchAction(@NotNull Collection<IdeaPluginDescriptor> descriptors, boolean enabled) {
            super(IdeBundle.message((String)"plugins.auto.switch.action.name", (Object[])new Object[0]));
            this.myDescriptors = descriptors;
            this.myEnabled = enabled;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            boolean enabled = !this.myEnabled;
            DisabledPluginsState.enablePlugins(this.myDescriptors, enabled);
            notification.expire();
            ourRestartNeededNotifier.showNotification();
        }
    }
}

