/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.ProjectTopHitCache;
import com.intellij.ide.ui.TopHitCache;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PreloadingActivity;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.WordPrefixMatcher;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.text.Matcher;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class OptionsTopHitProvider
implements OptionsSearchTopHitProvider,
SearchTopHitProvider {
    public static final ExtensionPointName<OptionsSearchTopHitProvider.ProjectLevelProvider> PROJECT_LEVEL_EP = new ExtensionPointName("com.intellij.search.projectOptionsTopHitProvider");

    @Deprecated
    @NotNull
    public abstract Collection<OptionDescription> getOptions(@Nullable Project var1);

    @NotNull
    private static Collection<OptionDescription> getCachedOptions(@NotNull OptionsSearchTopHitProvider provider, @Nullable Project project, @Nullable PluginDescriptor pluginDescriptor) {
        TopHitCache cache = project == null || provider instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider ? TopHitCache.getInstance() : ProjectTopHitCache.getInstance(project);
        return cache.getCachedOptions(provider, project, pluginDescriptor);
    }

    public final void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
        OptionsTopHitProvider.consumeTopHits(this, pattern, collector, project);
    }

    static void consumeTopHits(@NotNull OptionsSearchTopHitProvider provider, @NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if ((pattern = OptionsTopHitProvider.checkPattern(pattern)) == null) {
            return;
        }
        List parts = StringUtil.split((String)pattern, (String)" ");
        if (!parts.isEmpty()) {
            OptionsTopHitProvider.doConsumeTopHits(provider, pattern, (String)parts.get(0), collector, project);
        }
    }

    private static void doConsumeTopHits(@NotNull OptionsSearchTopHitProvider provider, @NotNull String pattern, @NotNull String id2, @NotNull Consumer<Object> collector, @Nullable Project project) {
        if (provider.getId().startsWith(id2) || pattern.startsWith(" ")) {
            pattern = pattern.startsWith(" ") ? pattern.trim() : pattern.substring(id2.length()).trim();
            OptionsTopHitProvider.consumeTopHitsForApplicableProvider(provider, (Matcher)new WordPrefixMatcher(pattern), collector, project);
        }
    }

    private static void consumeTopHitsForApplicableProvider(@NotNull OptionsSearchTopHitProvider provider, @NotNull Matcher matcher, @NotNull Consumer<Object> collector, @Nullable Project project) {
        for (OptionDescription option2 : OptionsTopHitProvider.getCachedOptions(provider, project, null)) {
            if (!matcher.matches(option2.getOption())) continue;
            collector.accept(option2);
        }
    }

    @Nullable
    private static String checkPattern(@NotNull String pattern) {
        if (!pattern.startsWith(SearchTopHitProvider.getTopHitAccelerator())) {
            return null;
        }
        pattern = pattern.substring(1);
        return pattern;
    }

    @Override
    @NotNull
    public abstract String getId();

    public static String messageApp(@PropertyKey(resourceBundle="messages.ApplicationBundle") String property) {
        return StringUtil.stripHtml((String)ApplicationBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    public static String messageIde(@PropertyKey(resourceBundle="messages.IdeBundle") String property) {
        return StringUtil.stripHtml((String)IdeBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    static final class Activity
    extends PreloadingActivity
    implements StartupActivity.DumbAware {
        Activity() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        @Override
        public void preload(@NotNull ProgressIndicator indicator) {
            Activity.cacheAll(indicator, null);
        }

        public void runActivity(@NotNull Project project) {
            NonUrgentExecutor.getInstance().execute(() -> {
                if (project.isDisposed()) {
                    return;
                }
                Activity.cacheAll(null, project);
                StartUpPerformanceService.getInstance().lastOptionTopHitProviderFinishedForProject(project);
            });
        }

        private static void cacheAll(@Nullable ProgressIndicator indicator, @Nullable Project project) {
            String name = project == null ? "application" : "project";
            com.intellij.diagnostic.Activity activity = StartUpMeasurer.startActivity((String)("cache options in " + name));
            SearchTopHitProvider.EP_NAME.processWithPluginDescriptor((provider, pluginDescriptor) -> {
                OptionsSearchTopHitProvider p;
                if (!(!(provider instanceof OptionsSearchTopHitProvider) || project != null && provider instanceof OptionsSearchTopHitProvider.ApplicationLevelProvider || !(p = (OptionsSearchTopHitProvider)provider).preloadNeeded() || indicator != null && indicator.isCanceled() || project != null && project.isDisposed())) {
                    OptionsTopHitProvider.getCachedOptions(p, project, pluginDescriptor);
                }
            });
            if (project != null) {
                PROJECT_LEVEL_EP.processWithPluginDescriptor((provider, pluginDescriptor) -> {
                    if (indicator != null) {
                        indicator.checkCanceled();
                    }
                    OptionsTopHitProvider.getCachedOptions(provider, project, pluginDescriptor);
                });
            }
            activity.end();
        }
    }

    public static final class ProjectLevelProvidersAdapter
    implements SearchTopHitProvider {
        public void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
            if (project == null) {
                return;
            }
            if ((pattern = OptionsTopHitProvider.checkPattern(pattern)) == null) {
                return;
            }
            List parts = StringUtil.split((String)pattern, (String)" ");
            if (parts.isEmpty()) {
                return;
            }
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider : PROJECT_LEVEL_EP.getExtensionList()) {
                OptionsTopHitProvider.doConsumeTopHits(provider, pattern, (String)parts.get(0), collector, project);
            }
        }

        public void consumeAllTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project project) {
            WordPrefixMatcher matcher = new WordPrefixMatcher(pattern);
            for (OptionsSearchTopHitProvider.ProjectLevelProvider provider : PROJECT_LEVEL_EP.getExtensionList()) {
                OptionsTopHitProvider.consumeTopHitsForApplicableProvider(provider, (Matcher)matcher, collector, project);
            }
        }
    }

    @Deprecated
    public static interface CoveredByToggleActions {
    }
}

