/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.troubleshooting;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.project.Project;
import com.intellij.troubleshooting.GeneralTroubleInfoCollector;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

final class PluginTroubleInfoCollector
implements GeneralTroubleInfoCollector {
    PluginTroubleInfoCollector() {
    }

    @Override
    @NotNull
    public String getTitle() {
        return "Plugins";
    }

    @Override
    @NotNull
    public String collectInfo(@NotNull Project project) {
        IdeaPluginDescriptor[] ourPlugins = PluginManagerCore.getPlugins();
        ArrayList<String> loadedCustom = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        String SPECIAL_IDEA_PLUGIN = "IDEA CORE";
        for (IdeaPluginDescriptor descriptor2 : ourPlugins) {
            String version2 = descriptor2.getVersion();
            String s = descriptor2.getName() + (version2 != null ? " (" + version2 + ")" : "");
            if (descriptor2.isEnabled()) {
                if (descriptor2.isBundled() || SPECIAL_IDEA_PLUGIN.equals(descriptor2.getName())) continue;
                loadedCustom.add(s);
                continue;
            }
            disabled.add(s);
        }
        return "Custom plugins: " + loadedCustom + '\n' + "Disabled plugins:" + disabled + '\n';
    }
}

