/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.SmartList;
import com.intellij.util.messages.Topic;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="TodoConfiguration", storages={@Storage(value="editor.xml")})
public class TodoConfiguration
implements PersistentStateComponent<Element> {
    public static final Topic<PropertyChangeListener> PROPERTY_CHANGE = new Topic("TodoConfiguration changes", PropertyChangeListener.class);
    private boolean myMultiLine = true;
    private TodoPattern[] myTodoPatterns;
    private TodoFilter[] myTodoFilters;
    private IndexPattern[] myIndexPatterns;
    @NonNls
    public static final String PROP_MULTILINE = "multiLine";
    @NonNls
    public static final String PROP_TODO_PATTERNS = "todoPatterns";
    @NonNls
    public static final String PROP_TODO_FILTERS = "todoFilters";
    @NonNls
    private static final String ELEMENT_MULTILINE = "multiLine";
    @NonNls
    private static final String ELEMENT_PATTERN = "pattern";
    @NonNls
    private static final String ELEMENT_FILTER = "filter";

    public TodoConfiguration() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                TodoConfiguration.this.colorSettingsChanged();
            }
        });
        this.resetToDefaultTodoPatterns();
    }

    public static TodoConfiguration getInstance() {
        return (TodoConfiguration)ServiceManager.getService(TodoConfiguration.class);
    }

    public void resetToDefaultTodoPatterns() {
        this.myTodoPatterns = this.getDefaultPatterns();
        this.myTodoFilters = new TodoFilter[0];
        this.buildIndexPatterns();
    }

    protected TodoPattern @NotNull [] getDefaultPatterns() {
        return new TodoPattern[]{new TodoPattern("\\btodo\\b.*", TodoAttributesUtil.createDefault(), false), new TodoPattern("\\bfixme\\b.*", TodoAttributesUtil.createDefault(), false)};
    }

    private void buildIndexPatterns() {
        this.myIndexPatterns = new IndexPattern[this.myTodoPatterns.length];
        for (int i2 = 0; i2 < this.myTodoPatterns.length; ++i2) {
            this.myIndexPatterns[i2] = this.myTodoPatterns[i2].getIndexPattern();
        }
    }

    public TodoPattern @NotNull [] getTodoPatterns() {
        return this.myTodoPatterns;
    }

    public IndexPattern @NotNull [] getIndexPatterns() {
        return this.myIndexPatterns;
    }

    public void setTodoPatterns(TodoPattern @NotNull [] todoPatterns) {
        this.doSetTodoPatterns(todoPatterns, true);
    }

    private void doSetTodoPatterns(@NotNull @NotNull TodoPattern @NotNull [] todoPatterns, boolean shouldNotifyIndices) {
        Object[] oldTodoPatterns = this.myTodoPatterns;
        Object[] oldIndexPatterns = this.myIndexPatterns;
        this.myTodoPatterns = todoPatterns;
        this.buildIndexPatterns();
        if (shouldNotifyIndices && !Arrays.deepEquals(this.myIndexPatterns, oldIndexPatterns)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "indexPatterns", oldTodoPatterns, todoPatterns);
            TodoConfiguration.getPublisher((Topic<PropertyChangeListener>)IndexPatternProvider.INDEX_PATTERNS_CHANGED).propertyChange(event);
        }
        if (!Arrays.deepEquals(this.myTodoPatterns, oldTodoPatterns)) {
            TodoConfiguration.getPublisher(PROPERTY_CHANGE).propertyChange(new PropertyChangeEvent(this, PROP_TODO_PATTERNS, oldTodoPatterns, todoPatterns));
        }
    }

    @NotNull
    private static PropertyChangeListener getPublisher(@NotNull Topic<PropertyChangeListener> topic) {
        return (PropertyChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(topic);
    }

    public TodoFilter getTodoFilter(String name) {
        for (TodoFilter filter2 : this.myTodoFilters) {
            if (!filter2.getName().equals(name)) continue;
            return filter2;
        }
        return null;
    }

    public TodoFilter @NotNull [] getTodoFilters() {
        return this.myTodoFilters;
    }

    public boolean isMultiLine() {
        return this.myMultiLine;
    }

    public void setMultiLine(boolean multiLine) {
        if (multiLine != this.myMultiLine) {
            this.myMultiLine = multiLine;
            TodoConfiguration.getPublisher(PROPERTY_CHANGE).propertyChange(new PropertyChangeEvent(this, "multiLine", !multiLine, multiLine));
        }
    }

    public void setTodoFilters(TodoFilter @NotNull [] filters) {
        TodoFilter[] oldFilters = this.myTodoFilters;
        this.myTodoFilters = filters;
        TodoConfiguration.getPublisher(PROPERTY_CHANGE).propertyChange(new PropertyChangeEvent(this, PROP_TODO_FILTERS, oldFilters, filters));
    }

    public void loadState(@NotNull Element element2) {
        String multiLineText = element2.getChildText("multiLine");
        this.myMultiLine = multiLineText == null || Boolean.valueOf(multiLineText) != false;
        SmartList patternsList = new SmartList();
        for (Element child2 : element2.getChildren(ELEMENT_PATTERN)) {
            patternsList.add(new TodoPattern(child2, TodoAttributesUtil.getDefaultColorSchemeTextAttributes()));
        }
        TodoPattern[] patterns = patternsList.isEmpty() ? this.getDefaultPatterns() : patternsList.toArray(new TodoPattern[0]);
        this.doSetTodoPatterns(patterns, false);
        SmartList filtersList = new SmartList();
        for (Element child3 : element2.getChildren(ELEMENT_FILTER)) {
            filtersList.add(new TodoFilter(child3, Arrays.asList(patterns)));
        }
        if (!filtersList.isEmpty() || this.myTodoFilters.length != 0) {
            this.setTodoFilters(filtersList.toArray(new TodoFilter[0]));
        }
    }

    public Element getState() {
        Element element2 = new Element("state");
        if (!this.myMultiLine) {
            Element m = new Element("multiLine");
            m.setText(Boolean.FALSE.toString());
            element2.addContent(m);
        }
        TodoPattern[] todoPatterns = this.myTodoPatterns;
        if (!Arrays.equals(this.myTodoPatterns, this.getDefaultPatterns())) {
            for (TodoPattern todoPattern : todoPatterns) {
                Element child2 = new Element(ELEMENT_PATTERN);
                todoPattern.writeExternal(child2);
                element2.addContent(child2);
            }
        }
        for (TodoFilter todoFilter : this.myTodoFilters) {
            Element child2 = new Element(ELEMENT_FILTER);
            todoFilter.writeExternal(child2, todoPatterns);
            element2.addContent(child2);
        }
        return element2;
    }

    public void colorSettingsChanged() {
        for (TodoPattern pattern : this.myTodoPatterns) {
            TodoAttributes attributes = pattern.getAttributes();
            if (attributes.shouldUseCustomTodoColor()) continue;
            attributes.setUseCustomTodoColor(false, TodoAttributesUtil.getDefaultColorSchemeTextAttributes());
        }
    }
}

