/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.common;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionStructureUtil;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeElementBase<T extends PsiElement>
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    private final Object myValue;

    protected PsiTreeElementBase(T psiElement) {
        this.myValue = psiElement == null ? null : TreeAnchorizer.getService().createAnchor(psiElement);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this;
    }

    @NotNull
    public Object getKey() {
        return String.valueOf(this.getElement());
    }

    @Nullable
    public final T getElement() {
        return (T)(this.myValue == null ? null : (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myValue));
    }

    public Icon getIcon(boolean open2) {
        T element2 = this.getElement();
        if (element2 != null) {
            int flags = 2;
            if (!(element2 instanceof PsiFile) || !element2.isWritable()) {
                flags |= 1;
            }
            return element2.getIcon(flags);
        }
        return null;
    }

    public T getValue() {
        return this.getElement();
    }

    public String getLocationString() {
        return null;
    }

    public boolean isSearchInLocationString() {
        return false;
    }

    public String toString() {
        T element2 = this.getElement();
        return element2 != null ? element2.toString() : "";
    }

    public final StructureViewTreeElement @NotNull [] getChildren() {
        List list2 = (List)AbstractTreeUi.calculateYieldingToWriteAction(() -> this.doGetChildren(true));
        return list2.isEmpty() ? EMPTY_ARRAY : list2.toArray(EMPTY_ARRAY);
    }

    @NotNull
    public final List<StructureViewTreeElement> getChildrenWithoutCustomRegions() {
        return (List)AbstractTreeUi.calculateYieldingToWriteAction(() -> this.doGetChildren(false));
    }

    @NotNull
    private List<StructureViewTreeElement> doGetChildren(boolean withCustomRegions) {
        T element2 = this.getElement();
        return element2 == null ? Collections.emptyList() : PsiTreeElementBase.mergeWithExtensions(element2, this.getChildrenBase(), withCustomRegions);
    }

    public void navigate(boolean requestFocus) {
        T element2 = this.getElement();
        if (element2 != null) {
            ((Navigatable)element2).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        T element2 = this.getElement();
        return element2 instanceof Navigatable && ((Navigatable)element2).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @NotNull
    public abstract Collection<StructureViewTreeElement> getChildrenBase();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiTreeElementBase that = (PsiTreeElementBase)o;
        T value2 = this.getValue();
        return value2 == null ? that.getValue() == null : value2.equals(that.getValue());
    }

    public int hashCode() {
        T value2 = this.getValue();
        return value2 == null ? 0 : value2.hashCode();
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    @NotNull
    public static List<StructureViewTreeElement> mergeWithExtensions(@NotNull PsiElement element2, @NotNull Collection<StructureViewTreeElement> baseChildren, boolean withCustomRegions) {
        ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(withCustomRegions ? CustomRegionStructureUtil.groupByCustomRegions(element2, baseChildren) : baseChildren);
        StructureViewFactoryEx structureViewFactory = StructureViewFactoryEx.getInstanceEx(element2.getProject());
        Class<?> aClass = element2.getClass();
        for (StructureViewExtension extension : structureViewFactory.getAllExtensions(aClass)) {
            Object[] children2 = extension.getChildren(element2);
            if (children2 != null) {
                ContainerUtil.addAll(result2, (Object[])children2);
            }
            extension.filterChildren(result2, children2 == null || children2.length == 0 ? Collections.emptyList() : Arrays.asList(children2));
        }
        return result2;
    }
}

