/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.ide.script.IdeScriptEngineManager;
import com.intellij.ide.script.IdeScriptException;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeScriptEngineManagerImpl
extends IdeScriptEngineManager {
    private static final Logger LOG = Logger.getInstance(IdeScriptEngineManager.class);
    private final Future<Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory>> myStateFuture = AppExecutorUtil.getAppExecutorService().submit(() -> {
        long start2 = System.currentTimeMillis();
        try {
            Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> map2 = IdeScriptEngineManagerImpl.calcFactories();
            return map2;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.info(ScriptEngineManager.class.getName() + " initialized in " + (end - start2) + " ms");
        }
    });

    IdeScriptEngineManagerImpl() {
    }

    @Override
    @NotNull
    public List<IdeScriptEngineManager.EngineInfo> getEngineInfos() {
        return new ArrayList<IdeScriptEngineManager.EngineInfo>(this.getFactories().keySet());
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngine(@NotNull IdeScriptEngineManager.EngineInfo engineInfo, @Nullable ClassLoader loader) {
        ScriptEngineFactory engineFactory = this.getFactories().get(engineInfo);
        if (engineFactory == null) {
            return null;
        }
        return IdeScriptEngineManagerImpl.createIdeScriptEngine(engineFactory, loader);
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineByName(@NotNull String engineName, @Nullable ClassLoader loader) {
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> state = this.getFactories();
        for (IdeScriptEngineManager.EngineInfo info : state.keySet()) {
            if (!info.engineName.equals(engineName)) continue;
            return IdeScriptEngineManagerImpl.createIdeScriptEngine(state.get(info), loader);
        }
        return null;
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineByFileExtension(@NotNull String extension, @Nullable ClassLoader loader) {
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> state = this.getFactories();
        for (IdeScriptEngineManager.EngineInfo info : state.keySet()) {
            if (!info.fileExtensions.contains(extension)) continue;
            return IdeScriptEngineManagerImpl.createIdeScriptEngine(state.get(info), loader);
        }
        return null;
    }

    @Override
    public boolean isInitialized() {
        return this.myStateFuture.isDone();
    }

    @NotNull
    private Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> getFactories() {
        Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> state = null;
        try {
            state = this.myStateFuture.get();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return state != null ? state : Collections.emptyMap();
    }

    @NotNull
    private static Map<IdeScriptEngineManager.EngineInfo, ScriptEngineFactory> calcFactories() {
        return JBIterable.empty().append(new ScriptEngineManager().getEngineFactories()).append(new ScriptEngineManager(AllPluginsLoader.INSTANCE).getEngineFactories()).unique(o -> o.getClass().getName()).toMap(factory2 -> {
            Class<?> aClass = factory2.getClass();
            ClassLoader classLoader = aClass.getClassLoader();
            PluginDescriptor plugin = classLoader instanceof PluginClassLoader ? ((PluginClassLoader)((Object)((Object)classLoader))).getPluginDescriptor() : null;
            return new IdeScriptEngineManager.EngineInfo(factory2.getEngineName(), factory2.getEngineVersion(), factory2.getLanguageName(), factory2.getLanguageVersion(), factory2.getExtensions(), aClass.getName(), plugin);
        }, o -> o);
    }

    @Nullable
    private static IdeScriptEngine createIdeScriptEngine(@Nullable ScriptEngineFactory scriptEngineFactory, @Nullable ClassLoader loader) {
        if (scriptEngineFactory == null) {
            return null;
        }
        EngineImpl engine = new EngineImpl(scriptEngineFactory, (ClassLoader)ObjectUtils.notNull((Object)loader, (Object)AllPluginsLoader.INSTANCE));
        IdeScriptEngineManagerImpl.redirectOutputToLog(engine);
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(scriptEngineFactory.getClass());
        String factoryClass = pluginInfo.isSafeToReport() ? scriptEngineFactory.getClass().getName() : "third.party";
        FeatureUsageData data2 = new FeatureUsageData().addData("factory", factoryClass).addPluginInfo(pluginInfo);
        FUCounterUsageLogger.getInstance().logEvent("ide.script.engine", "used", data2);
        return engine;
    }

    private static void redirectOutputToLog(@NotNull IdeScriptEngine engine) {
        class Log
        extends Writer {
            final boolean error;

            Log(boolean error) {
                this.error = error;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                while (len > 0 && Character.isWhitespace(cbuf[off + len - 1])) {
                    --len;
                }
                if (len == 0) {
                    return;
                }
                String s = new String(cbuf, off, len);
                if (this.error) {
                    LOG.warn(s);
                } else {
                    LOG.info(s);
                }
            }
        }
        engine.setStdOut(new Log(false));
        engine.setStdErr(new Log(true));
    }

    static class AllPluginsLoader
    extends ClassLoader {
        static final AllPluginsLoader INSTANCE = new AllPluginsLoader();
        final ConcurrentMap<Long, ClassLoader> myLuckyGuess = new ConcurrentHashMap<Long, ClassLoader>();

        AllPluginsLoader() {
            super(null);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            int p0 = name.indexOf("$");
            boolean hasBase = p0 > 0;
            int p1 = hasBase ? name.indexOf("$", p0 + 1) : -1;
            String base = hasBase ? name.substring(0, Math.max(p0, p1)) : name;
            long hash = StringHash.calc((String)base);
            Class<?> c = null;
            ClassLoader guess1 = (ClassLoader)this.myLuckyGuess.get(hash);
            ClassLoader guess2 = (ClassLoader)this.myLuckyGuess.get(0L);
            for (ClassLoader loader : JBIterable.of((Object[])new ClassLoader[]{guess1, guess2})) {
                if (loader == this) {
                    throw new ClassNotFoundException(name);
                }
                if (loader == null) continue;
                try {
                    c = loader.loadClass(name);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (c == null) {
                for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                    ClassLoader l = descriptor2.getPluginClassLoader();
                    if (l == null || l == guess1 || l == guess2) continue;
                    try {
                        if (hasBase) {
                            l.loadClass(base);
                            this.myLuckyGuess.putIfAbsent(hash, l);
                        }
                        try {
                            c = l.loadClass(name);
                            this.myLuckyGuess.putIfAbsent(hash, l);
                            this.myLuckyGuess.put(0L, l);
                        }
                        catch (ClassNotFoundException e) {
                            if (hasBase || name.startsWith("java.")) break;
                            if (!name.startsWith("groovy.")) continue;
                        }
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (c != null) {
                return c;
            }
            this.myLuckyGuess.putIfAbsent(hash, this);
            throw new ClassNotFoundException(name);
        }

        private static boolean isAllowedPluginResource(String name) {
            return "META-INF/services/javax.script.ScriptEngineFactory".equals(name);
        }

        @Override
        protected URL findResource(String name) {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                    URL url;
                    ClassLoader l = descriptor2.getPluginClassLoader();
                    URL uRL = url = l == null ? null : l.getResource(name);
                    if (url == null) continue;
                    return url;
                }
            }
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                LinkedHashSet result2 = null;
                for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
                    Enumeration<URL> urls;
                    ClassLoader l = descriptor2.getPluginClassLoader();
                    Enumeration<URL> enumeration = urls = l == null ? null : l.getResources(name);
                    if (urls == null || !urls.hasMoreElements()) continue;
                    if (result2 == null) {
                        result2 = new LinkedHashSet();
                    }
                    ContainerUtil.addAll(result2, urls);
                }
                if (result2 != null) {
                    return Collections.enumeration(result2);
                }
            }
            return this.getClass().getClassLoader().getResources(name);
        }

        @NotNull
        public List<URL> getUrls() {
            return JBIterable.of((Object[])PluginManagerCore.getPlugins()).map(PluginDescriptor::getPluginClassLoader).unique().flatMap(o -> {
                try {
                    return (List)o.getClass().getMethod("getUrls", new Class[0]).invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }).unique().toList();
        }
    }

    static class EngineImpl
    implements IdeScriptEngine {
        private final ScriptEngine myEngine;
        private final ClassLoader myLoader;

        EngineImpl(@NotNull ScriptEngineFactory factory2, @Nullable ClassLoader loader) {
            this.myLoader = loader;
            this.myEngine = (ScriptEngine)ClassLoaderUtil.computeWithClassLoader((ClassLoader)this.myLoader, () -> factory2.getScriptEngine());
        }

        @Override
        public Object getBinding(@NotNull String name) {
            return this.myEngine.get(name);
        }

        @Override
        public void setBinding(@NotNull String name, Object value2) {
            this.myEngine.put(name, value2);
        }

        @Override
        @NotNull
        public Writer getStdOut() {
            return this.myEngine.getContext().getWriter();
        }

        @Override
        public void setStdOut(@NotNull Writer writer) {
            this.myEngine.getContext().setWriter(writer);
        }

        @Override
        @NotNull
        public Writer getStdErr() {
            return this.myEngine.getContext().getErrorWriter();
        }

        @Override
        public void setStdErr(@NotNull Writer writer) {
            this.myEngine.getContext().setErrorWriter(writer);
        }

        @Override
        @NotNull
        public Reader getStdIn() {
            return this.myEngine.getContext().getReader();
        }

        @Override
        public void setStdIn(@NotNull Reader reader) {
            this.myEngine.getContext().setReader(reader);
        }

        @Override
        @NotNull
        public String getLanguage() {
            return this.myEngine.getFactory().getLanguageName();
        }

        @Override
        @NotNull
        public List<String> getFileExtensions() {
            return this.myEngine.getFactory().getExtensions();
        }

        @Override
        public Object eval(@NotNull String script) throws IdeScriptException {
            return ClassLoaderUtil.computeWithClassLoader((ClassLoader)this.myLoader, () -> {
                try {
                    return this.myEngine.eval(script);
                }
                catch (Throwable ex) {
                    while (ex instanceof ScriptException && ex.getCause() != null) {
                        ex = ex.getCause();
                    }
                    throw new IdeScriptException(ex);
                }
            });
        }
    }
}

