/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.actions.MoveModulesToGroupAction;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.DropTargetNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleGroupNode
extends ProjectViewNode<ModuleGroup>
implements DropTargetNode {
    public ModuleGroupNode(Project project, @NotNull ModuleGroup value2, ViewSettings viewSettings) {
        super(project, (Object)value2, viewSettings);
    }

    @NotNull
    protected abstract AbstractTreeNode createModuleNode(@NotNull Module var1) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;

    @NotNull
    protected abstract ModuleGroupNode createModuleGroupNode(@NotNull ModuleGroup var1);

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        Collection<ModuleGroup> childGroups = ((ModuleGroup)this.getValue()).childGroups(this.getProject());
        ArrayList result2 = new ArrayList();
        for (ModuleGroup moduleGroup : childGroups) {
            result2.add((AbstractTreeNode<?>)this.createModuleGroupNode(moduleGroup));
        }
        Collection<Module> modules2 = ((ModuleGroup)this.getValue()).modulesInGroup(this.getProject());
        try {
            for (Module module : modules2) {
                result2.add(this.createModuleNode(module));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            LOG.error((Throwable)reflectiveOperationException);
        }
        return result2;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        Collection<AbstractTreeNode<?>> children2 = this.getChildren();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (AbstractTreeNode<?> each : children2) {
            if (!(each instanceof ProjectViewNode)) continue;
            result2.addAll(((ProjectViewNode)each).getRoots());
        }
        return result2;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        VirtualFile archiveFile;
        List<Module> modules2 = this.getModulesByFile(file2);
        if (modules2.isEmpty() && file2.getFileSystem() instanceof ArchiveFileSystem && (archiveFile = ((ArchiveFileSystem)file2.getFileSystem()).getLocalByEntry(file2)) != null) {
            modules2 = this.getModulesByFile(archiveFile);
        }
        List<String> thisGroupPath = ((ModuleGroup)this.getValue()).getGroupPathList();
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)this.getProject());
        for (Module module : modules2) {
            if (!ContainerUtil.startsWith((List)grouper.getGroupPath(module), thisGroupPath)) continue;
            return true;
        }
        return false;
    }

    public boolean validate() {
        return this.getValue() != null;
    }

    @NotNull
    protected abstract List<Module> getModulesByFile(@NotNull VirtualFile var1);

    public void update(@NotNull PresentationData presentation2) {
        presentation2.setPresentableText(this.getPresentableName());
        presentation2.setIcon(PlatformIcons.CLOSED_MODULE_GROUP_ICON);
    }

    @NotNull
    private String getPresentableName() {
        return StringUtil.join(this.getRelativeGroupPath(), (String)".");
    }

    private List<String> getRelativeGroupPath() {
        List<String> parentPath;
        AbstractTreeNode parent = this.getParent();
        List<String> thisPath = ((ModuleGroup)this.getValue()).getGroupPathList();
        if (parent instanceof ModuleGroupNode && ContainerUtil.startsWith(thisPath, parentPath = ((ModuleGroup)((ModuleGroupNode)parent).getValue()).getGroupPathList())) {
            return thisPath.subList(parentPath.size(), thisPath.size());
        }
        return thisPath;
    }

    public String getTestPresentation() {
        return "Group: " + this.getPresentableName();
    }

    public String getToolTip() {
        return IdeBundle.message((String)"tooltip.module.group", (Object[])new Object[0]);
    }

    public int getWeight() {
        return 0;
    }

    public int getTypeSortWeight(boolean sortByType) {
        return 1;
    }

    @Override
    public boolean canDrop(TreeNode @NotNull [] sourceNodes) {
        List<Module> modules2 = ModuleGroupNode.extractModules(sourceNodes);
        return !modules2.isEmpty();
    }

    @Override
    public void drop(TreeNode @NotNull [] sourceNodes, @NotNull DataContext dataContext) {
        List<Module> modules2 = ModuleGroupNode.extractModules(sourceNodes);
        MoveModulesToGroupAction.doMove(modules2.toArray(Module.EMPTY_ARRAY), (ModuleGroup)this.getValue(), null);
    }

    @Override
    public void dropExternalFiles(PsiFileSystemItem[] sourceFileArray, DataContext dataContext) {
    }

    private static List<Module> extractModules(TreeNode[] sourceNodes) {
        ArrayList<Module> modules2 = new ArrayList<Module>();
        for (TreeNode sourceNode : sourceNodes) {
            Object userObject;
            if (!(sourceNode instanceof DefaultMutableTreeNode) || !((userObject = AbstractProjectViewPane.extractValueFromNode(sourceNode)) instanceof Module)) continue;
            modules2.add((Module)userObject);
        }
        return modules2;
    }
}

