/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.FileNestingBuilder;
import com.intellij.ide.projectView.impl.ProjectViewFileNestingService;
import com.intellij.ide.projectView.impl.ProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.NestingTreeNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class NestingTreeStructureProvider
implements TreeStructureProvider,
DumbAware {
    private static final Logger LOG = Logger.getInstance(NestingTreeStructureProvider.class);

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
        if (!(settings instanceof ProjectViewSettings) || !((ProjectViewSettings)settings).isUseFileNestingRules()) {
            return children2;
        }
        if (!(parent instanceof PsiDirectoryNode)) {
            return children2;
        }
        ArrayList<PsiFileNode> childNodes = new ArrayList<PsiFileNode>();
        for (AbstractTreeNode<?> node : children2) {
            if (!(node instanceof PsiFileNode)) continue;
            childNodes.add((PsiFileNode)node);
        }
        Function<PsiFileNode, String> fileNameFunc = psiFileNode -> {
            PsiFile file2 = (PsiFile)psiFileNode.getValue();
            if (file2 == null) {
                return null;
            }
            return file2.getName();
        };
        FileNestingBuilder fileNestingBuilder = FileNestingBuilder.getInstance();
        MultiMap<PsiFileNode, PsiFileNode> parentToChildren = fileNestingBuilder.mapParentToChildren(childNodes, fileNameFunc);
        if (parentToChildren.isEmpty()) {
            return children2;
        }
        ArrayList newChildren = new ArrayList(children2.size() - parentToChildren.size());
        THashSet childrenToMoveDown = new THashSet(parentToChildren.values());
        for (AbstractTreeNode<?> node : children2) {
            if (!(node instanceof PsiFileNode)) {
                newChildren.add(node);
                continue;
            }
            if (childrenToMoveDown.contains(node)) continue;
            Collection childrenOfThisFile = parentToChildren.get((Object)((PsiFileNode)node));
            if (childrenOfThisFile.isEmpty()) {
                newChildren.add(node);
                continue;
            }
            newChildren.add((AbstractTreeNode<?>)new NestingTreeNode((PsiFileNode)node, childrenOfThisFile));
        }
        return newChildren;
    }

    public static Collection<ChildFileInfo> getFilesShownAsChildrenInProjectView(@NotNull Project project, @NotNull VirtualFile parentFile) {
        LOG.assertTrue(!parentFile.isDirectory());
        AbstractProjectViewPane pane2 = ProjectView.getInstance(project).getProjectViewPaneById("ProjectPane");
        if (pane2 instanceof ProjectViewPane && !((ProjectViewPane)pane2).isUseFileNestingRules()) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rules = FileNestingBuilder.getInstance().getNestingRules();
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rulesWhereItCanBeParent = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), true);
        if (rulesWhereItCanBeParent.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<ProjectViewFileNestingService.NestingRule> rulesWhereItCanBeChild = NestingTreeStructureProvider.filterRules(rules, parentFile.getName(), false);
        VirtualFile dir = parentFile.getParent();
        if (dir == null) {
            return Collections.emptyList();
        }
        VirtualFile[] children2 = dir.getChildren();
        if (children2.length <= 1) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        for (VirtualFile child2 : children2) {
            String baseName;
            Couple<Boolean> c;
            String childName;
            if (child2.isDirectory() || child2.equals(parentFile)) continue;
            for (ProjectViewFileNestingService.NestingRule rule : rulesWhereItCanBeChild) {
                childName = child2.getName();
                c = FileNestingBuilder.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesParent = (Boolean)c.first;
                if (!matchesParent) continue;
                baseName = childName.substring(0, childName.length() - rule.getParentFileSuffix().length());
                if (!parentFile.getName().equals(baseName + rule.getChildFileSuffix())) continue;
                return Collections.emptyList();
            }
            for (ProjectViewFileNestingService.NestingRule rule : rulesWhereItCanBeParent) {
                childName = child2.getName();
                c = FileNestingBuilder.checkMatchingAsParentOrChild(rule, childName);
                boolean matchesChild = (Boolean)c.second;
                if (!matchesChild) continue;
                baseName = childName.substring(0, childName.length() - rule.getChildFileSuffix().length());
                if (!parentFile.getName().equals(baseName + rule.getParentFileSuffix())) continue;
                result2.add((Object)new ChildFileInfo(child2, baseName));
            }
        }
        return result2;
    }

    @NotNull
    private static Collection<ProjectViewFileNestingService.NestingRule> filterRules(@NotNull Collection<? extends ProjectViewFileNestingService.NestingRule> rules, @NotNull String fileName, boolean parentNotChild) {
        SmartList result2 = new SmartList();
        for (ProjectViewFileNestingService.NestingRule nestingRule : rules) {
            Couple<Boolean> c = FileNestingBuilder.checkMatchingAsParentOrChild(nestingRule, fileName);
            boolean matchesParent = (Boolean)c.first;
            boolean matchesChild = (Boolean)c.second;
            if (!matchesChild && !matchesParent) continue;
            if (matchesParent && parentNotChild) {
                result2.add((Object)nestingRule);
            }
            if (!matchesChild || parentNotChild) continue;
            result2.add((Object)nestingRule);
        }
        return result2;
    }

    public static class ChildFileInfo {
        @NotNull
        public final VirtualFile file;
        @NotNull
        public final String namePartCommonWithParentFile;

        public ChildFileInfo(@NotNull VirtualFile file2, @NotNull String namePartCommonWithParentFile) {
            this.file = file2;
            this.namePartCommonWithParentFile = namePartCommonWithParentFile;
        }
    }
}

