/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.actions.MoveModulesOutsideGroupAction;
import com.intellij.ide.projectView.actions.MoveModulesToSubGroupAction;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.MoveModuleToGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveModuleToGroupTopLevel
extends ActionGroup {
    public void update(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Module[] modules2 = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        boolean active = project != null && modules2 != null && modules2.length != 0 && !ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)project);
        e.getPresentation().setVisible(active);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            return EMPTY_ARRAY;
        }
        Project project = MoveModuleToGroupTopLevel.getEventProject((AnActionEvent)e);
        if (project == null) {
            return EMPTY_ARRAY;
        }
        ModifiableModuleModel moduleModel = (ModifiableModuleModel)e.getData(LangDataKeys.MODIFIABLE_MODULE_MODEL);
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)project, (ModifiableModuleModel)moduleModel);
        ArrayList<String> topLevelGroupNames = new ArrayList<String>(MoveModuleToGroupTopLevel.getTopLevelGroupNames(grouper));
        Collections.sort(topLevelGroupNames);
        ArrayList<Object> result2 = new ArrayList<Object>();
        result2.add((Object)new MoveModulesOutsideGroupAction());
        result2.add((Object)new MoveModulesToSubGroupAction(null));
        result2.add(Separator.getInstance());
        for (String name : topLevelGroupNames) {
            result2.add((Object)new MoveModuleToGroup(new ModuleGroup(Collections.singletonList(name))));
        }
        return result2.toArray(AnAction.EMPTY_ARRAY);
    }

    private static Collection<String> getTopLevelGroupNames(ModuleGrouper grouper) {
        HashSet<String> topLevelGroupNames = new HashSet<String>();
        for (Module child2 : grouper.getAllModules()) {
            List group = grouper.getGroupPath(child2);
            if (group.isEmpty()) continue;
            topLevelGroupNames.add((String)group.get(0));
        }
        return topLevelGroupNames;
    }
}

