/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IdeView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeViewForProjectViewPane
implements IdeView {
    private final Supplier<? extends AbstractProjectViewPane> supplier;

    public IdeViewForProjectViewPane(Supplier<? extends AbstractProjectViewPane> supplier2) {
        this.supplier = supplier2;
    }

    @Nullable
    public PsiDirectory getOrChooseDirectory() {
        return DirectoryChooserUtil.getOrChooseDirectory(this);
    }

    public PsiDirectory @NotNull [] getDirectories() {
        AbstractProjectViewPane pane2 = this.supplier.get();
        return pane2 == null ? PsiDirectory.EMPTY_ARRAY : pane2.getSelectedDirectories();
    }

    public void selectElement(PsiElement element2) {
        AbstractProjectViewPane pane2 = this.supplier.get();
        if (pane2 == null || element2 == null) {
            return;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element2);
        boolean requestFocus = element2 instanceof PsiDirectory;
        pane2.select(element2, file2, requestFocus);
        if (!requestFocus && null == EditorHelper.openInEditor(element2, false, true)) {
            pane2.select(element2, file2, true);
        }
    }
}

