/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.ProjectViewFileNestingService;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileNestingBuilder {
    private long myBaseListModCount = -1L;
    private Set<ProjectViewFileNestingService.NestingRule> myNestingRules;

    public static FileNestingBuilder getInstance() {
        return (FileNestingBuilder)ServiceManager.getService(FileNestingBuilder.class);
    }

    @NotNull
    public synchronized Collection<ProjectViewFileNestingService.NestingRule> getNestingRules() {
        ProjectViewFileNestingService fileNestingService = ProjectViewFileNestingService.getInstance();
        List<ProjectViewFileNestingService.NestingRule> baseRules = fileNestingService.getRules();
        long modCount = fileNestingService.getModificationCount();
        if (this.myNestingRules == null || this.myBaseListModCount != modCount) {
            this.myNestingRules = new THashSet();
            this.myBaseListModCount = modCount;
            MultiMap childToParentSuffix = new MultiMap();
            MultiMap parentToChildSuffix = new MultiMap();
            for (ProjectViewFileNestingService.NestingRule rule : baseRules) {
                String parentFileSuffix = rule.getParentFileSuffix();
                String childFileSuffix = rule.getChildFileSuffix();
                if (parentFileSuffix.isEmpty() || childFileSuffix.isEmpty() || parentFileSuffix.equals(childFileSuffix)) continue;
                this.myNestingRules.add(rule);
                childToParentSuffix.putValue((Object)childFileSuffix, (Object)parentFileSuffix);
                parentToChildSuffix.putValue((Object)parentFileSuffix, (Object)childFileSuffix);
                for (String s : parentToChildSuffix.get((Object)childFileSuffix)) {
                    this.myNestingRules.add(new ProjectViewFileNestingService.NestingRule(parentFileSuffix, s));
                    parentToChildSuffix.putValue((Object)parentFileSuffix, (Object)s);
                    childToParentSuffix.putValue((Object)s, (Object)parentFileSuffix);
                }
                for (String s : childToParentSuffix.get((Object)parentFileSuffix)) {
                    this.myNestingRules.add(new ProjectViewFileNestingService.NestingRule(s, childFileSuffix));
                    parentToChildSuffix.putValue((Object)s, (Object)childFileSuffix);
                    childToParentSuffix.putValue((Object)childFileSuffix, (Object)s);
                }
            }
        }
        return this.myNestingRules;
    }

    @NotNull
    public <T> MultiMap<T, T> mapParentToChildren(@NotNull Collection<? extends T> nodes, @NotNull Function<? super T, String> fileNameFunc) {
        Collection<ProjectViewFileNestingService.NestingRule> rules = this.getNestingRules();
        if (rules.isEmpty()) {
            return MultiMap.empty();
        }
        MultiMap parentToChildren = null;
        THashSet allChildNodes = null;
        THashMap baseNameAndRuleToEdge = null;
        for (T node : nodes) {
            String fileName = fileNameFunc.apply(node);
            if (fileName == null) continue;
            for (ProjectViewFileNestingService.NestingRule rule : rules) {
                Edge<T> edge;
                String baseName;
                Couple<Boolean> c = FileNestingBuilder.checkMatchingAsParentOrChild(rule, fileName);
                boolean matchesParent = (Boolean)c.first;
                boolean matchesChild = (Boolean)c.second;
                if (!matchesChild && !matchesParent) continue;
                if (baseNameAndRuleToEdge == null) {
                    baseNameAndRuleToEdge = new THashMap();
                    parentToChildren = new MultiMap();
                    allChildNodes = new THashSet();
                }
                if (matchesParent) {
                    baseName = fileName.substring(0, fileName.length() - rule.getParentFileSuffix().length());
                    edge = FileNestingBuilder.getOrCreateEdge(baseNameAndRuleToEdge, baseName, rule);
                    ((Edge)edge).from = node;
                    FileNestingBuilder.updateInfoIfEdgeComplete(parentToChildren, allChildNodes, edge);
                }
                if (!matchesChild) continue;
                baseName = fileName.substring(0, fileName.length() - rule.getChildFileSuffix().length());
                edge = FileNestingBuilder.getOrCreateEdge(baseNameAndRuleToEdge, baseName, rule);
                ((Edge)edge).to = node;
                FileNestingBuilder.updateInfoIfEdgeComplete(parentToChildren, allChildNodes, edge);
            }
        }
        return parentToChildren == null ? MultiMap.empty() : parentToChildren;
    }

    public static Couple<Boolean> checkMatchingAsParentOrChild(@NotNull ProjectViewFileNestingService.NestingRule rule, @NotNull String fileName) {
        String parentFileSuffix = rule.getParentFileSuffix();
        String childFileSuffix = rule.getChildFileSuffix();
        boolean matchesParent = StringUtil.endsWithIgnoreCase((String)fileName, (String)parentFileSuffix);
        boolean matchesChild = StringUtil.endsWithIgnoreCase((String)fileName, (String)childFileSuffix);
        if (matchesParent && matchesChild) {
            if (parentFileSuffix.length() > childFileSuffix.length()) {
                matchesChild = false;
            } else {
                matchesParent = false;
            }
        }
        return Couple.of((Object)matchesParent, (Object)matchesChild);
    }

    @NotNull
    private static <T> Edge<T> getOrCreateEdge(@NotNull Map<Pair<String, ProjectViewFileNestingService.NestingRule>, Edge<T>> baseNameAndRuleToEdge, @NotNull String baseName, @NotNull ProjectViewFileNestingService.NestingRule rule) {
        Pair baseNameAndRule = Pair.create((Object)baseName, (Object)rule);
        Edge<T> edge = baseNameAndRuleToEdge.get(baseNameAndRule);
        if (edge == null) {
            edge = new Edge();
            baseNameAndRuleToEdge.put((Pair<String, ProjectViewFileNestingService.NestingRule>)baseNameAndRule, edge);
        }
        return edge;
    }

    private static <T> void updateInfoIfEdgeComplete(@NotNull MultiMap<T, T> parentToChildren, @NotNull Set<? super T> allChildNodes, @NotNull Edge<? extends T> edge) {
        if (((Edge)edge).from != null && ((Edge)edge).to != null) {
            allChildNodes.add(((Edge)edge).to);
            parentToChildren.remove(((Edge)edge).to);
            if (!allChildNodes.contains(((Edge)edge).from)) {
                parentToChildren.putValue(((Edge)edge).from, ((Edge)edge).to);
            }
        }
    }

    private static class Edge<T> {
        @Nullable
        private T from;
        @Nullable
        private T to;

        private Edge() {
        }
    }
}

