/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundTreeStructureProvider
implements TreeStructureProvider {
    private static final Key<TreeStructureProvider> KEY = Key.create((String)"TreeStructureProvider");
    private static final Logger LOG = Logger.getInstance(CompoundTreeStructureProvider.class);
    private final Project myProject;

    @Nullable
    public static TreeStructureProvider get(@Nullable Project project) {
        if (project == null || project.isDisposed() || project.isDefault()) {
            return null;
        }
        TreeStructureProvider provider = (TreeStructureProvider)project.getUserData(KEY);
        if (provider != null) {
            return provider;
        }
        provider = new CompoundTreeStructureProvider(project);
        project.putUserData(KEY, (Object)provider);
        return provider;
    }

    private CompoundTreeStructureProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children2, ViewSettings settings) {
        if (this.myProject.isDisposed()) {
            return children2;
        }
        for (TreeStructureProvider provider : EP.getExtensions((AreaInstance)this.myProject)) {
            try {
                if (!(children2 = provider.modify(parent, children2, settings)).stream().anyMatch(Objects::isNull)) continue;
                LOG.warn("null child provided by " + provider);
                children2 = StreamEx.of((Collection)children2).nonNull().toImmutableList();
            }
            catch (IndexNotReadyException exception) {
                throw new ProcessCanceledException((Throwable)exception);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.warn("unexpected error in " + provider, (Throwable)exception);
            }
        }
        children2.forEach(node -> node.setParent(parent));
        return children2;
    }

    @Nullable
    public Object getData(@NotNull Collection<AbstractTreeNode<?>> selection, @NotNull String dataId) {
        if (!this.myProject.isDisposed() && !selection.isEmpty()) {
            for (TreeStructureProvider provider : EP.getExtensions((AreaInstance)this.myProject)) {
                try {
                    Object data2 = provider.getData(selection, dataId);
                    if (data2 == null) continue;
                    return data2;
                }
                catch (IndexNotReadyException data2) {
                }
                catch (ProcessCanceledException data2) {
                }
                catch (Exception exception) {
                    LOG.warn("unexpected error in " + provider, (Throwable)exception);
                }
            }
        }
        return null;
    }
}

