/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveModulesToGroupAction
extends AnAction {
    protected final ModuleGroup myModuleGroup;

    public MoveModulesToGroupAction(ModuleGroup moduleGroup, String title) {
        super(title);
        this.myModuleGroup = moduleGroup;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Module[] modules2 = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        e.getPresentation().setEnabledAndVisible(modules2 != null);
        if (modules2 != null) {
            String description = IdeBundle.message((String)"message.move.modules.to.group", (Object[])new Object[]{MoveModulesToGroupAction.whatToMove(modules2), this.myModuleGroup.presentableText()});
            presentation2.setDescription(description);
        }
    }

    protected static String whatToMove(Module @NotNull [] modules2) {
        return modules2.length == 1 ? IdeBundle.message((String)"message.module", (Object[])new Object[]{modules2[0].getName()}) : IdeBundle.message((String)"message.modules", (Object[])new Object[0]);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module[] modules2 = (Module[])e.getRequiredData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        MoveModulesToGroupAction.doMove(modules2, this.myModuleGroup, e.getDataContext());
    }

    public static void doMove(Module @NotNull [] modules2, ModuleGroup group, @Nullable DataContext dataContext) {
        Project project = modules2[0].getProject();
        for (Module module : modules2) {
            ModifiableModuleModel model;
            ModifiableModuleModel modifiableModuleModel = model = dataContext != null ? (ModifiableModuleModel)LangDataKeys.MODIFIABLE_MODULE_MODEL.getData(dataContext) : null;
            if (model != null) {
                model.setModuleGroupPath(module, group == null ? null : group.getGroupPath());
                continue;
            }
            ModuleManagerImpl.getInstanceImpl(project).setModuleGroupPath(module, group == null ? null : group.getGroupPath());
        }
        AbstractProjectViewPane pane2 = ProjectView.getInstance(project).getCurrentProjectViewPane();
        if (pane2 != null) {
            pane2.updateFromRoot(true);
        }
        if (!ProjectSettingsService.getInstance(project).processModulesMoved(modules2, group) && pane2 != null) {
            if (group != null) {
                pane2.selectModuleGroup(group, true);
            } else {
                pane2.selectModule(modules2[0], true);
            }
        }
    }
}

