/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectViewPsiTreeChangeListener
extends PsiTreeChangeAdapter {
    private final PsiModificationTracker myModificationTracker;
    private long myModificationCount;

    protected ProjectViewPsiTreeChangeListener(@NotNull Project project) {
        this.myModificationTracker = PsiManager.getInstance((Project)project).getModificationTracker();
        this.myModificationCount = this.myModificationTracker.getModificationCount();
    }

    protected abstract AbstractTreeUpdater getUpdater();

    protected abstract boolean isFlattenPackages();

    protected abstract DefaultMutableTreeNode getRootNode();

    public final void childRemoved(@NotNull PsiTreeChangeEvent event) {
        PsiElement child2 = event.getOldChild();
        if (child2 instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childAdded(@NotNull PsiTreeChangeEvent event) {
        PsiElement child2 = event.getNewChild();
        if (child2 instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childReplaced(@NotNull PsiTreeChangeEvent event) {
        PsiElement oldChild = event.getOldChild();
        PsiElement newChild = event.getNewChild();
        if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
            return;
        }
        this.childrenChanged(event.getParent(), true);
    }

    public final void childMoved(@NotNull PsiTreeChangeEvent event) {
        this.childrenChanged(event.getOldParent(), false);
        this.childrenChanged(event.getNewParent(), true);
    }

    public final void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        this.childrenChanged(event.getParent(), true);
    }

    protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
        if (parent instanceof PsiDirectory && this.isFlattenPackages()) {
            this.addSubtreeToUpdateByRoot();
            return;
        }
        long newModificationCount = this.myModificationTracker.getModificationCount();
        if (newModificationCount == this.myModificationCount) {
            return;
        }
        if (stopProcessingForThisModificationCount) {
            this.myModificationCount = newModificationCount;
        }
        while (parent != null) {
            if (parent instanceof PsiFile) {
                VirtualFile virtualFile = ((PsiFile)parent).getVirtualFile();
                if (virtualFile != null && virtualFile.getFileType() != FileTypes.PLAIN_TEXT && (parent = ((PsiFile)parent).getContainingDirectory()) == null) {
                    break;
                }
            } else if (parent instanceof PsiDirectory && ScratchUtil.isScratch(((PsiDirectory)parent).getVirtualFile())) {
                this.addSubtreeToUpdateByRoot();
                break;
            }
            if (this.addSubtreeToUpdateByElementFile(parent) || parent instanceof PsiFile || parent instanceof PsiDirectory) break;
            parent = parent.getParent();
        }
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        String propertyName = event.getPropertyName();
        PsiElement element2 = event.getElement();
        if (propertyName.equals("roots")) {
            this.addSubtreeToUpdateByRoot();
        } else if (propertyName.equals("writable")) {
            if (!this.addSubtreeToUpdateByElementFile(element2) && element2 instanceof PsiFile) {
                this.addSubtreeToUpdateByElementFile((PsiElement)((PsiFile)element2).getContainingDirectory());
            }
        } else if (propertyName.equals("fileName") || propertyName.equals("directoryName")) {
            if (element2 instanceof PsiDirectory && this.isFlattenPackages()) {
                this.addSubtreeToUpdateByRoot();
                return;
            }
            PsiElement parent = element2.getParent();
            if (parent == null || !this.addSubtreeToUpdateByElementFile(parent)) {
                this.addSubtreeToUpdateByElementFile(element2);
            }
        } else if (propertyName.equals("propFileTypes") || propertyName.equals("propUnloadedPsi")) {
            this.addSubtreeToUpdateByRoot();
        }
    }

    protected void addSubtreeToUpdateByRoot() {
        AbstractTreeUpdater updater2 = this.getUpdater();
        DefaultMutableTreeNode root = this.getRootNode();
        if (updater2 != null && root != null) {
            updater2.addSubtreeToUpdate(root);
        }
    }

    protected boolean addSubtreeToUpdateByElement(@NotNull PsiElement element2) {
        AbstractTreeUpdater updater2 = this.getUpdater();
        return updater2 != null && updater2.addSubtreeToUpdateByElement((Object)element2);
    }

    private boolean addSubtreeToUpdateByElementFile(PsiElement element2) {
        return element2 != null && this.addSubtreeToUpdateByElement((PsiElement)ObjectUtils.notNull((Object)element2.getContainingFile(), (Object)element2));
    }
}

