/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.LinkComponent;
import com.intellij.ide.plugins.newui.Tags;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TagComponent
extends LinkComponent {
    private static final Color BACKGROUND = JBColor.namedColor((String)"Plugins.tagBackground", (Color)new JBColor(0xEAEAEC, 0x4D4D4D));
    private static final Color EAP_BACKGROUND = JBColor.namedColor((String)"Plugins.eapTagBackground", (Color)new JBColor(15913679, 15913679));
    private static final Color PAID_BACKGROUND = JBColor.namedColor((String)"Plugins.paidTagBackground", (Color)new JBColor(14216696, 4083804));
    private static final Color TRIAL_BACKGROUND = JBColor.namedColor((String)"Plugins.trialTagBackground", (Color)new JBColor(14411997, 54875982));
    private static final Color FOREGROUND = JBColor.namedColor((String)"Plugins.tagForeground", (Color)new JBColor(0x787878, 0x999999));
    private Color myColor;

    public TagComponent() {
        this.setForeground(FOREGROUND);
        this.setPaintUnderline(false);
        this.setOpaque(false);
        this.setBorder((Border)JBUI.Borders.empty((int)1, (int)8));
    }

    public TagComponent(@NotNull String name) {
        this();
        this.setText(name);
    }

    public void setText(@NotNull String name) {
        String tooltip = null;
        this.myColor = BACKGROUND;
        if (Tags.EAP.name().equals(name)) {
            this.myColor = EAP_BACKGROUND;
            tooltip = "The EAP version does not guarantee the stability\nand availability of the plugin.";
        } else if (Tags.Trial.name().equals(name) || Tags.Purchased.name().equals(name)) {
            this.myColor = TRIAL_BACKGROUND;
        } else if (Tags.Paid.name().equals(name)) {
            this.myColor = PAID_BACKGROUND;
            tooltip = "Activate the plugin license after installation or use the 30-day trial.";
        }
        super.setText(name);
        this.setToolTipText(tooltip);
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.myUnderline ? new Color(this.myColor.getRed(), this.myColor.getGreen(), this.myColor.getBlue(), 178) : this.myColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    protected boolean isInClickableArea(Point pt) {
        return true;
    }
}

