/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.SearchWords;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class SearchQueryParser {
    public String searchQuery;

    protected void addToSearchQuery(@NotNull String query) {
        this.searchQuery = this.searchQuery == null ? query : this.searchQuery + " " + query;
    }

    @NotNull
    protected static List<String> splitQuery(@NotNull String query) {
        ArrayList<String> words = new ArrayList<String>();
        int length = query.length();
        int index = 0;
        block0: while (index < length) {
            char startCh;
            if ((startCh = query.charAt(index++)) == ' ') continue;
            if (startCh == '\"') {
                int end = query.indexOf(34, index);
                if (end == -1) break;
                words.add(query.substring(index, end));
                index = end + 1;
                continue;
            }
            int start2 = index - 1;
            while (index <= length) {
                char nextCh;
                if (index == length) {
                    words.add(query.substring(start2));
                    continue block0;
                }
                if ((nextCh = query.charAt(index++)) != ':' && nextCh != ' ' && index != length) continue;
                words.add(query.substring(start2, nextCh == ' ' ? index - 1 : index));
                continue block0;
            }
        }
        return words;
    }

    @NotNull
    public static String getTagQuery(@NotNull String tag2) {
        return "/tag:" + (tag2.indexOf(32) == -1 ? tag2 : StringUtil.wrapWithDoubleQuote((String)tag2));
    }

    @NotNull
    public static String wrapAttribute(@NotNull String value2) {
        return StringUtil.containsAnyChar((String)value2, (String)" ,:") ? StringUtil.wrapWithDoubleQuote((String)value2) : value2;
    }

    public static class Installed
    extends SearchQueryParser {
        public final Set<String> vendors = new HashSet<String>();
        public final Set<String> tags = new HashSet<String>();
        public boolean enabled;
        public boolean disabled;
        public boolean bundled;
        public boolean downloaded;
        public boolean invalid;
        public boolean needUpdate;
        public boolean attributes;

        public Installed(@NotNull String query) {
            this.parse(query);
        }

        private void parse(@NotNull String query) {
            List<String> words = Installed.splitQuery(query);
            int size = words.size();
            if (size == 0) {
                return;
            }
            int index = 0;
            while (index < size) {
                String name;
                if ((name = words.get(index++)).startsWith("/")) {
                    if (name.equals(SearchWords.ORGANIZATION.getValue()) || name.equals(SearchWords.TAG.getValue())) {
                        if (index < size) {
                            this.handleAttribute(name, words.get(index++));
                            continue;
                        }
                        this.addToSearchQuery(query);
                        break;
                    }
                    this.handleAttribute(name, "");
                    continue;
                }
                this.addToSearchQuery(name);
            }
            this.attributes = this.enabled || this.disabled || this.bundled || this.downloaded || this.invalid || this.needUpdate;
        }

        protected void handleAttribute(@NotNull String name, @NotNull String value2) {
            if ("/enabled".equals(name)) {
                this.enabled = true;
            } else if ("/disabled".equals(name)) {
                this.disabled = true;
            } else if ("/bundled".equals(name)) {
                this.bundled = true;
            } else if ("/downloaded".equals(name)) {
                this.downloaded = true;
            } else if ("/invalid".equals(name)) {
                this.invalid = true;
            } else if ("/outdated".equals(name)) {
                this.needUpdate = true;
            } else if (SearchWords.ORGANIZATION.getValue().equals(name)) {
                this.vendors.add(value2);
            } else if (SearchWords.TAG.getValue().equals(name)) {
                this.tags.add(value2);
            }
        }
    }

    public static class Marketplace
    extends SearchQueryParser {
        public final Set<String> vendors = new HashSet<String>();
        public final Set<String> tags = new HashSet<String>();
        public final Set<String> repositories = new HashSet<String>();
        public String sortBy;

        public Marketplace(@NotNull String query) {
            this.parse(query);
        }

        private void parse(@NotNull String query) {
            List<String> words = Marketplace.splitQuery(query);
            int size = words.size();
            if (size == 0) {
                return;
            }
            if (size == 1) {
                this.addToSearchQuery(words.get(0));
                return;
            }
            int index = 0;
            while (index < size) {
                String name;
                if ((name = words.get(index++)).endsWith(":")) {
                    if (index < size) {
                        this.handleAttribute(name, words.get(index++));
                        continue;
                    }
                    this.addToSearchQuery(query);
                    return;
                }
                this.addToSearchQuery(name);
            }
        }

        protected void handleAttribute(@NotNull String name, @NotNull String value2) {
            if (name.equals(SearchWords.TAG.getValue())) {
                this.tags.add(value2);
            } else if (name.equals(SearchWords.SORT_BY.getValue())) {
                this.sortBy = value2;
            } else if (name.equals(SearchWords.REPOSITORY.getValue())) {
                this.repositories.add(value2);
            } else if (name.equals(SearchWords.ORGANIZATION.getValue())) {
                this.vendors.add(value2);
            }
        }

        @NotNull
        public String getUrlQuery() {
            StringBuilder url = new StringBuilder();
            if ("featured".equals(this.sortBy)) {
                url.append("is_featured_search=true");
            } else if ("updated".equals(this.sortBy)) {
                url.append("orderBy=update+date");
            } else if ("downloads".equals(this.sortBy)) {
                url.append("orderBy=downloads");
            } else if ("rating".equals(this.sortBy)) {
                url.append("orderBy=rating");
            } else if ("name".equals(this.sortBy)) {
                url.append("orderBy=name");
            }
            for (String tag2 : this.tags) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("tags=").append(URLUtil.encodeURIComponent((String)tag2));
            }
            for (String vendor : this.vendors) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("organization=").append(URLUtil.encodeURIComponent((String)vendor));
            }
            if (this.searchQuery != null) {
                if (url.length() > 0) {
                    url.append("&");
                }
                url.append("search=").append(URLUtil.encodeURIComponent((String)this.searchQuery));
            }
            return url.toString();
        }
    }
}

