/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUpdatesService {
    private static final List<PluginUpdatesService> SERVICES = new ArrayList<PluginUpdatesService>();
    private static Collection<PluginDownloader> myCache;
    private static boolean myPrepared;
    private static boolean myPreparing;
    private static boolean myReset;
    private Consumer<Integer> myTreeCallback;
    private Consumer<Integer> myTabCallback;
    private Consumer<? super Collection<PluginDownloader>> myInstalledPanelCallback;
    private Consumer<? super Collection<PluginDownloader>> myUpdatePanelCallback;

    @NotNull
    public static PluginUpdatesService connectTreeRenderer(@NotNull Consumer<Integer> callback2) {
        PluginUpdatesService.checkAccess();
        PluginUpdatesService service = new PluginUpdatesService();
        SERVICES.add(service);
        service.myTreeCallback = callback2;
        if (myPrepared) {
            callback2.accept(PluginUpdatesService.getCount());
        } else {
            PluginUpdatesService.calculateUpdates();
        }
        return service;
    }

    @NotNull
    public static PluginUpdatesService connectConfigurable(@NotNull Consumer<Integer> callback2) {
        PluginUpdatesService.checkAccess();
        PluginUpdatesService service = new PluginUpdatesService();
        SERVICES.add(service);
        service.myTabCallback = callback2;
        if (myPrepared) {
            callback2.accept(PluginUpdatesService.getCount());
        } else {
            PluginUpdatesService.calculateUpdates();
        }
        return service;
    }

    public void connectInstalled(@NotNull Consumer<? super Collection<PluginDownloader>> callback2) {
        PluginUpdatesService.checkAccess();
        this.myInstalledPanelCallback = callback2;
        if (myPrepared) {
            callback2.accept(myCache);
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    public void calculateUpdates(@NotNull Consumer<? super Collection<PluginDownloader>> callback2) {
        PluginUpdatesService.checkAccess();
        this.myUpdatePanelCallback = callback2;
        if (myPrepared) {
            callback2.accept(myCache);
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    public void finishUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginUpdatesService.checkAccess();
        if (!myPrepared || myCache == null) {
            return;
        }
        Iterator<PluginDownloader> I = myCache.iterator();
        while (I.hasNext()) {
            PluginDownloader downloader = I.next();
            if (downloader.getDescriptor() != descriptor2) continue;
            I.remove();
            Integer countValue = PluginUpdatesService.getCount();
            for (PluginUpdatesService service : SERVICES) {
                service.runCountCallbacks(countValue);
            }
            return;
        }
    }

    public void finishUpdate() {
        PluginUpdatesService.checkAccess();
        if (!myPrepared || myCache == null) {
            return;
        }
        Integer countValue = PluginUpdatesService.getCount();
        for (PluginUpdatesService service : SERVICES) {
            service.runCountCallbacks(countValue);
        }
    }

    public void recalculateUpdates() {
        PluginUpdatesService.checkAccess();
        for (PluginUpdatesService service : SERVICES) {
            service.runAllCallbacks(0);
        }
        if (myPreparing) {
            PluginUpdatesService.resetUpdates();
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    private static void resetUpdates() {
        myReset = true;
    }

    public void dispose() {
        PluginUpdatesService.checkAccess();
        PluginUpdatesService.dispose(this);
    }

    private static void dispose(@NotNull PluginUpdatesService service) {
        SERVICES.remove(service);
        if (SERVICES.isEmpty()) {
            myCache = null;
            myPrepared = false;
            myPreparing = false;
        }
    }

    public static boolean isNeedUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginUpdatesService.checkAccess();
        PluginId pluginId = descriptor2.getPluginId();
        if (myPrepared && myCache != null) {
            for (PluginDownloader downloader : myCache) {
                if (pluginId != downloader.getId()) continue;
                return true;
            }
        }
        return InstalledPluginsState.getInstance().hasNewerVersion(pluginId);
    }

    @Nullable
    public static Collection<PluginDownloader> getUpdates() {
        PluginUpdatesService.checkAccess();
        return !myPrepared || myPreparing || myCache == null ? null : myCache;
    }

    private static void calculateUpdates() {
        if (myPreparing) {
            return;
        }
        myPreparing = true;
        myCache = null;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Collection<PluginDownloader> updates = UpdateChecker.getPluginUpdates();
            ApplicationManager.getApplication().invokeLater(() -> {
                PluginUpdatesService.checkAccess();
                myPreparing = false;
                if (myReset) {
                    myReset = false;
                    PluginUpdatesService.calculateUpdates();
                    return;
                }
                myPrepared = true;
                myCache = updates;
                Integer countValue = PluginUpdatesService.getCount();
                for (PluginUpdatesService service : SERVICES) {
                    service.runAllCallbacks(countValue);
                }
            }, ModalityState.any());
        });
    }

    private void runAllCallbacks(@Nullable Integer countValue) {
        this.runCountCallbacks(countValue);
        if (this.myInstalledPanelCallback != null) {
            this.myInstalledPanelCallback.accept(myCache);
        }
        if (this.myUpdatePanelCallback != null) {
            this.myUpdatePanelCallback.accept(myCache);
        }
    }

    private void runCountCallbacks(@Nullable Integer countValue) {
        if (this.myTreeCallback != null) {
            this.myTreeCallback.accept(countValue);
        }
        if (this.myTabCallback != null) {
            this.myTabCallback.accept(countValue);
        }
    }

    @Nullable
    private static Integer getCount() {
        return myCache == null ? null : Integer.valueOf(myCache.size());
    }

    private static void checkAccess() {
        assert (SwingUtilities.isEventDispatchThread());
    }
}

