/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

public class PluginPriceService {
    private static final Logger LOG = Logger.getInstance(PluginPriceService.class);
    private static final DecimalFormat FORMAT = new DecimalFormat("###.#");
    private static final Map<String, Object> myPriceTable = new HashMap<String, Object>();
    private static boolean myPrepared;
    private static boolean myPreparing;

    public static void getPrice(@NotNull IdeaPluginDescriptor descriptor2, @NotNull Consumer<String> callback2, @NotNull Consumer<String> asyncCallback) {
        PluginPriceService.checkAccess();
        String code = descriptor2.getProductCode();
        if (myPrepared) {
            Object value2 = myPriceTable.get(code);
            if (value2 instanceof String) {
                callback2.consume((Object)((String)value2));
            }
        } else {
            myPriceTable.put(code, asyncCallback);
            if (!myPreparing) {
                myPreparing = true;
                PluginPriceService.loadPrice();
            }
        }
    }

    public static void cancel() {
        PluginPriceService.checkAccess();
        PluginPriceService.clear();
    }

    private static void clear() {
        Iterator<Map.Entry<String, Object>> I = myPriceTable.entrySet().iterator();
        while (I.hasNext()) {
            Map.Entry<String, Object> entry = I.next();
            if (!(entry.getValue() instanceof Consumer)) continue;
            I.remove();
        }
    }

    private static void loadPrice() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Object priceJson = PluginPriceService.getPluginPricesJsonObject();
                if (priceJson instanceof Map) {
                    Map<String, String> result2 = PluginPriceService.parsePrices((Map)priceJson);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        PluginPriceService.checkAccess();
                        for (Map.Entry entry : result2.entrySet()) {
                            Object callback2 = myPriceTable.put((String)entry.getKey(), entry.getValue());
                            if (!(callback2 instanceof Consumer)) continue;
                            ((Consumer)callback2).consume(entry.getValue());
                        }
                        PluginPriceService.clear();
                        myPrepared = true;
                        myPreparing = false;
                    }, ModalityState.any());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOG.debug((Throwable)e);
            }
        });
    }

    @Nullable
    private static Object getPluginPricesJsonObject() throws IOException {
        ApplicationInfoEx instance = ApplicationInfoImpl.getShadowInstance();
        Url url = Urls.newFromEncoded((String)(instance.getPluginManagerUrl() + "/geo/files/prices"));
        return HttpRequests.request((Url)url).throwStatusCodeException(false).productNameAsUserAgent().connect(request2 -> {
            URLConnection connection = request2.getConnection();
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() != 200) {
                return null;
            }
            try (JsonReaderEx json = new JsonReaderEx(FileUtil.loadTextAndClose((Reader)request2.getReader()));){
                Object object = JsonUtil.nextAny(json);
                return object;
            }
        });
    }

    @NotNull
    private static Map<String, String> parsePrices(@NotNull Map<String, Object> jsonObject) {
        HashMap<String, String> result2 = new HashMap<String, String>();
        Object plugins = jsonObject.get("plugins");
        if (plugins instanceof List) {
            String currency = PluginPriceService.parseCurrency(jsonObject);
            for (Map plugin : (List)plugins) {
                Double price;
                Object code = plugin.get("code");
                if (!(code instanceof String) || (price = PluginPriceService.parsePrice(plugin)) == null) continue;
                result2.put((String)code, currency + FORMAT.format(price));
            }
        }
        return result2;
    }

    @NotNull
    private static String parseCurrency(@NotNull Map<String, Object> jsonObject) {
        Currency currency;
        Object iso = jsonObject.get("iso");
        if (iso instanceof String && (currency = Currency.getInstance((String)iso)) != null) {
            return currency.getSymbol(Locale.ENGLISH);
        }
        return "";
    }

    @Nullable
    private static Double parsePrice(@NotNull Map<String, Object> plugin) {
        double[] personal = PluginPriceService.parsePrice(plugin, "personal");
        double[] commercial = PluginPriceService.parsePrice(plugin, "commercial");
        if (personal == null && commercial == null) {
            return null;
        }
        if (personal == null || commercial == null) {
            for (double value2 : personal == null ? commercial : personal) {
                if (!(value2 > 0.0)) continue;
                return value2;
            }
        } else {
            for (int i2 = 0; i2 < 2; ++i2) {
                if (!(personal[i2] > 0.0) || !(commercial[i2] > 0.0)) continue;
                return Math.min(personal[i2], commercial[i2]);
            }
        }
        return null;
    }

    @Nullable
    private static double[] parsePrice(@NotNull Map<String, Object> jsonObject, @NotNull String key) {
        Object subscription;
        Object value2 = jsonObject.get(key);
        if (value2 instanceof Map && (subscription = ((Map)value2).get("subscription")) instanceof Map) {
            return new double[]{PluginPriceService.parsePriceValue((Map)subscription, "monthly"), PluginPriceService.parsePriceValue((Map)subscription, "annual")};
        }
        return null;
    }

    private static double parsePriceValue(@NotNull Map<String, Object> jsonObject, @NotNull String key) {
        Object value2 = jsonObject.get(key);
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        if (value2 instanceof String) {
            try {
                return Double.parseDouble((String)value2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    private static void checkAccess() {
        assert (SwingUtilities.isEventDispatchThread());
    }
}

