/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.PluginPriceService;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Consumer;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.function.Supplier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LicensePanel
extends NonOpaquePanel {
    private final JLabel mySubMessage = new JLabel();
    private final JPanel myPanel = new NonOpaquePanel((LayoutManager)((Object)new HorizontalLayout(JBUI.scale((int)5))));
    private final JLabel myMessage = new JLabel();
    private final LinkLabel<Object> myLink = new LinkLabel();

    public LicensePanel(boolean tiny) {
        this.setLayout(new BorderLayout());
        this.myLink.setIconTextGap(0);
        this.myLink.setHorizontalTextPosition(2);
        this.add(tiny ? PluginManagerConfigurable.setTinyFont(this.mySubMessage) : this.mySubMessage, "North");
        this.add(this.myPanel);
        this.myPanel.add(tiny ? PluginManagerConfigurable.setTinyFont(this.myMessage) : this.myMessage);
        this.myPanel.add((Component)(tiny ? PluginManagerConfigurable.setTinyFont(this.myLink) : this.myLink));
        this.hideElements();
    }

    public boolean isNotification() {
        return this.myMessage.getIcon() != null || this.myMessage.isForegroundSet();
    }

    @Nullable
    public String getMessage() {
        String text = this.myMessage.getText();
        if (this.mySubMessage.isVisible()) {
            return this.mySubMessage.getText() + "\n" + text;
        }
        if (StringUtil.endsWithChar((CharSequence)text, (char)'.')) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    public void setText(@NotNull @Nls String text, boolean warning, boolean errorColor) {
        int separator = text.indexOf(10);
        if (separator == -1) {
            this.myMessage.setText(text);
            this.myMessage.setIcon(warning ? AllIcons.General.Warning : null);
        } else {
            this.mySubMessage.setText(text.substring(0, separator));
            this.mySubMessage.setIcon(warning ? AllIcons.General.Warning : null);
            this.mySubMessage.setVisible(true);
            this.myMessage.setText(text.substring(separator + 1));
            this.myMessage.setIcon(warning ? EmptyIcon.ICON_16 : null);
        }
        this.myMessage.setForeground(errorColor ? DialogWrapper.ERROR_FOREGROUND_COLOR : null);
        this.myMessage.setVisible(true);
        this.myPanel.setVisible(true);
    }

    public void setTextFromStamp(@NotNull String stamp, @Nullable Date expirationDate) {
        long days;
        long l = days = expirationDate == null ? 0L : DateFormatUtil.getDifferenceInDays((Date)new Date(), (Date)expirationDate);
        if (stamp.startsWith("eval:")) {
            if (days <= 0L) {
                this.setText(IdeBundle.message((String)"trial.expired", (Object[])new Object[0]), false, true);
            } else {
                this.setText(IdeBundle.message((String)"plugins.configurable.trial.expires.in.0.days", (Object[])new Object[]{days}), days < 11L, false);
            }
        } else if (expirationDate == null) {
            this.setText(IdeBundle.message((String)"plugins.configurable.license.is.active", (Object[])new Object[0]), false, false);
        } else if (days > 30L) {
            this.setText(IdeBundle.message((String)"plugins.configurable.license.is.active.until.0", (Object[])new Object[]{PluginManagerConfigurable.DATE_FORMAT.format(expirationDate)}), false, false);
        } else if (days <= 0L) {
            this.setText(IdeBundle.message((String)"plugins.configurable.license.expired", (Object[])new Object[0]), false, true);
        } else {
            this.setText(IdeBundle.message((String)"plugins.configurable.license.expires.in.0.days", (Object[])new Object[]{days}), days < 11L, false);
        }
    }

    public void setLink(@NotNull @Nls String text, @NotNull Runnable action2, boolean external) {
        this.myLink.setText(text);
        this.myLink.setIcon(external ? AllIcons.Ide.External_link_arrow : null);
        this.myLink.setListener((__, ___) -> action2.run(), null);
        this.myLink.setVisible(true);
        this.myPanel.setVisible(true);
    }

    public void updateLink(@NotNull @Nls String text, boolean async) {
        this.myLink.setText(text);
        if (async) {
            this.myPanel.doLayout();
        }
    }

    public void hideWithChildren() {
        this.hideElements();
        this.setVisible(false);
    }

    private void hideElements() {
        this.mySubMessage.setVisible(false);
        this.myMessage.setVisible(false);
        this.myLink.setVisible(false);
        this.myPanel.setVisible(false);
    }

    public void showBuyPlugin(@NotNull Supplier<? extends IdeaPluginDescriptor> getPlugin) {
        IdeaPluginDescriptor plugin = getPlugin.get();
        this.setLink(IdeBundle.message((String)"plugins.configurable.buy.the.plugin", (Object[])new Object[0]), () -> BrowserUtil.browse((String)("https://plugins.jetbrains.com/purchase-link/" + plugin.getProductCode())), true);
        PluginPriceService.getPrice(plugin, (Consumer<String>)((Consumer)price -> this.updateLink(IdeBundle.message((String)"plugins.configurable.buy.the.plugin.from.0", (Object[])new Object[]{price}), false)), (Consumer<String>)((Consumer)price -> {
            if (plugin == getPlugin.get()) {
                this.updateLink(IdeBundle.message((String)"plugins.configurable.buy.the.plugin.from.0", (Object[])new Object[]{price}), true);
            }
        }));
    }

    public static boolean isEA2Product(@Nullable String productCodeOrPluginId) {
        LicensingFacade instance = LicensingFacade.getInstance();
        return productCodeOrPluginId != null && instance != null && instance.isEA2Product(productCodeOrPluginId);
    }
}

