/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.newui.EmptyCaret;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorComponent {
    private static final String KEY = "EnableCallback";

    @NotNull
    public static JComponent create(@NotNull JPanel panel2, @Nullable Object constraints2) {
        final JEditorPane editorPane = new JEditorPane();
        panel2.add((Component)editorPane, constraints2);
        ErrorComponent.convertToLabel(editorPane);
        HTMLEditorKit kit = UIUtil.getHTMLEditorKit();
        StyleSheet sheet = kit.getStyleSheet();
        sheet.addRule("span {color: " + ColorUtil.toHtmlColor((Color)DialogWrapper.ERROR_FOREGROUND_COLOR) + "}");
        sheet.addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor()) + "}");
        editorPane.setEditorKit(kit);
        editorPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                Object callback2 = editorPane.getClientProperty(ErrorComponent.KEY);
                if (callback2 instanceof Runnable) {
                    ApplicationManager.getApplication().invokeLater((Runnable)callback2, ModalityState.any());
                }
            }
        });
        return editorPane;
    }

    public static void convertToLabel(@NotNull JEditorPane editorPane) {
        editorPane.setEditable(false);
        editorPane.setFocusable(false);
        editorPane.setOpaque(false);
        editorPane.setBorder(null);
        editorPane.setContentType("text/html");
        editorPane.setCaret(EmptyCaret.INSTANCE);
    }

    public static void show(@NotNull JComponent errorComponent, @NotNull String message, @Nullable String action2, @Nullable Runnable enableCallback) {
        JEditorPane editorPane = (JEditorPane)errorComponent;
        editorPane.setText("<html><span>" + StringUtil.escapeXmlEntities((String)message) + "</span>" + (enableCallback == null ? "" : "&nbsp;<a href='link'>" + action2 + "</a>") + "</html>");
        editorPane.putClientProperty(KEY, enableCallback);
    }

    @NotNull
    public static JComponent show(@NotNull JPanel panel2, @Nullable Object constraints2, @Nullable JComponent errorComponent, @NotNull String message, @Nullable String action2, @Nullable Runnable enableCallback) {
        JComponent component2 = errorComponent == null ? ErrorComponent.create(panel2, constraints2) : errorComponent;
        ErrorComponent.show(component2, message, action2, enableCallback);
        return component2;
    }
}

