/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.HorizontalLayout;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagPanel
extends NonOpaquePanel {
    private final LinkListener<Object> mySearchListener;

    public TagPanel(@NotNull LinkListener<Object> searchListener) {
        super((LayoutManager)((Object)new HorizontalLayout(JBUIScale.scale((int)6))));
        this.mySearchListener = searchListener;
        this.setBorder((Border)JBUI.Borders.emptyTop((int)2));
    }

    public void setTags(@NotNull List<String> tags) {
        TagComponent component2;
        int i2;
        if (tags.isEmpty()) {
            this.setVisible(false);
            return;
        }
        int newSize = tags.size();
        int oldSize = this.getComponentCount();
        int commonSize = Math.min(newSize, oldSize);
        for (i2 = 0; i2 < commonSize; ++i2) {
            component2 = (TagComponent)((Object)this.getComponent(i2));
            component2.setToolTipText(null);
            component2.setText(tags.get(i2));
            component2.setVisible(true);
        }
        if (newSize > oldSize) {
            for (i2 = oldSize; i2 < newSize; ++i2) {
                component2 = new TagComponent(tags.get(i2));
                this.add((Component)((Object)PluginManagerConfigurable.setTinyFont(component2)));
                component2.setListener(this.mySearchListener, (Object)component2);
            }
        } else if (newSize < oldSize) {
            for (i2 = newSize; i2 < oldSize; ++i2) {
                this.getComponent(i2).setVisible(false);
            }
        }
        this.setVisible(true);
    }

    public void setFirstTagTooltip(@Nullable @NlsContexts.Tooltip String text) {
        if (this.getComponentCount() > 0) {
            ((JComponent)this.getComponent(0)).setToolTipText(text);
        }
    }

    public int getBaseline(int width, int height) {
        int count = this.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Component component2 = this.getComponent(i2);
            if (!component2.isVisible()) continue;
            Dimension size = component2.getPreferredSize();
            return component2.getY() + component2.getBaseline(size.width, size.height);
        }
        return -1;
    }
}

