/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RepositoryHelper {
    private static final Logger LOG = Logger.getInstance(RepositoryHelper.class);
    private static final String PLUGIN_LIST_FILE = "availables.xml";
    private static final String MARKETPLACE_PLUGIN_ID = "com.intellij.marketplace";
    private static final String ULTIMATE_MODULE = "com.intellij.modules.ultimate";

    @NotNull
    public static List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>(UpdateSettings.getInstance().getPluginHosts());
        ContainerUtil.addIfNotNull(hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.add(null);
        return hosts;
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPluginsFromCustomRepositories(@Nullable ProgressIndicator indicator) {
        ArrayList<IdeaPluginDescriptor> result2 = new ArrayList<IdeaPluginDescriptor>();
        HashSet<PluginId> addedPluginIds = new HashSet<PluginId>();
        for (String host : RepositoryHelper.getPluginHosts()) {
            if (host == null && ApplicationInfoEx.getInstanceEx().usesJetBrainsPluginRepository()) continue;
            try {
                List<IdeaPluginDescriptor> plugins = RepositoryHelper.loadPlugins(host, indicator);
                for (IdeaPluginDescriptor plugin : plugins) {
                    if (!addedPluginIds.add(plugin.getPluginId())) continue;
                    result2.add(plugin);
                }
            }
            catch (IOException e) {
                LOG.info("Couldn't load plugins from" + host + ":" + e);
                LOG.debug((Throwable)e);
            }
        }
        return result2;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable ProgressIndicator indicator) throws IOException {
        return RepositoryHelper.loadPlugins(null, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable ProgressIndicator indicator) throws IOException {
        return RepositoryHelper.loadPlugins(repositoryUrl, null, indicator);
    }

    @NotNull
    public static List<IdeaPluginDescriptor> loadPlugins(@Nullable String repositoryUrl, @Nullable BuildNumber build2, @Nullable ProgressIndicator indicator) throws IOException {
        File pluginListFile;
        Url url;
        if (repositoryUrl == null) {
            LOG.error("Using deprecated API for getting plugins from Marketplace");
            String base = ApplicationInfoImpl.getShadowInstance().getPluginsListUrl();
            url = Urls.newFromEncoded((String)base).addParameters(Collections.singletonMap("uuid", PermanentInstallationID.get()));
            pluginListFile = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        } else {
            url = Urls.newFromEncoded((String)repositoryUrl);
            pluginListFile = null;
        }
        if (!"file".equals(url.getScheme())) {
            url = url.addParameters(Collections.singletonMap("build", build2 != null ? build2.asString() : MarketplaceRequests.getInstance().getBuildForPluginRepositoryRequests()));
        }
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{url.getAuthority()}));
        }
        List descriptors = (List)MarketplaceRequests.getInstance().readOrUpdateFile(pluginListFile, url.toExternalForm(), indicator, IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[]{url.getAuthority()}), reader -> MarketplaceRequests.parsePluginList(reader));
        return RepositoryHelper.process(descriptors, repositoryUrl, build2);
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    public static List<IdeaPluginDescriptor> loadCachedPlugins() throws IOException {
        File file2 = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE);
        return file2.length() > 0L ? RepositoryHelper.process(RepositoryHelper.loadPluginList(file2), null, null) : null;
    }

    private static List<PluginNode> loadPluginList(File file2) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file2)), StandardCharsets.UTF_8);){
            List<PluginNode> list2 = MarketplaceRequests.parsePluginList(reader);
            return list2;
        }
    }

    @NotNull
    private static List<IdeaPluginDescriptor> process(@NotNull List<PluginNode> list2, @Nullable String repositoryUrl, @Nullable BuildNumber build2) {
        LinkedHashMap<PluginId, PluginNode> result2 = new LinkedHashMap<PluginId, PluginNode>(list2.size());
        if (build2 == null) {
            build2 = PluginManagerCore.getBuildNumber();
        }
        boolean isPaidPluginsRequireMarketplacePlugin = RepositoryHelper.isPaidPluginsRequireMarketplacePlugin();
        for (PluginNode node : list2) {
            IdeaPluginDescriptor previous;
            PluginId pluginId = node.getPluginId();
            if (pluginId == null || repositoryUrl != null && node.getDownloadUrl() == null) {
                LOG.debug("Malformed plugin record (id:" + pluginId + " repository:" + repositoryUrl + ")");
                continue;
            }
            if (PluginManagerCore.isBrokenPlugin(node) || PluginManagerCore.isIncompatible(node, build2)) {
                LOG.debug("An incompatible plugin (id:" + pluginId + " repository:" + repositoryUrl + ")");
                continue;
            }
            if (repositoryUrl != null) {
                node.setRepositoryName(repositoryUrl);
            }
            if (node.getName() == null) {
                String url = node.getDownloadUrl();
                node.setName(FileUtilRt.getNameWithoutExtension((String)url.substring(url.lastIndexOf(47) + 1)));
            }
            if ((previous = (IdeaPluginDescriptor)result2.get(pluginId)) == null || VersionComparatorUtil.compare((String)node.getVersion(), (String)previous.getVersion()) > 0) {
                result2.put(pluginId, node);
            }
            RepositoryHelper.addMarketplacePluginDependencyIfRequired(node, isPaidPluginsRequireMarketplacePlugin);
        }
        return new ArrayList<IdeaPluginDescriptor>(result2.values());
    }

    public static void addMarketplacePluginDependencyIfRequired(@NotNull PluginNode node) {
        boolean isPaidPluginsRequireMarketplacePlugin = RepositoryHelper.isPaidPluginsRequireMarketplacePlugin();
        RepositoryHelper.addMarketplacePluginDependencyIfRequired(node, isPaidPluginsRequireMarketplacePlugin);
    }

    private static boolean isPaidPluginsRequireMarketplacePlugin() {
        boolean isCommunityIDE = !RepositoryHelper.ideContainsUltimateModule();
        boolean isVendorNotJetBrains = !ApplicationInfoImpl.getShadowInstance().isVendorJetBrains();
        return isCommunityIDE || isVendorNotJetBrains;
    }

    private static void addMarketplacePluginDependencyIfRequired(@NotNull PluginNode node, boolean isPaidPluginsRequireMarketplacePlugin) {
        if (isPaidPluginsRequireMarketplacePlugin && node.getProductCode() != null) {
            node.addDepends(MARKETPLACE_PLUGIN_ID, false);
        }
    }

    private static boolean ideContainsUltimateModule() {
        IdeaPluginDescriptor corePlugin2 = PluginManagerCore.getPlugin(PluginId.getId((String)"com.intellij"));
        IdeaPluginDescriptorImpl corePluginImpl = corePlugin2 instanceof IdeaPluginDescriptorImpl ? (IdeaPluginDescriptorImpl)corePlugin2 : null;
        return corePluginImpl != null && corePluginImpl.getModules().contains(PluginId.getId((String)ULTIMATE_MODULE));
    }
}

