/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.openapi.util.SafeJdomFactory;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.AttributeType;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PluginXmlFactory
extends SafeJdomFactory.BaseSafeJdomFactory {
    private static final List<String> CLASS_NAME_LIST = Arrays.asList("implementation-class", "implementation", "serviceImplementation", "class", "className", "beanClass", "serviceInterface", "interface", "interfaceClass", "instance", "qualifiedName");
    private static final Set<String> CLASS_NAMES = new ReferenceOpenHashSet(CLASS_NAME_LIST);
    private static final List<String> EXTRA_STRINGS = Arrays.asList("id", "JetBrains", "com.intellij.applicationService", "com.intellij.projectService", "com.intellij.moduleService");
    private final ObjectOpenHashSet<String> strings = new ObjectOpenHashSet(CLASS_NAMES.size() + EXTRA_STRINGS.size());
    final DateFormat releaseDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
    final List<String> visitedFiles = new ArrayList<String>(3);

    PluginXmlFactory() {
        this.strings.addAll(CLASS_NAMES);
        this.strings.addAll(EXTRA_STRINGS);
    }

    @NotNull
    String intern(@NotNull String string) {
        return string.length() < 64 ? (String)this.strings.addOrGet((Object)string) : string;
    }

    @NotNull
    public Element element(@NotNull String name, @Nullable Namespace namespace) {
        return super.element(this.intern(name), namespace);
    }

    @NotNull
    public Attribute attribute(@NotNull String name, @NotNull String value2, @Nullable AttributeType type, @Nullable Namespace namespace) {
        String internedName = this.intern(name);
        if (CLASS_NAMES.contains(internedName)) {
            return super.attribute(internedName, value2, type, namespace);
        }
        return super.attribute(internedName, this.intern(value2), type, namespace);
    }

    @NotNull
    public Text text(@NotNull String text, @NotNull Element parentElement) {
        return new Text(CLASS_NAMES.contains(parentElement.getName()) ? text : this.intern(text));
    }
}

